CREATE TABLE uk_towns (id int NOT NULL, name varchar(56), county varchar(32), country varchar(16), grid_reference varchar(8), easting int, northing int, latitude numeric(8,5), longitude numeric(8,5), elevation int, postcode_sector varchar(6), local_government_area varchar(44), nuts_region varchar(24), type varchar(13), PRIMARY KEY (id) );INSERT INTO uk_towns VALUES
(1,'Aaron''s Hill','Surrey','England','SU957435',495783,143522,51.18291,-0.63098,78,'GU7 2','Waverley District','South East','Suburban Area'),
(2,'Abbas Combe','Somerset','England','ST707226',370749,122688,51.00283,-2.41825,91,'BA8 0','Somerset','South West','Village'),
(3,'Abberley','Worcestershire','England','SO744675',374477,267522,52.30522,-2.37574,152,'WR6 6','Malvern Hills District','West Midlands','Village'),
(4,'Abberton','Essex','England','TM006190',600637,219093,51.83440,0.91066,44,'CO5 7','Colchester District','Eastern','Village'),
(5,'Abberton','Worcestershire','England','SO995534',399538,253477,52.17955,-2.00817,68,'WR10 2','Wychavon District','West Midlands','Hamlet'),
(6,'Abberwick','Northumberland','England','NU129132',412938,613277,55.41325,-1.79720,93,'NE66 2','Northumberland','North East','Locality'),
(7,'Abbess End','Essex','England','TL575115',557500,211500,51.78000,0.28172,75,'CM5 0','Epping Forest District','Eastern','Locality'),
(8,'Abbess Roding','Essex','England','TL571112',557170,211283,51.77815,0.27685,70,'CM5 0','Epping Forest District','Eastern','Village'),
(9,'Abbey','Devon','England','ST140106',314090,110654,50.88896,-3.22276,160,'EX14 4','East Devon District','South West','Hamlet'),
(10,'Abbeycwmhir / Abaty Cwm-hir','Powys','Wales','SO053712',305386,271238,52.33104,-3.38988,266,'LD1 6','Powys','Wales','Hamlet'),
(11,'Abbeydale','Gloucestershire','England','SO863164',386373,216413,51.84615,-2.19922,47,'GL4 4','Gloucester District','South West','Suburban Area'),
(12,'Abbeydale','South Yorkshire','England','SK327822',432719,382237,53.33603,-1.51011,112,'S8 0','Sheffield District','Yorkshire and the Humber','Suburban Area'),
(13,'Abbeydale','Worcestershire','England','SP051681',405102,268179,52.31170,-1.92659,90,'B98 8','Redditch District','West Midlands','Suburban Area'),
(14,'Abbeydale Park','South Yorkshire','England','SK317807',431711,380770,53.32291,-1.52539,143,'S17 3','Sheffield District','Yorkshire and the Humber','Suburban Area'),
(15,'Abbey Dore','Herefordshire','England','SO385304',338538,230489,51.96946,-2.89607,93,'HR2 0','County of Herefordshire','West Midlands','Village'),
(16,'Abbey End','Warwickshire','England','SP286718',428680,271865,52.34412,-1.58043,92,'CV8 1','Warwick District','West Midlands','Suburban Area'),
(17,'Abbey Field','Essex','England','TL995245',599500,224500,51.88336,0.89730,38,'CO2 7','Colchester District','Eastern','Locality'),
(18,'Abbey Fields','Warwickshire','England','SP283719',428370,271950,52.34490,-1.58497,81,'CV8 1','Warwick District','West Midlands','Suburban Area'),
(19,'Abbey Gate','Devon','England','SY295975',329500,97500,50.77278,-3.00118,55,'EX13 5','East Devon District','South West','Locality'),
(20,'Abbey Green','Shropshire','England','SJ506331',350666,333195,52.89393,-2.73475,102,'SY13 2','Shropshire','West Midlands','Hamlet'),
(21,'Abbey Green','Staffordshire','England','SJ979577',397900,357773,53.11713,-2.03283,174,'ST13 8','Staffordshire Moorlands District','West Midlands','Hamlet'),
(22,'Abbey Hey','Greater Manchester','England','SJ895965',389500,396500,53.46514,-2.15963,87,'M18 8','Manchester District','North West','Locality'),
(23,'Abbeyhill','City of Edinburgh','Scotland','NT270744',327066,674436,55.95738,-3.16970,40,'EH7 5','City of Edinburgh','Scotland','Suburban Area'),
(24,'Abbey Hulton','Staffordshire','England','SJ907486',390708,348651,53.03506,-2.14002,136,'ST2 8','City of Stoke-on-Trent','West Midlands','Suburban Area'),
(25,'Abbey Mead','Surrey','England','TQ045675',504500,167500,51.39692,-0.49929,14,'KT16 8','Runnymede District','South East','Locality'),
(26,'Abbey Meads','Wiltshire','England','SU141891',414197,189131,51.60084,-1.79642,107,'SN25 4','Swindon','South West','Suburban Area'),
(27,'Abbey Parks','Fife','Scotland','NT091873',309108,687303,56.06989,-3.46159,89,'KY12 7','Fife','Scotland','Suburban Area'),
(28,'Abbey St Bathans','Berwickshire','Scotland','NT762618',376241,661858,55.84934,-2.38104,148,'TD11 3','Scottish Borders','Scotland','Hamlet'),
(29,'Abbeystead','Lancashire','England','SD563543',356356,454382,53.98364,-2.66703,115,'LA2 9','Lancaster District','North West','Hamlet'),
(30,'Abbeytown','Cumbria','England','NY172507',317279,550746,54.84466,-3.28970,14,'CA7 4','Cumberland','North West','Village'),
(31,'Abbey Village','Lancashire','England','SD640227',364054,422764,53.70007,-2.54594,161,'PR6 8','Chorley District','North West','Village'),
(32,'Abbey Wood','Greater London','England','TQ464789',546447,178983,51.49083,0.10803,4,'SE2 9','Greenwich','London','Suburban Area'),
(33,'Abbey Yard','The Stewartry of Kirkcudbright','Scotland','NX735645',273500,564500,54.95903,-3.97713,50,'DG7 2','Dumfries and Galloway','Scotland','Locality'),
(34,'Abbotrule','Roxburgh, Ettrick and Lauderdale','Scotland','NT609130',360910,613000,55.40936,-2.61892,169,'TD9 8','Scottish Borders','Scotland','Locality'),
(35,'Abbots Bickington','Devon','England','SS384134',238400,113405,50.89745,-4.29936,164,'EX22 7','Torridge District','South West','Hamlet'),
(36,'Abbots Bromley','Staffordshire','England','SK083244',408370,324413,52.81719,-1.87725,119,'WS15 3','East Staffordshire District','West Midlands','Village'),
(37,'Abbotsbury','Devon','England','SX858715',285818,71596,50.53296,-3.61246,21,'TQ12 2','Teignbridge District','South West','Suburban Area'),
(38,'Abbotsbury','Dorset','England','SY577852',357725,85274,50.66559,-2.59953,43,'DT3 4','Dorset','South West','Village'),
(39,'Abbotsford','West Sussex','England','TQ303209',530382,120922,50.97296,-0.14434,29,'RH15 8','Mid Sussex District','South East','Hamlet'),
(40,'Abbotsham','Devon','England','SS424264',242457,126488,51.01613,-4.24738,61,'EX39 5','Torridge District','South West','Village'),
(41,'Abbotside','Gloucestershire','England','ST687906',368783,190617,51.61351,-2.45223,66,'GL12 8','South Gloucestershire','South West','Locality'),
(42,'Abbotskerswell','Devon','England','SX856687',285694,68785,50.50767,-3.61335,31,'TQ12 5','Teignbridge District','South West','Village'),
(43,'Abbots Langley','Hertfordshire','England','TL094019',509444,201966,51.70577,-0.41754,128,'WD5 0','Three Rivers District','Eastern','Village'),
(44,'Abbots Leigh','Somerset','England','ST537737',353799,173737,51.46071,-2.66640,86,'BS8 3','North Somerset','South West','Village'),
(45,'Abbotsley','Cambridgeshire','England','TL229565',522933,256521,52.19323,-0.20294,45,'PE19 6','Huntingdonshire District','Eastern','Village'),
(46,'Abbotsmead','Cumbria','England','SD215695',321568,469564,54.11594,-3.20135,22,'LA13 0','Westmorland and Furness','North West','Suburban Area'),
(47,'Abbot''s Mead','Cheshire','England','SJ398681',339886,368119,53.20672,-2.90149,8,'CH1 4','Cheshire West and Chester','North West','Suburban Area'),
(48,'Abbot''s Meads','Cheshire','England','SJ395675',339500,367500,53.20112,-2.90716,7,'CH1 5','Cheshire West and Chester','North West','Locality'),
(49,'Abbots Morton','Worcestershire','England','SP028550',402806,255084,52.19399,-1.96037,67,'WR7 4','Wychavon District','West Midlands','Village'),
(50,'Abbots Ripton','Cambridgeshire','England','TL230781',523054,278110,52.38720,-0.19329,42,'PE28 2','Huntingdonshire District','Eastern','Village'),
(51,'Abbot''s Salford','Warwickshire','England','SP068502',406865,250286,52.15082,-1.90108,34,'WR11 8','Stratford-on-Avon District','West Midlands','Village'),
(52,'Abbotstone','Hampshire','England','SU563345',456309,134523,51.10725,-1.19707,66,'SO24 9','Winchester District','South East','Hamlet'),
(53,'Abbotswood','Hampshire','England','SU361234',436115,123445,51.00926,-1.48660,37,'SO51 7','Test Valley District','South East','Village'),
(54,'Abbotswood','Surrey','England','TQ008513',500853,151305,51.25201,-0.55628,48,'GU1 1','Guildford District','South East','Suburban Area'),
(55,'Abbotswood','Worcestershire','England','SO889492',388916,249266,52.14157,-2.16338,46,'WR5 3','Wychavon District','West Midlands','Hamlet'),
(56,'Abbots Worthy','Hampshire','England','SU497326',449752,132684,51.09132,-1.29097,53,'SO21 1','Winchester District','South East','Village'),
(57,'Abbotts Ann','Hampshire','England','SU328435',432844,143599,51.19068,-1.53140,62,'SP11 7','Test Valley District','South East','Village'),
(58,'Abbotts Barton','Hampshire','England','SU481308',448185,130848,51.07494,-1.31359,69,'SO23 7','Winchester District','South East','Suburban Area'),
(59,'Abcott','Shropshire','England','SO391786',339121,278600,52.40201,-2.89624,135,'SY7 0','Shropshire','West Midlands','Hamlet'),
(60,'Abdon','Shropshire','England','SO574863',357407,286349,52.47340,-2.62848,251,'SY7 9','Shropshire','West Midlands','Hamlet'),
(61,'Abdy','South Yorkshire','England','SK435985',443500,398500,53.48143,-1.34598,71,'S62 7','Rotherham District','Yorkshire and the Humber','Locality'),
(62,'Abenhall','Gloucestershire','England','SO669173',366974,217339,51.85366,-2.48090,154,'GL17 0','Forest of Dean District','South West','Locality'),
(63,'Aber','Dyfed','Wales','SN477484',247713,248429,52.11315,-4.22539,201,'SA40 9','Ceredigion / Sir Ceredigion','Wales','Hamlet'),
(64,'Aber','Powys','Wales','SO105213',310511,221379,51.88376,-3.30157,162,'LD3 7','Powys','Wales','Hamlet'),
(65,'Aberaeron','Dyfed','Wales','SN458628',245842,262858,52.24226,-4.25925,6,'SA46 0','Ceredigion / Sir Ceredigion','Wales','Town'),
(66,'Aberaman','Mid Glamorgan','Wales','SO012013',301296,201300,51.70173,-3.42969,139,'CF44 6','Rhondda Cynon Taf','Wales','Suburban Area'),
(67,'Aberangell','Gwynedd','Wales','SH843103',284380,310311,52.67812,-3.71160,84,'SY20 9','Gwynedd','Wales','Village'),
(68,'Aber-Arad','Dyfed','Wales','SN315403',231571,240356,52.03596,-4.45692,39,'SA38 9','Carmarthenshire / Sir Gaerfyrddin','Wales','Suburban Area'),
(69,'Aberarder','Inverness','Scotland','NN475875',247500,787500,56.95353,-4.50913,291,'PH20 1','Highland','Scotland','Locality'),
(70,'Aberargie','Perth and Kinross','Scotland','NO161157',316149,715774,56.32690,-3.35753,17,'PH2 9','Perth and Kinross','Scotland','Village'),
(71,'Aberarth','Dyfed','Wales','SN479636',247989,263665,52.25011,-4.22820,23,'SA46 0','Ceredigion / Sir Ceredigion','Wales','Village'),
(72,'Aberavon','West Glamorgan','Wales','SS752898',275272,189812,51.59331,-3.80199,10,'SA12 6','Neath Port Talbot / Castell-nedd Port Talbot','Wales','Suburban Area'),
(73,'Aber-banc','Dyfed','Wales','SN356417',235610,241747,52.04967,-4.39876,83,'SA44 5','Ceredigion / Sir Ceredigion','Wales','Village'),
(74,'Aberbargoed / Aberbargod','Gwent','Wales','SO154001',315484,200147,51.69369,-3.22416,211,'CF81 9','Caerphilly / Caerffili','Wales','Village'),
(75,'Aberbechan','Powys','Wales','SO136940',313636,294040,52.53735,-3.27475,110,'SY16 3','Powys','Wales','Hamlet'),
(76,'Aberbeeg / Aber-big','Gwent','Wales','SO207019',320776,201907,51.71028,-3.14801,160,'NP13 2','Blaenau Gwent','Wales','Village'),
(77,'Aberbran','Powys','Wales','SN984296',298420,229650,51.95603,-3.47962,160,'LD3 9','Powys','Wales','Hamlet'),
(78,'Abercanaid','Mid Glamorgan','Wales','SO058036',305851,203644,51.72359,-3.36443,156,'CF48 1','Merthyr Tydfil / Merthyr Tudful','Wales','Village'),
(79,'Abercarn','Gwent','Wales','ST215948',321584,194893,51.64734,-3.13475,104,'NP11 5','Caerphilly / Caerffili','Wales','Town'),
(80,'Abercastle','Dyfed','Wales','SM854334',185407,233471,51.95820,-5.12466,24,'SA62 5','Pembrokeshire / Sir Benfro','Wales','Hamlet'),
(81,'Abercegir','Powys','Wales','SH802017',280291,301751,52.60032,-3.76894,62,'SY20 8','Powys','Wales','Village'),
(82,'Aberchalder','Inverness','Scotland','NH338036',233863,803610,57.09339,-4.74371,34,'PH35 4','Highland','Scotland','Hamlet'),
(83,'Aberchirder','Banffshire','Scotland','NJ624524',362477,852418,57.56028,-2.62878,146,'AB54 7','Aberdeenshire','Scotland','Town'),
(84,'Aber-Clydach','West Glamorgan','Wales','SN687012',268787,201233,51.69447,-3.89984,26,'SA6 5','Swansea / Abertawe','Wales','Suburban Area'),
(85,'Abercorn','West Lothian','Scotland','NT082788',308230,678889,55.99415,-3.47281,42,'EH30 9','West Lothian','Scotland','Hamlet'),
(86,'Abercrave / Abercraf','Powys','Wales','SN816126',281684,212634,51.79980,-3.71722,132,'SA9 1','Powys','Wales','Village'),
(87,'Abercregan','West Glamorgan','Wales','SS850965',285016,196589,51.65629,-3.66362,190,'SA13 3','Neath Port Talbot / Castell-nedd Port Talbot','Wales','Village'),
(88,'Abercrombie','Fife','Scotland','NO517028',351785,702846,56.21573,-2.77899,36,'KY10 2','Fife','Scotland','Hamlet'),
(89,'Abercwmboi','Mid Glamorgan','Wales','ST025999',302560,199938,51.68971,-3.41103,119,'CF44 6','Rhondda Cynon Taf','Wales','Suburban Area'),
(90,'Abercych','Dyfed','Wales','SN248408',224855,240894,52.03871,-4.55500,24,'SA37 0','Pembrokeshire / Sir Benfro','Wales','Village'),
(91,'Abercynon','Mid Glamorgan','Wales','ST081949',308177,194982,51.64611,-3.32849,87,'CF45 4','Rhondda Cynon Taf','Wales','Town'),
(92,'Aber-Cywarch','Gwynedd','Wales','SH868157',286844,315774,52.72773,-3.67705,102,'SY20 9','Gwynedd','Wales','Hamlet'),
(93,'Aberdalgie','Perth and Kinross','Scotland','NO078202',307889,720245,56.36552,-3.49262,52,'PH2 0','Perth and Kinross','Scotland','Locality'),
(94,'Aberdare / Aberdâr','Mid Glamorgan','Wales','SO000026',300072,202640,51.71356,-3.44778,131,'CF44 7','Rhondda Cynon Taf','Wales','Town'),
(95,'Aberdaron','Gwynedd','Wales','SH176271',217624,327107,52.81058,-4.70736,42,'LL53 8','Gwynedd','Wales','Village'),
(96,'Aberdeen','City of Aberdeen','Scotland','NJ944065',394426,806556,57.14985,-2.09376,19,'AB24 5','Aberdeen City','Scotland','City'),
(97,'Aberdesach','Gwynedd','Wales','SH425513',242593,351337,53.03608,-4.34901,8,'LL54 5','Gwynedd','Wales','Village'),
(98,'Aberdour','Fife','Scotland','NT190853',319018,685305,56.05372,-3.30185,34,'KY3 0','Fife','Scotland','Village'),
(99,'Aberdovey / Aberdyfi','Gwynedd','Wales','SN614959',261463,295975,52.54395,-4.04434,3,'LL35 0','Gwynedd','Wales','Village'),
(100,'Aberdulais','West Glamorgan','Wales','SS773995',277395,199578,51.68154,-3.77478,21,'SA10 8','Neath Port Talbot / Castell-nedd Port Talbot','Wales','Village'),
(101,'Aberedw','Powys','Wales','SO078473',307871,247394,52.11716,-3.34692,136,'LD2 3','Powys','Wales','Village'),
(102,'Aber Eiddy','Dyfed','Wales','SM798312',179815,231251,51.93609,-5.20449,24,'SA62 6','Pembrokeshire / Sir Benfro','Wales','Hamlet'),
(103,'Abererch','Gwynedd','Wales','SH398366',239805,336661,52.90344,-4.38329,7,'LL53 6','Gwynedd','Wales','Village'),
(104,'Aberfan','Mid Glamorgan','Wales','SO070001',307066,200199,51.69282,-3.34593,138,'CF48 4','Merthyr Tydfil / Merthyr Tudful','Wales','Village'),
(105,'Aberfeldy','Perth and Kinross','Scotland','NN854490',285442,749023,56.61901,-3.86844,102,'PH15 2','Perth and Kinross','Scotland','Town'),
(106,'Aberffraw','Gwynedd','Wales','SH354688',235423,368872,53.19140,-4.46484,16,'LL63 5','Isle of Anglesey / Sir Ynys Mon','Wales','Village'),
(107,'Aberffrwd','Dyfed','Wales','SN686788',268649,278832,52.39171,-3.93168,63,'SY23 3','Ceredigion / Sir Ceredigion','Wales','Hamlet'),
(108,'Aberford','West Yorkshire','England','SE433372',443343,437258,53.82978,-1.34296,43,'LS25 3','Leeds District','Yorkshire and the Humber','Village'),
(109,'Aberfoyle','Stirling and Falkirk','Scotland','NN524009',252440,700933,56.17811,-4.37868,24,'FK8 3','Stirling','Scotland','Village'),
(110,'Abergarw','Mid Glamorgan','Wales','SS909850',290937,185066,51.55390,-3.57447,71,'CF32 8','Bridgend / Pen-y-bont ar Ogwr','Wales','Suburban Area'),
(111,'Abergarwed','West Glamorgan','Wales','SN816023',281657,202384,51.70767,-3.71412,32,'SA11 4','Neath Port Talbot / Castell-nedd Port Talbot','Wales','Village'),
(112,'Abergavenny / Y Fenni','Gwent','Wales','SO299141',329906,214193,51.82194,-3.01838,65,'NP7 5','Monmouthshire / Sir Fynwy','Wales','Town'),
(113,'Abergeirw','Gwynedd','Wales','SH765283',276582,328304,52.83807,-3.83366,288,'LL40 2','Gwynedd','Wales','Hamlet'),
(114,'Abergeldie','Aberdeenshire','Scotland','NO286950',328648,795098,57.04142,-3.17750,265,'AB35 5','Aberdeenshire','Scotland','Hamlet'),
(115,'Abergele','Clwyd','Wales','SH945775',294567,377548,53.28438,-3.58292,17,'LL22 7','Conwy','Wales','Town'),
(116,'Aber-Giâr','Dyfed','Wales','SN503410',250363,241094,52.04798,-4.18350,144,'SA40 9','Carmarthenshire / Sir Gaerfyrddin','Wales','Hamlet'),
(117,'Abergorlech','Dyfed','Wales','SN584336',258483,233615,51.98292,-4.06208,78,'SA32 7','Carmarthenshire / Sir Gaerfyrddin','Wales','Village'),
(118,'Abergwesyn','Powys','Wales','SN854527',285477,252748,52.16109,-3.67564,263,'LD5 4','Powys','Wales','Hamlet'),
(119,'Abergwili','Dyfed','Wales','SN436213',243659,221326,51.86854,-4.27218,8,'SA31 2','Carmarthenshire / Sir Gaerfyrddin','Wales','Village'),
(120,'Abergwynfi','West Glamorgan','Wales','SS893961',289334,196164,51.65334,-3.60109,301,'SA13 3','Neath Port Talbot / Castell-nedd Port Talbot','Wales','Village'),
(121,'Abergwyngregyn','Gwynedd','Wales','SH655726',265591,372664,53.23395,-4.01522,32,'LL33 0','Gwynedd','Wales','Village'),
(122,'Abergynolwyn','Gwynedd','Wales','SH677070',267710,307003,52.64459,-3.95669,37,'LL36 9','Gwynedd','Wales','Village'),
(123,'Aberhafesp','Powys','Wales','SO068923',306895,292382,52.52133,-3.37364,126,'SY16 3','Powys','Wales','Village'),
(124,'Aberhosan','Powys','Wales','SN811973',281172,297397,52.56139,-3.75437,140,'SY20 8','Powys','Wales','Village'),
(125,'Aberkenfig / Abercynffig','Mid Glamorgan','Wales','SS893835',289357,183578,51.54022,-3.59678,40,'CF32 9','Bridgend / Pen-y-bont ar Ogwr','Wales','Village'),
(126,'Aberlady','East Lothian','Scotland','NT465799',346543,679954,56.00952,-2.85890,11,'EH32 0','East Lothian','Scotland','Village'),
(127,'Aberlemno','Angus','Scotland','NO521556',352122,755696,56.69053,-2.78326,137,'DD8 3','Angus','Scotland','Hamlet'),
(128,'Aberlerry','Dyfed','Wales','SN605925',260500,292500,52.51249,-4.05707,4,'SY24 5','Ceredigion / Sir Ceredigion','Wales','Locality'),
(129,'Aberllefenni','Gwynedd','Wales','SH770099',277057,309983,52.67356,-3.81973,115,'SY20 9','Gwynedd','Wales','Village'),
(130,'Abermagwr','Dyfed','Wales','SN665738',266566,273809,52.34607,-3.96027,55,'SY23 4','Ceredigion / Sir Ceredigion','Wales','Hamlet'),
(131,'Abermeurig','Dyfed','Wales','SN560559',256015,255978,52.18320,-4.10744,101,'SA48 8','Ceredigion / Sir Ceredigion','Wales','Hamlet'),
(132,'Abermorddu','Clwyd','Wales','SJ308568',330888,356836,53.10422,-3.03375,93,'LL12 9','Flintshire / Sir y Fflint','Wales','Village'),
(133,'Abermorlais','Mid Glamorgan','Wales','SO047064',304732,206492,51.74900,-3.38141,182,'CF47 8','Merthyr Tydfil / Merthyr Tudful','Wales','Suburban Area'),
(134,'Abermule / Aber-miwl','Powys','Wales','SO162947',316229,294751,52.54414,-3.23671,95,'SY15 6','Powys','Wales','Village'),
(135,'Aber-nant','Clwyd','Wales','SJ276428',327622,342854,52.97813,-3.07938,113,'LL14 3','Wrexham / Wrecsam','Wales','Suburban Area'),
(136,'Abernant','Dyfed','Wales','SN340232',234045,223210,51.88269,-4.41259,95,'SA33 5','Carmarthenshire / Sir Gaerfyrddin','Wales','Hamlet'),
(137,'Abernant','Mid Glamorgan','Wales','SO008032',300898,203257,51.71925,-3.43601,157,'CF44 0','Rhondda Cynon Taf','Wales','Suburban Area'),
(138,'Abernethy','Perth and Kinross','Scotland','NO190163',319013,716355,56.33262,-3.31141,38,'PH2 9','Perth and Kinross','Scotland','Village'),
(139,'Abernyte','Perth and Kinross','Scotland','NO258312',325856,731224,56.46729,-3.20498,117,'PH14 9','Perth and Kinross','Scotland','Village'),
(140,'Aber-oer','Clwyd','Wales','SJ285490',328516,349006,53.03354,-3.06743,183,'LL14 4','Wrexham / Wrecsam','Wales','Hamlet'),
(141,'Aberporth','Dyfed','Wales','SN261512',226131,251298,52.13256,-4.54172,34,'SA43 2','Ceredigion / Sir Ceredigion','Wales','Village'),
(142,'Aber Pwll','Gwynedd','Wales','SH533682',253374,368284,53.19137,-4.19611,20,'LL56 4','Gwynedd','Wales','Suburban Area'),
(143,'Aber Rhaeadr','Powys','Wales','SJ130249',313040,324903,52.81463,-3.29169,125,'SY10 0','Powys','Wales','Hamlet'),
(144,'Abersoch','Gwynedd','Wales','SH313281',231358,328183,52.82472,-4.50436,10,'LL53 7','Gwynedd','Wales','Village'),
(145,'Abersychan','Gwent','Wales','SO264046',326401,204663,51.73582,-3.06720,285,'NP4 7','Torfaen - Torfaen','Wales','Town'),
(146,'Aber-Tafol','Gwynedd','Wales','SN649969',264905,296949,52.55357,-3.99401,16,'LL35 0','Gwynedd','Wales','Hamlet'),
(147,'Aberthin','South Glamorgan','Wales','ST010753',301022,175300,51.46798,-3.42632,46,'CF71 7','The Vale of Glamorgan / Bro Morgannwg','Wales','Village'),
(148,'Abertillery / Abertyleri','Gwent','Wales','SO217041',321789,204126,51.73037,-3.13386,229,'NP13 1','Blaenau Gwent','Wales','Town'),
(149,'Abertridwr','Gwent','Wales','ST120893',312034,189353,51.59613,-3.27134,141,'CF83 4','Caerphilly / Caerffili','Wales','Village'),
(150,'Abertridwr','Powys','Wales','SJ033191',303373,319125,52.76106,-3.43337,238,'SY10 0','Powys','Wales','Village'),
(151,'Abertrinant','Gwynedd','Wales','SH635055',263500,305500,52.63004,-4.01825,136,'LL36 9','Gwynedd','Wales','Locality'),
(152,'Abertysswg','Gwent','Wales','SO131055',313148,205594,51.74229,-3.25931,257,'NP22 5','Caerphilly / Caerffili','Wales','Village'),
(153,'Aberuthven','Perth and Kinross','Scotland','NN980153',298046,715364,56.31966,-3.64999,39,'PH3 1','Perth and Kinross','Scotland','Village'),
(154,'Aber Village','Powys','Wales','SO105215',310500,221500,51.88485,-3.30176,160,'LD3 7','Powys','Wales','Locality'),
(155,'Aberwheeler / Aberchwiler','Clwyd','Wales','SJ096693',309676,369354,53.21354,-3.35404,51,'LL16 4','Denbighshire / Sir Ddinbych','Wales','Village'),
(156,'Aberyscir','Powys','Wales','SN999298',299942,229892,51.95848,-3.45755,157,'LD3 9','Powys','Wales','Hamlet'),
(157,'Aberystwyth','Dyfed','Wales','SN583817',258382,281709,52.41499,-4.08367,11,'SY23 1','Ceredigion / Sir Ceredigion','Wales','Town'),
(158,'Abingdon-on-Thames','Oxfordshire','England','SU498970',449821,197063,51.67014,-1.28098,57,'OX14 3','Vale of White Horse District','South East','Town'),
(159,'Abinger Bottom','Surrey','England','TQ127447',512759,144761,51.19096,-0.38780,200,'RH5 6','Mole Valley District','South East','Hamlet'),
(160,'Abinger Common','Surrey','England','TQ117456',511759,145693,51.19953,-0.40182,169,'RH5 6','Mole Valley District','South East','Village'),
(161,'Abinger Hammer','Surrey','England','TQ096472',509653,147276,51.21417,-0.43146,96,'RH5 6','Mole Valley District','South East','Village'),
(162,'Abington','Lanarkshire','Scotland','NS931233',293192,623331,55.49206,-3.69204,251,'ML12 6','South Lanarkshire','Scotland','Village'),
(163,'Abington','Northamptonshire','England','SP780613',478041,261367,52.24496,-0.85840,81,'NN3 3','West Northamptonshire','East Midlands','Suburban Area'),
(164,'Abington Pigotts','Cambridgeshire','England','TL307444',530720,244481,52.08326,-0.09371,28,'SG8 0','South Cambridgeshire District','Eastern','Village'),
(165,'Abington Vale','Northamptonshire','England','SP784609',478496,260970,52.24133,-0.85183,66,'NN3 3','West Northamptonshire','East Midlands','Suburban Area'),
(166,'Abingworth','West Sussex','England','TQ101167',510177,116725,50.93945,-0.43327,45,'RH20 3','Horsham District','South East','Hamlet'),
(167,'Ab Kettleby','Leicestershire','England','SK723230',472372,323040,52.80007,-0.92801,145,'LE14 3','Melton District','East Midlands','Village'),
(168,'Ab Lench','Worcestershire','England','SP012517',401233,251798,52.16445,-1.98339,67,'WR11 4','Wychavon District','West Midlands','Hamlet'),
(169,'Ablington','Gloucestershire','England','SP104076',410449,207635,51.76730,-1.84998,112,'GL7 5','Cotswold District','South West','Village'),
(170,'Ablington','Wiltshire','England','SU159469',415958,146989,51.22188,-1.77288,81,'SP4 8','Wiltshire','South West','Hamlet'),
(171,'Abney','Derbyshire','England','SK197798',419789,379806,53.31482,-1.70443,303,'S32 1','Derbyshire Dales District','East Midlands','Hamlet'),
(172,'Above Church','Staffordshire','England','SK016504',401641,350404,53.05089,-1.97697,255,'ST10 2','Staffordshire Moorlands District','West Midlands','Hamlet'),
(173,'Aboyne','Aberdeenshire','Scotland','NO520985',352079,798596,57.07588,-2.79208,138,'AB34 5','Aberdeenshire','Scotland','Village'),
(174,'Abraham Heights','Lancashire','England','SD465612',346552,461225,54.04421,-2.81772,22,'LA1 5','Lancaster District','North West','Suburban Area'),
(175,'Abram','Greater Manchester','England','SD607015',360794,401586,53.50949,-2.59264,41,'WN2 5','Wigan District','North West','Village'),
(176,'Abram Brow','Greater Manchester','England','SD609014',360950,401409,53.50791,-2.59027,41,'WN2 5','Wigan District','North West','Suburban Area'),
(177,'Abriachan','Inverness','Scotland','NH555354',255574,835424,57.38625,-4.40428,271,'IV3 8','Highland','Scotland','Locality'),
(178,'Abridge','Essex','England','TQ466968',546624,196823,51.65108,0.11802,25,'RM4 1','Epping Forest District','Eastern','Village'),
(179,'Abronhill','Dunbartonshire','Scotland','NS784755',278442,675599,55.95798,-3.94860,111,'G67 3','North Lanarkshire','Scotland','Suburban Area'),
(180,'Abshot','Hampshire','England','SU517055',451773,105584,50.84747,-1.26597,25,'PO14 4','Fareham District','South East','Hamlet'),
(181,'Abson','Gloucestershire','England','ST704748',370470,174869,51.47201,-2.42655,94,'BS30 5','South Gloucestershire','South West','Hamlet'),
(182,'Abthorpe','Northamptonshire','England','SP649464',464964,246445,52.11252,-1.05275,121,'NN12 8','West Northamptonshire','East Midlands','Village'),
(183,'Abune-the-Hill','Orkney','Scotland','HY294283',329408,1028349,59.13606,-3.23533,56,'KW17 2','Orkney Islands','Scotland','Locality'),
(184,'Abwell','Gloucestershire','England','SO683008',368397,200804,51.70508,-2.45873,22,'GL13 9','Stroud District','South West','Hamlet'),
(185,'Aby','Lincolnshire','England','TF412783',541214,378361,53.28342,0.11672,15,'LN13 0','East Lindsey District','East Midlands','Village'),
(186,'Acairseid','Western Isles','Scotland','NF791101',79197,810142,57.07015,-7.29541,9,'HS8 5','Na h-Eileanan an Iar','Scotland','Hamlet'),
(187,'Acarsaid','Inverness','Scotland','NM585725',158500,772500,56.78124,-5.95504,4,'PH36 4','Highland','Scotland','Locality'),
(188,'Acaster Malbis','North Yorkshire','England','SE587454',458778,445447,53.90186,-1.10691,10,'YO23 2','York','Yorkshire and the Humber','Village'),
(189,'Acaster Selby','North Yorkshire','England','SE573414',457387,441406,53.86570,-1.12883,12,'YO23 7','North Yorkshire','Yorkshire and the Humber','Locality'),
(190,'Accrington','Lancashire','England','SD760285',376080,428549,53.75275,-2.36424,140,'BB5 2','Hyndburn District','North West','Town'),
(191,'Acha','Argyll and Bute','Scotland','NM186548',118621,754859,56.60090,-6.58637,33,'PA78 6','Argyll and Bute','Scotland','Hamlet'),
(192,'Achachork / Achadh a''Choirce','Ross and Cromarty','Scotland','NG481458',148103,845818,57.43261,-6.19851,93,'IV51 9','Highland','Scotland','Village'),
(193,'Achadh nan Darach','Inverness','Scotland','NN005555',200500,755500,56.64865,-5.25567,119,'PA38 4','Highland','Scotland','Locality'),
(194,'Achahoish','Argyll and Bute','Scotland','NR779775',177969,677582,55.93985,-5.55683,26,'PA31 8','Argyll and Bute','Scotland','Hamlet'),
(195,'Achaleven','Argyll and Bute','Scotland','NM915335',191500,733500,56.44743,-5.38452,17,'PA37 1','Argyll and Bute','Scotland','Locality'),
(196,'Achalone','Caithness','Scotland','ND153569',315306,956984,58.49279,-3.45459,67,'KW12 6','Highland','Scotland','Locality'),
(197,'Acha Mòr','Western Isles','Scotland','NB315285',131500,928500,58.16346,-6.56695,76,'HS2 9','Na h-Eileanan an Iar','Scotland','Locality'),
(198,'Achamore / An Acha Mor','Western Isles','Scotland','NB318289',131812,928909,58.16731,-6.56214,76,'HS2 9','Na h-Eileanan an Iar','Scotland','Village'),
(199,'Achanalt','Ross and Cromarty','Scotland','NH252615',225226,861576,57.61021,-4.92720,121,'IV23 2','Highland','Scotland','Hamlet'),
(200,'Achandunie','Ross and Cromarty','Scotland','NH644721',264452,872126,57.71839,-4.27720,128,'IV17 0','Highland','Scotland','Hamlet'),
(201,'Achanelid','Argyll and Bute','Scotland','NS005875',200500,687500,56.03870,-5.20408,21,'PA22 3','Argyll and Bute','Scotland','Locality'),
(202,'Ach''an Tobhair','Inverness','Scotland','NN095725',209500,772500,56.80490,-5.12175,100,'PH33 6','Highland','Scotland','Locality'),
(203,'Achany','Sutherland','Scotland','NC569015',256922,901538,57.98000,-4.42114,97,'IV27 4','Highland','Scotland','Hamlet'),
(204,'Achaphubuil','Inverness','Scotland','NN083759',208322,775946,56.83532,-5.14360,37,'PH33 7','Highland','Scotland','Hamlet'),
(205,'Acharacle / Àth-Tharracail','Inverness','Scotland','NM675684',167535,768459,56.74961,-5.80384,12,'PH36 4','Highland','Scotland','Village'),
(206,'Achargary','Sutherland','Scotland','NC725545',272500,954500,58.46008,-4.18700,28,'KW14 7','Highland','Scotland','Locality'),
(207,'Acharn','Perth and Kinross','Scotland','NN756438',275637,743857,56.57013,-4.02563,118,'PH15 2','Perth and Kinross','Scotland','Village'),
(208,'Achastle','Caithness','Scotland','ND231346',323194,934610,58.29336,-3.31183,51,'KW3 6','Highland','Scotland','Hamlet'),
(209,'Achavandra Muir','Sutherland','Scotland','NH770940',277078,894052,57.91884,-4.07669,129,'IV25 3','Highland','Scotland','Locality'),
(210,'Achavanich','Caithness','Scotland','ND179426',317967,942653,58.36463,-3.40382,149,'KW5 6','Highland','Scotland','Locality'),
(211,'Achavar','Caithness','Scotland','ND262370',326280,937066,58.31594,-3.25999,84,'KW3 6','Highland','Scotland','Locality'),
(212,'Achddu','Dyfed','Wales','SN446015',244648,201507,51.69076,-4.24895,29,'SA16 0','Carmarthenshire / Sir Gaerfyrddin','Wales','Suburban Area'),
(213,'Achduart / Achadh Dubhaird','Ross and Cromarty','Scotland','NC049037',204958,903761,57.98019,-5.30025,31,'IV26 2','Highland','Scotland','Locality'),
(214,'Achduchil','Inverness','Scotland','NN593924',259329,792442,57.00164,-4.31757,265,'PH20 1','Highland','Scotland','Hamlet'),
(215,'Acheninver','Ross and Cromarty','Scotland','NC042053',204200,905395,57.99451,-5.31440,16,'IV26 2','Highland','Scotland','Locality'),
(216,'Achfary / Achadh Fairidh','Sutherland','Scotland','NC298387',229849,938735,58.30413,-4.90541,52,'IV27 4','Highland','Scotland','Locality'),
(217,'Achfrish','Sutherland','Scotland','NC564117',256492,911796,58.07192,-4.43466,116,'IV27 4','Highland','Scotland','Hamlet'),
(218,'Achgarve','Ross and Cromarty','Scotland','NG892935',189281,893560,57.88160,-5.55575,12,'IV22 2','Highland','Scotland','Hamlet'),
(219,'Achiemore','Sutherland','Scotland','NC894577',289493,957736,58.49376,-3.89751,29,'KW13 6','Highland','Scotland','Hamlet'),
(220,'A'' Chill','Inverness','Scotland','NG272052',127213,805291,57.05765,-6.50082,9,'PH44 4','Highland','Scotland','Hamlet'),
(221,'Achiltibuie','Ross and Cromarty','Scotland','NC028077',202896,907738,58.01495,-5.33837,44,'IV26 2','Highland','Scotland','Village'),
(222,'Achilty','Ross and Cromarty','Scotland','NH441568',244179,856875,57.57497,-4.60732,35,'IV14 9','Highland','Scotland','Hamlet'),
(223,'Achina','Sutherland','Scotland','NC707610',270738,961004,58.51793,-4.22086,31,'KW14 7','Highland','Scotland','Hamlet'),
(224,'Achindown','Nairn','Scotland','NH839479',283931,847980,57.50709,-3.93884,131,'IV12 5','Highland','Scotland','Locality'),
(225,'Achinduich','Sutherland','Scotland','NH580999',258059,899925,57.96589,-4.40097,126,'IV27 4','Highland','Scotland','Hamlet'),
(226,'Achingills','Caithness','Scotland','ND153627',315311,962714,58.54424,-3.45663,66,'KW12 6','Highland','Scotland','Locality'),
(227,'Achininver','Sutherland','Scotland','NC575645',257500,964500,58.54517,-4.45009,118,'IV27 4','Highland','Scotland','Locality'),
(228,'Achintee','Ross and Cromarty','Scotland','NG941416',194172,841693,57.41884,-5.42923,23,'IV54 8','Highland','Scotland','Hamlet'),
(229,'Achintraid / Achantraid','Ross and Cromarty','Scotland','NG839388',183993,838857,57.38869,-5.59587,5,'IV54 8','Highland','Scotland','Village'),
(230,'Achleck','Argyll and Bute','Scotland','NM415455',141500,745500,56.53021,-6.20544,87,'PA73 6','Argyll and Bute','Scotland','Locality'),
(231,'Achlonan','Argyll and Bute','Scotland','NN007314',200745,731462,56.43315,-5.23324,7,'PA35 1','Argyll and Bute','Scotland','Suburban Area'),
(232,'Achlorachan','Ross and Cromarty','Scotland','NH328551',232886,855147,57.55544,-4.79473,116,'IV6 7','Highland','Scotland','Hamlet'),
(233,'Achluachrach','Inverness','Scotland','NN300810',230023,781057,56.88963,-4.79180,148,'PH31 4','Highland','Scotland','Hamlet'),
(234,'Achlyness','Sutherland','Scotland','NC248525',224852,952500,58.42563,-5.00103,31,'IV27 4','Highland','Scotland','Hamlet'),
(235,'Achmelvich','Sutherland','Scotland','NC057247',205791,924705,58.16836,-5.30351,8,'IV27 4','Highland','Scotland','Locality'),
(236,'Achmore','Ross and Cromarty','Scotland','NH023966',202377,896649,57.91528,-5.33788,49,'IV23 2','Highland','Scotland','Locality'),
(237,'Achmore','Ross and Cromarty','Scotland','NG855335',185587,833527,57.34166,-5.56476,26,'IV53 8','Highland','Scotland','Village'),
(238,'Achnabat','Sutherland','Scotland','NC662627',266227,962701,58.53180,-4.29923,31,'KW14 7','Highland','Scotland','Suburban Area'),
(239,'Achnacarnin','Sutherland','Scotland','NC041318',204156,931838,58.23159,-5.33725,68,'IV27 4','Highland','Scotland','Hamlet'),
(240,'Achnacarry','Inverness','Scotland','NN175879',217526,787906,56.94632,-5.00157,49,'PH34 4','Highland','Scotland','Hamlet'),
(241,'Achnacloich','Ross and Cromarty','Scotland','NG587089',158797,808902,57.10762,-5.98489,4,'IV46 8','Highland','Scotland','Locality'),
(242,'Achnaconeran','Inverness','Scotland','NH416179',241636,817929,57.22462,-4.62467,233,'IV63 7','Highland','Scotland','Locality'),
(243,'Achnacroish','Argyll and Bute','Scotland','NM851409',185132,740975,56.51160,-5.49378,11,'PA34 5','Argyll and Bute','Scotland','Hamlet'),
(244,'Achnagarron','Ross and Cromarty','Scotland','NH683702',268345,870245,57.70267,-4.21087,23,'IV18 0','Highland','Scotland','Hamlet'),
(245,'Achnagoul','Argyll and Bute','Scotland','NN059054',205929,705430,56.20178,-5.13012,86,'PA32 8','Argyll and Bute','Scotland','Locality'),
(246,'Achnaha','Inverness','Scotland','NM462682',146294,768255,56.73672,-6.15007,30,'PH36 4','Highland','Scotland','Hamlet'),
(247,'Achnahanat','Sutherland','Scotland','NH517981',251758,898129,57.94772,-4.50624,85,'IV27 4','Highland','Scotland','Locality'),
(248,'Achnahannet','Inverness','Scotland','NH975275',297500,827500,57.32648,-3.70393,252,'PH26 3','Highland','Scotland','Locality'),
(249,'Achnahard','Argyll and Bute','Scotland','NM395235',139500,723500,56.33200,-6.21596,8,'PA67 6','Argyll and Bute','Scotland','Locality'),
(250,'Achnahuaigh','Sutherland','Scotland','NC579641',257997,964190,58.54255,-4.44136,69,'IV27 4','Highland','Scotland','Suburban Area'),
(251,'Achnairn','Sutherland','Scotland','NC552126',255257,912672,58.07938,-4.45612,126,'IV27 4','Highland','Scotland','Hamlet'),
(252,'Achnamara','Argyll and Bute','Scotland','NR778871',177887,687131,56.02544,-5.56602,5,'PA31 8','Argyll and Bute','Scotland','Village'),
(253,'Achnandarach','Ross and Cromarty','Scotland','NG805311',180512,831109,57.31757,-5.64676,128,'IV52 8','Highland','Scotland','Hamlet'),
(254,'Achnasheen / Achadh na Sine','Ross and Cromarty','Scotland','NH158582',215838,858253,57.57667,-5.08156,160,'IV22 2','Highland','Scotland','Locality'),
(255,'Achnashellach / Achadh na Seileach','Ross and Cromarty','Scotland','NH002481',200215,848183,57.47974,-5.33409,50,'IV54 8','Highland','Scotland','Hamlet'),
(256,'Achnavast','Caithness','Scotland','ND079643',307951,964317,58.55713,-3.58367,51,'KW14 7','Highland','Scotland','Hamlet'),
(257,'Achosnich','Inverness','Scotland','NM444671',144461,767124,56.72558,-6.17883,40,'PH36 4','Highland','Scotland','Hamlet'),
(258,'Achow','Caithness','Scotland','ND230367',323022,936798,58.31298,-3.31549,122,'KW3 6','Highland','Scotland','Locality'),
(259,'Achranich','Inverness','Scotland','NM702473',170225,747383,56.56201,-5.74117,9,'PA80 5','Highland','Scotland','Locality'),
(260,'Achreamie','Caithness','Scotland','ND017666',301798,966642,58.57666,-3.69037,71,'KW14 7','Highland','Scotland','Locality'),
(261,'Achriesgill','Sutherland','Scotland','NC255540',225583,954061,58.43992,-4.98972,11,'IV27 4','Highland','Scotland','Hamlet'),
(262,'Achrimsdale','Sutherland','Scotland','NC906064',290640,906492,58.03405,-3.85366,29,'KW9 6','Highland','Scotland','Hamlet'),
(263,'Achscrabster','Caithness','Scotland','ND084635',308487,963515,58.55005,-3.57414,66,'KW14 7','Highland','Scotland','Locality'),
(264,'Achtalean','Ross and Cromarty','Scotland','NG475465',147500,846500,57.43839,-6.20922,108,'IV51 9','Highland','Scotland','Locality'),
(265,'Achterneed','Ross and Cromarty','Scotland','NH489595',248931,859581,57.60087,-4.52963,48,'IV14 9','Highland','Scotland','Hamlet'),
(266,'Achtoty','Sutherland','Scotland','NC674623',267418,962307,58.52862,-4.27856,19,'KW14 7','Highland','Scotland','Suburban Area'),
(267,'Achurch','Northamptonshire','England','TL024829',502405,282923,52.43470,-0.49511,51,'PE8 5','North Northamptonshire','East Midlands','Hamlet'),
(268,'Achuvoldrach','Sutherland','Scotland','NC567591',256745,959109,58.49655,-4.45966,20,'IV27 4','Highland','Scotland','Locality'),
(269,'Ackenthwaite','Cumbria','England','SD506818',350631,481800,54.22952,-2.75881,35,'LA7 7','Westmorland and Furness','North West','Village'),
(270,'Ackergill','Caithness','Scotland','ND351529',335138,952964,58.46010,-3.11332,31,'KW1 4','Highland','Scotland','Hamlet'),
(271,'Ackergillshore','Caithness','Scotland','ND358544',335846,954404,58.47313,-3.10160,10,'KW1 4','Highland','Scotland','Hamlet'),
(272,'Ackers Crossing','Cheshire','England','SJ847589',384730,358942,53.12742,-2.22966,129,'CW12 3','Cheshire East','North West','Hamlet'),
(273,'Acklam','North Yorkshire','England','NZ483166',448341,516660,54.54290,-1.25430,24,'TS5 7','Middlesbrough','North East','Suburban Area'),
(274,'Acklam','North Yorkshire','England','SE783616',478309,461685,54.04520,-0.80555,122,'YO17 9','North Yorkshire','Yorkshire and the Humber','Village'),
(275,'Ackleton','Shropshire','England','SO770986',377045,298665,52.58530,-2.34023,91,'WV6 7','Shropshire','West Midlands','Village'),
(276,'Acklington','Northumberland','England','NU223018',422305,601809,55.30987,-1.65016,44,'NE65 9','Northumberland','North East','Village'),
(277,'Ackton','West Yorkshire','England','SE411218',441151,421840,53.69139,-1.37831,50,'WF7 6','Wakefield District','Yorkshire and the Humber','Village'),
(278,'Ackworth Moor Top','West Yorkshire','England','SE434162',443455,416200,53.64052,-1.34421,56,'WF7 7','Wakefield District','Yorkshire and the Humber','Village'),
(279,'Acle','Norfolk','England','TG401105',640161,310543,52.63944,1.54816,7,'NR13 3','Broadland District','Eastern','Village'),
(280,'Acocks Green','West Midlands','England','SP118830',411845,283099,52.44573,-1.82716,134,'B27 7','Birmingham District','West Midlands','Suburban Area'),
(281,'Acol','Kent','England','TR307671',630747,167106,51.35614,1.31277,25,'CT7 0','Thanet District','South East','Village'),
(282,'Acomb','Northumberland','England','NY931664',393128,566451,54.99260,-2.10894,79,'NE46 4','Northumberland','North East','Village'),
(283,'Acomb','North Yorkshire','England','SE574513',457419,451399,53.95551,-1.12647,27,'YO24 4','York','Yorkshire and the Humber','Suburban Area'),
(284,'Aconbury','Herefordshire','England','SO515334',351573,233484,51.99768,-2.70677,132,'HR2 6','County of Herefordshire','West Midlands','Locality'),
(285,'Acre','City of Glasgow','Scotland','NS559697',255965,669729,55.89907,-4.30518,44,'G20 0','Glasgow City','Scotland','Suburban Area'),
(286,'Acre','Greater Manchester','England','SD936061',393670,406177,53.55218,-2.09701,211,'OL1 4','Oldham District','North West','Suburban Area'),
(287,'Acre','Lancashire','England','SD787249',378708,424929,53.72033,-2.32413,239,'BB4 5','Rossendale District','North West','Village'),
(288,'Acrefair','Clwyd','Wales','SJ275429',327549,342960,52.97907,-3.08049,113,'LL14 3','Wrexham / Wrecsam','Wales','Village'),
(289,'Acre Ridge Estate','Derbyshire','England','SK421562',442107,356240,53.10170,-1.37256,143,'DE55 7','Amber Valley District','East Midlands','Locality'),
(290,'Acres','Greater Manchester','England','SD891068',389115,406870,53.55834,-2.16579,129,'OL1 2','Oldham District','North West','Locality'),
(291,'Acresford','Leicestershire','England','SK299131',429933,313139,52.71509,-1.55833,79,'DE12 8','North West Leicestershire District','East Midlands','Village'),
(292,'Acres Nook','Staffordshire','England','SJ842532',384230,353233,53.07609,-2.23685,183,'ST6 4','Newcastle-under-Lyme District','West Midlands','Suburban Area'),
(293,'Acrise','Kent','England','TR194423',619488,142383,51.13863,1.13618,151,'CT18 8','Folkestone and Hythe District','South East','Hamlet'),
(294,'Acton','Cheshire','England','SJ632530',363235,353000,53.07296,-2.55019,63,'CW5 8','Cheshire East','North West','Village'),
(295,'Acton','Clwyd','Wales','SJ341518',334185,351819,53.05955,-2.98349,94,'LL12 7','Wrexham / Wrecsam','Wales','Suburban Area'),
(296,'Acton','County Tyrone','Northern Ireland','H885640',288576,364038,54.51700,-6.63300,16,'BT71 4','Mid Ulster','Northern Ireland','Locality'),
(297,'Acton','Dorset','England','SY988784',398894,78460,50.60586,-2.01699,128,'BH19 3','Dorset','South West','Village'),
(298,'Acton','Greater London','England','TQ202800',520280,180066,51.50673,-0.26831,23,'W3 6','Ealing','London','Locality'),
(299,'Acton','Kent','England','TQ906277',590678,127789,51.01786,0.71719,53,'TN30 7','Ashford District','South East','Hamlet'),
(300,'Acton','Shropshire','England','SO313849',331310,284971,52.45835,-3.01234,168,'SY9 5','Shropshire','West Midlands','Hamlet'),
(301,'Acton','Staffordshire','England','SJ823414',382331,341438,52.97000,-2.26454,168,'ST5 4','Newcastle-under-Lyme District','West Midlands','Village'),
(302,'Acton','Suffolk','England','TL893449',589328,244968,52.07071,0.76097,58,'CO10 0','Babergh District','Eastern','Town'),
(303,'Acton','Worcestershire','England','SO844674',384429,267409,52.30458,-2.22978,65,'DY13 9','Wychavon District','West Midlands','Village'),
(304,'Acton Beauchamp','Herefordshire','England','SO676501',367604,250129,52.14849,-2.47487,121,'WR6 5','County of Herefordshire','West Midlands','Hamlet'),
(305,'Acton Bridge','Cheshire','England','SJ596753',359650,375345,53.27354,-2.60652,46,'CW8 3','Cheshire West and Chester','North West','Village'),
(306,'Acton Burnell','Shropshire','England','SJ530020',353088,302022,52.61393,-2.69428,117,'SY5 7','Shropshire','West Midlands','Village'),
(307,'Acton Gate','Staffordshire','England','SJ928192',392852,319232,52.77063,-2.10739,79,'ST17 0','South Staffordshire District','West Midlands','Locality'),
(308,'Acton Green','Greater London','England','TQ201788',520165,178891,51.49620,-0.27036,13,'W4 5','Ealing','London','Suburban Area'),
(309,'Acton Green','Herefordshire','England','SO698499',369802,249998,52.14744,-2.44274,170,'WR6 5','County of Herefordshire','West Midlands','Hamlet'),
(310,'Acton Pigott','Shropshire','England','SJ542027',354243,302799,52.62102,-2.67733,109,'SY5 7','Shropshire','West Midlands','Hamlet'),
(311,'Acton Place','Suffolk','England','TL885455',588500,245500,52.07577,0.74920,55,'CO10 0','Babergh District','Eastern','Locality'),
(312,'Acton Reynald','Shropshire','England','SJ539234',353928,323406,52.80623,-2.68488,109,'SY4 4','Shropshire','West Midlands','Hamlet'),
(313,'Acton Round','Shropshire','England','SO636955',363661,295573,52.55677,-2.53743,149,'WV16 6','Shropshire','West Midlands','Hamlet'),
(314,'Acton Scott','Shropshire','England','SO454899',345416,289967,52.50485,-2.80559,219,'SY6 6','Shropshire','West Midlands','Hamlet'),
(315,'Acton Trussell','Staffordshire','England','SJ936182',393677,318223,52.76157,-2.09514,94,'ST17 0','South Staffordshire District','West Midlands','Village'),
(316,'Acton Turville','Gloucestershire','England','ST810810',381035,181006,51.52764,-2.27477,130,'GL9 1','South Gloucestershire','South West','Village'),
(317,'Adabroc','Western Isles','Scotland','NB535635',153500,963500,58.48978,-6.23146,18,'HS2 0','Na h-Eileanan an Iar','Scotland','Locality'),
(318,'Adambrae','West Lothian','Scotland','NT042658',304241,665886,55.87658,-3.53211,128,'EH54 9','West Lothian','Scotland','Suburban Area'),
(319,'Adamsdown','South Glamorgan','Wales','ST191764',319126,176475,51.48143,-3.16602,12,'CF24 0','Cardiff / Caerdydd','Wales','Suburban Area'),
(320,'Adam''s Green','Dorset','England','ST546075',354693,107598,50.86610,-2.64518,98,'BA22 9','Dorset','South West','Hamlet'),
(321,'Adams Street','Dyfed','Wales','SN654893',265481,289307,52.48505,-3.98243,57,'SY24 5','Ceredigion / Sir Ceredigion','Wales','Locality'),
(322,'Adbaston','Staffordshire','England','SJ766284',376656,328440,52.85295,-2.34810,106,'ST20 0','Stafford District','West Midlands','Village'),
(323,'Adber','Dorset','England','ST598201',359819,120197,50.97977,-2.57374,63,'DT9 4','Dorset','South West','Hamlet'),
(324,'Adbolton','Nottinghamshire','England','SK601382',460177,338268,52.93844,-1.10605,24,'NG2 5','Rushcliffe District','East Midlands','Suburban Area'),
(325,'Adbury','Hampshire','England','SU486634',448625,163408,51.36766,-1.30291,96,'RG20 4','Basingstoke and Deane District','South East','Hamlet'),
(326,'Adderbury','Oxfordshire','England','SP473356',447329,235612,52.01692,-1.31175,104,'OX17 3','Cherwell District','South East','Village'),
(327,'Adderley','Shropshire','England','SJ662397',366257,339780,52.95433,-2.50370,82,'TF9 3','Shropshire','West Midlands','Village'),
(328,'Adderley Green','Staffordshire','England','SJ919447',391972,344738,52.99990,-2.12107,183,'ST3 5','City of Stoke-on-Trent','West Midlands','Suburban Area'),
(329,'Adder''s Moss','Cheshire','England','SJ869767',386921,376719,53.28727,-2.19765,170,'SK10 4','Cheshire East','North West','Village'),
(330,'Addiebrownhill','West Lothian','Scotland','NS988622',298895,662219,55.84255,-3.61615,198,'EH55 8','West Lothian','Scotland','Village'),
(331,'Addiewell','West Lothian','Scotland','NS993627',299396,662754,55.84746,-3.60835,184,'EH55 8','West Lothian','Scotland','Village'),
(332,'Addingford','West Yorkshire','England','SE292177',429212,417758,53.65551,-1.55948,39,'WF4 5','Wakefield District','Yorkshire and the Humber','Suburban Area'),
(333,'Addingham','West Yorkshire','England','SE077497',407793,449772,53.94400,-1.88276,106,'LS29 0','Bradford District','Yorkshire and the Humber','Village'),
(334,'Addingham Moorside','West Yorkshire','England','SE075477',407521,447785,53.92614,-1.88695,244,'LS29 9','Bradford District','Yorkshire and the Humber','Locality'),
(335,'Addington','Buckinghamshire','England','SP743285',474315,228586,51.95081,-0.92010,107,'MK18 2','Buckinghamshire','South East','Hamlet'),
(336,'Addington','Cornwall','England','SX257651',225761,65119,50.45996,-4.45615,145,'PL14 3','Cornwall','South West','Suburban Area'),
(337,'Addington','Greater London','England','TQ371639',537100,163965,51.35822,-0.03232,81,'CR0 5','Croydon','London','Suburban Area'),
(338,'Addington','Kent','England','TQ658588',565878,158881,51.30488,0.37828,48,'ME19 5','Tonbridge and Malling District','South East','Village'),
(339,'Addinston','Roxburgh, Ettrick and Lauderdale','Scotland','NT525535',352500,653500,55.77249,-2.75872,252,'TD2 6','Scottish Borders','Scotland','Locality'),
(340,'Addiscombe','Greater London','England','TQ341660',534103,166010,51.37731,-0.07457,60,'CR0 6','Croydon','London','Suburban Area'),
(341,'Addlestead','Kent','England','TQ660485',566054,148592,51.21239,0.37603,15,'TN12 5','Tonbridge and Malling District','South East','Hamlet'),
(342,'Addlestone','Surrey','England','TQ050645',505003,164591,51.37068,-0.49292,19,'KT15 1','Runnymede District','South East','Town'),
(343,'Addlestonemoor','Surrey','England','TQ052657',505204,165773,51.38127,-0.48969,14,'KT15 2','Runnymede District','South East','Suburban Area'),
(344,'Addlethorpe','Lincolnshire','England','TF548689',554889,368945,53.19503,0.31709,1,'PE24 4','East Lindsey District','East Midlands','Village'),
(345,'Adel','West Yorkshire','England','SE270398',427054,439817,53.85388,-1.59021,148,'LS16 8','Leeds District','Yorkshire and the Humber','Suburban Area'),
(346,'Adel East Moor','West Yorkshire','England','SE279395',427901,439530,53.85126,-1.57736,131,'LS16 8','Leeds District','Yorkshire and the Humber','Suburban Area'),
(347,'Adelphi','Lancashire','England','SD533302',353386,430215,53.76618,-2.70863,35,'PR1 7','Preston District','North West','Suburban Area'),
(348,'Adendale','Kincardineshire','Scotland','NO664921',366483,792198,57.01968,-2.55365,90,'AB31 6','Aberdeenshire','Scotland','Hamlet'),
(349,'Adeney','Shropshire','England','SJ701184',370126,318463,52.76294,-2.44415,65,'TF10 8','Telford and Wrekin','West Midlands','Hamlet'),
(350,'Adeyfield','Hertfordshire','England','TL064074',506486,207405,51.75522,-0.45867,144,'HP2 4','Dacorum District','Eastern','Suburban Area'),
(351,'Adfa','Powys','Wales','SJ059010',305971,301084,52.59938,-3.38972,245,'SY16 3','Powys','Wales','Village'),
(352,'Adforton','Herefordshire','England','SO399711',339969,271101,52.33469,-2.88243,164,'SY7 0','County of Herefordshire','West Midlands','Village'),
(353,'Adgestone','Isle of Wight','England','SZ594862',459487,86224,50.67265,-1.15953,29,'PO36 0','Isle of Wight','South East','Village'),
(354,'Adisham','Kent','England','TR225536',622546,153623,51.23836,1.18678,39,'CT3 3','Canterbury District','South East','Village'),
(355,'Adlestrop','Gloucestershire','England','SP243270',424345,227032,51.94126,-1.64726,135,'GL56 0','Cotswold District','South West','Village'),
(356,'Adley Moor','Herefordshire','England','SO379745',337954,274595,52.36588,-2.91265,127,'SY7 0','County of Herefordshire','West Midlands','Hamlet'),
(357,'Adlingfleet','East Riding of Yorkshire','England','SE843209',484337,420992,53.67860,-0.72468,7,'DN14 8','East Riding of Yorkshire','Yorkshire and the Humber','Village'),
(358,'Adlington','Cheshire','England','SJ914804',391485,380435,53.32077,-2.12929,108,'SK10 4','Cheshire East','North West','Village'),
(359,'Adlington','Lancashire','England','SD605135',360582,413585,53.61732,-2.59735,120,'PR6 9','Chorley District','North West','Town'),
(360,'Adlington Park','Lancashire','England','SD585115',358500,411500,53.59842,-2.62855,70,'WN1 2','Chorley District','North West','Locality'),
(361,'Admaston','Shropshire','England','SJ634129',363435,312948,52.71295,-2.54269,84,'TF5 0','Telford and Wrekin','West Midlands','Suburban Area'),
(362,'Admaston','Staffordshire','England','SK050232',405031,323214,52.80646,-1.92681,128,'WS15 3','East Staffordshire District','West Midlands','Hamlet'),
(363,'Admington','Warwickshire','England','SP202464',420249,246442,52.11593,-1.70570,68,'CV36 4','Stratford-on-Avon District','West Midlands','Hamlet'),
(364,'Adpar','Dyfed','Wales','SN309412',230976,241256,52.04386,-4.46603,71,'SA38 9','Ceredigion / Sir Ceredigion','Wales','Suburban Area'),
(365,'Adsborough','Somerset','England','ST277291',327747,129148,51.05711,-3.03231,67,'TA2 8','Somerset','South West','Village'),
(366,'Adscombe','Somerset','England','ST182378',318212,137854,51.13410,-3.17031,133,'TA5 1','Somerset','South West','Hamlet'),
(367,'Adsdean','West Sussex','England','SU795091',479546,109196,50.87680,-0.87075,53,'PO18 9','Chichester District','South East','Hamlet'),
(368,'Adstock','Buckinghamshire','England','SP737302',473767,230222,51.96559,-0.92772,97,'MK18 2','Buckinghamshire','South East','Village'),
(369,'Adstone','Northamptonshire','England','SP595515',459513,251537,52.15891,-1.13145,161,'NN12 8','West Northamptonshire','East Midlands','Village'),
(370,'Adswood','Greater Manchester','England','SJ888882',388817,388287,53.39130,-2.16962,68,'SK3 8','Stockport District','North West','Suburban Area'),
(371,'Adversane','West Sussex','England','TQ073233',507356,123320,50.99927,-0.47146,18,'RH14 9','Horsham District','South East','Village'),
(372,'Advie','Inverness','Scotland','NJ122341',312276,834119,57.38900,-3.46100,188,'PH26 3','Highland','Scotland','Locality'),
(373,'Adwalton','West Yorkshire','England','SE224281',422464,428180,53.74951,-1.66083,196,'BD11 1','Leeds District','Yorkshire and the Humber','Suburban Area'),
(374,'Adwell','Oxfordshire','England','SU696995',469633,199551,51.69040,-0.99404,90,'OX9 7','South Oxfordshire District','South East','Hamlet'),
(375,'Adwick le Street','South Yorkshire','England','SE539086',453998,408670,53.57186,-1.18606,10,'DN6 7','Doncaster District','Yorkshire and the Humber','Town'),
(376,'Adwick upon Dearne','South Yorkshire','England','SE469016',446952,401654,53.50948,-1.29350,28,'S64 0','Doncaster District','Yorkshire and the Humber','Village'),
(377,'Ae','Dumfries','Scotland','NX984892',298481,589249,55.18706,-3.59601,134,'DG1 1','Dumfries and Galloway','Scotland','Village'),
(378,'Ae Bridgend','Dumfries','Scotland','NY010867',301079,586765,55.16528,-3.55435,98,'DG1 3','Dumfries and Galloway','Scotland','Hamlet'),
(379,'Affetside','Greater Manchester','England','SD755135',375560,413535,53.61778,-2.37094,268,'BL8 3','Bury District','North West','Village'),
(380,'Affleck','Aberdeenshire','Scotland','NJ865235',386500,823500,57.30189,-2.22568,123,'AB21 0','Aberdeenshire','Scotland','Locality'),
(381,'Affpuddle','Dorset','England','SY806936',380606,93615,50.74182,-2.27622,43,'DT2 7','Dorset','South West','Village'),
(382,'Afon Eitha','Clwyd','Wales','SJ292452',329202,345238,52.99976,-3.05638,165,'LL14 2','Wrexham / Wrecsam','Wales','Suburban Area'),
(383,'Afon-wen','Clwyd','Wales','SJ131716',313132,371619,53.23447,-3.30292,94,'CH7 5','Flintshire / Sir y Fflint','Wales','Village'),
(384,'Afon Wen','Gwynedd','Wales','SH437375',243761,337569,52.91276,-4.32496,13,'LL53 6','Gwynedd','Wales','Hamlet'),
(385,'Afton','Isle of Wight','England','SZ350865',435083,86557,50.67762,-1.50483,16,'PO40 9','Isle of Wight','South East','Suburban Area'),
(386,'Afton Bridgend','Ayrshire and Arran','Scotland','NS620133',262062,613321,55.39439,-4.17943,189,'KA18 4','East Ayrshire','Scotland','Suburban Area'),
(387,'Agar Nook','Leicestershire','England','SK454141',445413,314192,52.72348,-1.32905,179,'LE67 4','North West Leicestershire District','East Midlands','Suburban Area'),
(388,'Agbrigg','West Yorkshire','England','SE345190',434564,419068,53.66696,-1.47836,28,'WF1 5','Wakefield District','Yorkshire and the Humber','Suburban Area'),
(389,'Aggborough','Worcestershire','England','SO834755',383461,275563,52.37785,-2.24438,64,'DY10 1','Wyre Forest District','West Midlands','Suburban Area'),
(390,'Agglethorpe','North Yorkshire','England','SE087864',408704,486467,54.27378,-1.86784,244,'DL8 4','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(391,'Aghacommon','County Armagh','Northern Ireland','J048589',304891,358928,54.46800,-6.38300,34,'BT66 6','Armagh City Banbridge and Craigavon','Northern Ireland','Locality'),
(392,'Aghadowey','County Derry / Londonderry','Northern Ireland','C862210',286250,421007,55.02900,-6.65200,34,'BT51 4','Causeway Coast and Glens','Northern Ireland','Locality'),
(393,'Aghadrumsee','County Fermanagh','Northern Ireland','H474313',247475,331319,54.22860,-7.27280,106,'BT92 7','Fermanagh and Omagh','Northern Ireland','Locality'),
(394,'Aghagallon','County Down','Northern Ireland','J105636',310550,363627,54.50900,-6.29400,32,'BT67 0','Armagh City Banbridge and Craigavon','Northern Ireland','Locality'),
(395,'Aghalee','County Antrim','Northern Ireland','J120649',312001,364915,54.52024,-6.27113,31,'BT67 0','Lisburn and Castlereagh','Northern Ireland','Locality'),
(396,'Aglionby','Cumbria','England','NY446564',344667,556449,54.89969,-2.86437,38,'CA4 8','Cumberland','North West','Village'),
(397,'Agneash','Isle of Man','Isle of Man','SC435865',243500,486500,54.25018,-4.40358,240,'IM7 4','Isle of Man','Isle of Man','Locality'),
(398,'Ahmore / Athmòr','Western Isles','Scotland','NF857740',85727,874098,57.64676,-7.26976,7,'HS6 5','Na h-Eileanan an Iar','Scotland','Hamlet'),
(399,'Ahoghill','County Antrim','Northern Ireland','D050015',305001,401584,54.85100,-6.36600,46,'BT42 1','Mid and East Antrim','Northern Ireland','Locality'),
(400,'Aifft','Clwyd','Wales','SJ115695',311500,369500,53.21516,-3.32677,293,'LL16 4','Denbighshire / Sir Ddinbych','Wales','Locality'),
(401,'Aigburth','Merseyside','England','SJ390858',339075,385845,53.36594,-2.91704,28,'L19 9','Liverpool District','North West','Suburban Area'),
(402,'Aigburth Vale','Merseyside','England','SJ381871',338189,387118,53.37728,-2.93060,31,'L17 0','Liverpool District','North West','Suburban Area'),
(403,'Aignish / Aiginis','Western Isles','Scotland','NB487324',148708,932482,58.20924,-6.27963,5,'HS2 0','Na h-Eileanan an Iar','Scotland','Village'),
(404,'Aike','East Riding of Yorkshire','England','TA048458',504887,445880,53.89849,-0.40523,8,'YO25 9','East Riding of Yorkshire','Yorkshire and the Humber','Hamlet'),
(405,'Aikerness','Orkney','Scotland','HY453517',345391,1051754,59.34857,-2.96198,6,'KW17 2','Orkney Islands','Scotland','Hamlet'),
(406,'Aikers','Orkney','Scotland','ND457910',345703,991048,58.80353,-2.94145,54,'KW17 2','Orkney Islands','Scotland','Locality'),
(407,'Aiketgate','Cumbria','England','NY479466',347973,546697,54.81242,-2.81106,143,'CA4 9','Westmorland and Furness','North West','Hamlet'),
(408,'Aikhead','Cumbria','England','NY237492',323733,549299,54.83269,-3.18884,28,'CA7 0','Cumberland','North West','Hamlet'),
(409,'Aikrigg','Cumbria','England','SD525917',352541,491776,54.31935,-2.73110,85,'LA9 7','Westmorland and Furness','North West','Suburban Area'),
(410,'Aikton','Cumbria','England','NY274534',327462,553454,54.87057,-3.13185,35,'CA7 0','Cumberland','North West','Village'),
(411,'Ailby','Lincolnshire','England','TF436769',543642,376947,53.27006,0.15247,11,'LN13 0','East Lindsey District','East Midlands','Hamlet'),
(412,'Ailscroft','Herefordshire','England','SO702437',370234,243742,52.09122,-2.43587,86,'HR8 1','County of Herefordshire','West Midlands','Hamlet'),
(413,'Ailstone','Warwickshire','England','SP205505',420500,250500,52.15241,-1.70179,47,'CV37 8','Stratford-on-Avon District','West Midlands','Locality'),
(414,'Ailsworth','Cambridgeshire','England','TL117988',511713,298826,52.57579,-0.35292,15,'PE5 7','City of Peterborough','Eastern','Village'),
(415,'Aimes Green','Essex','England','TL396028',539693,202872,51.70720,0.02032,50,'EN9 2','Epping Forest District','Eastern','Hamlet'),
(416,'Ainderby Quernhow','North Yorkshire','England','SE347809',434742,480949,54.22309,-1.46865,27,'YO7 4','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(417,'Ainderby Steeple','North Yorkshire','England','SE337917',433724,491771,54.32041,-1.48305,29,'DL7 9','North Yorkshire','Yorkshire and the Humber','Village'),
(418,'Aingers Green','Essex','England','TM117203',611790,220336,51.84144,1.07305,28,'CO7 8','Tendring District','Eastern','Village'),
(419,'Ainley Top','West Yorkshire','England','SE120193',412054,419330,53.67031,-1.81903,199,'HD2 2','Kirklees District','Yorkshire and the Humber','Suburban Area'),
(420,'Ainsdale','Merseyside','England','SD312122',331248,412220,53.60201,-3.04043,16,'PR8 3','Sefton District','North West','Suburban Area'),
(421,'Ainsdale-on-Sea','Merseyside','England','SD295125',329500,412500,53.60430,-3.06690,3,'PR8 2','Sefton District','North West','Locality'),
(422,'Ainstable','Cumbria','England','NY525463',352582,546394,54.81015,-2.73930,113,'CA4 9','Westmorland and Furness','North West','Village'),
(423,'Ainsworth','Greater Manchester','England','SD764102',376405,410216,53.58799,-2.35791,168,'BL2 5','Bury District','North West','Village'),
(424,'Ainthorpe','North Yorkshire','England','NZ704080',470480,508011,54.46259,-0.91421,146,'YO21 2','North Yorkshire','Yorkshire and the Humber','Village'),
(425,'Aintree','Merseyside','England','SJ379988',337953,398867,53.48285,-2.93647,15,'L10 6','Sefton District','North West','Village'),
(426,'Aird','Argyll and Bute','Scotland','NM765005',176568,700566,56.14530,-5.59837,3,'PA31 8','Argyll and Bute','Scotland','Locality'),
(427,'Aird','Ross and Cromarty','Scotland','NG397513',139799,851376,57.47772,-6.34232,16,'IV51 9','Highland','Scotland','Locality'),
(428,'Aird','Western Isles','Scotland','NB557362',155719,936298,58.24737,-6.16465,40,'HS2 0','Na h-Eileanan an Iar','Scotland','Village'),
(429,'Aird','Wigtown','Scotland','NX096601',209635,560131,54.89953,-4.97039,19,'DG9 8','Dumfries and Galloway','Scotland','Locality'),
(434,'Aird / An Àird','Ross and Cromarty','Scotland','NG591006',159170,800673,57.03407,-5.97085,61,'IV45 8','Highland','Scotland','Hamlet'),
(438,'Aird-dhubh','Ross and Cromarty','Scotland','NG707408',170700,840813,57.39972,-5.81834,7,'IV54 8','Highland','Scotland','Hamlet'),
(439,'Airdens','Sutherland','Scotland','NH625938',262585,893811,57.91244,-4.32099,149,'IV24 3','Highland','Scotland','Locality'),
(446,'Airdrie','Lanarkshire','Scotland','NS761654',276133,665426,55.86604,-3.98089,129,'ML6 6','North Lanarkshire','Scotland','Town'),
(447,'Airdriehill','Lanarkshire','Scotland','NS779672',277992,667295,55.88330,-3.95205,197,'ML6 7','North Lanarkshire','Scotland','Locality'),
(449,'Airds','Argyll and Bute','Scotland','NR815385',181556,638511,55.59109,-5.46823,29,'PA28 6','Argyll and Bute','Scotland','Suburban Area'),
(450,'Airds Bay','Argyll and Bute','Scotland','NM996323',199611,732387,56.44096,-5.25231,4,'PA35 1','Argyll and Bute','Scotland','Hamlet'),
(451,'Aird Tong / Aird Thunga','Western Isles','Scotland','NB458368',145895,936874,58.24697,-6.33216,20,'HS2 0','Na h-Eileanan an Iar','Scotland','Village'),
(452,'Airdtorrisdale','Sutherland','Scotland','NC675625',267500,962500,58.53038,-4.27727,62,'KW14 7','Highland','Scotland','Locality'),
(454,'Airedale','West Yorkshire','England','SE453256',445389,425602,53.72485,-1.31358,57,'WF10 3','Wakefield District','Yorkshire and the Humber','Suburban Area'),
(455,'Aire View','North Yorkshire','England','SD995465',399500,446500,53.91465,-2.00910,95,'BD20 8','North Yorkshire','Yorkshire and the Humber','Locality'),
(456,'Aireworth','West Yorkshire','England','SE070420',407051,442008,53.87423,-1.89424,91,'BD21 4','Bradford District','Yorkshire and the Humber','Suburban Area'),
(457,'Airlie','Angus','Scotland','NO316501',331601,750166,56.63830,-3.11676,81,'DD8 5','Angus','Scotland','Hamlet'),
(458,'Airmyn','East Riding of Yorkshire','England','SE725252',472501,425289,53.71898,-0.90283,4,'DN14 8','East Riding of Yorkshire','Yorkshire and the Humber','Village'),
(459,'Airntully','Perth and Kinross','Scotland','NO099354',309930,735455,56.50251,-3.46484,106,'PH1 4','Perth and Kinross','Scotland','Hamlet'),
(460,'Airor','Inverness','Scotland','NG719054',171957,805447,57.08336,-5.76497,16,'IV43 8','Highland','Scotland','Locality'),
(461,'Airth','Stirling and Falkirk','Scotland','NS898875',289895,687597,56.06849,-3.77018,11,'FK2 8','Falkirk','Scotland','Village'),
(462,'Airthrey Castle','Stirling and Falkirk','Scotland','NS815965',281500,696500,56.14643,-3.90890,34,'FK9 4','Stirling','Scotland','Locality'),
(463,'Airton','North Yorkshire','England','SD901591',390139,459110,54.02789,-2.15202,183,'BD23 4','North Yorkshire','Yorkshire and the Humber','Village'),
(464,'Airy Hill','North Yorkshire','England','NZ895095',489500,509500,54.47298,-0.62043,23,'YO22 4','North Yorkshire','Yorkshire and the Humber','Locality'),
(465,'Aisby','Lincolnshire','England','SK872929',487205,392937,53.42603,-0.68909,20,'DN21 5','West Lindsey District','East Midlands','Hamlet'),
(466,'Aisby','Lincolnshire','England','TF011388',501129,338813,52.93720,-0.49672,75,'NG32 3','South Kesteven District','East Midlands','Village'),
(467,'Aisgernis / Askernish','Western Isles','Scotland','NF735238',73599,823889,57.18916,-7.40527,4,'HS8 5','Na h-Eileanan an Iar','Scotland','Locality'),
(468,'Aish','Devon','England','SX842589',284248,58938,50.41887,-3.63068,75,'TQ9 6','South Hams District','South West','Hamlet'),
(469,'Aish','Devon','England','SX692606',269210,60622,50.43084,-3.84284,158,'TQ10 9','South Hams District','South West','Village'),
(470,'Aisholt','Somerset','England','ST190356',319073,135664,51.11453,-3.15752,154,'TA5 1','Somerset','South West','Hamlet'),
(471,'Aiskew','North Yorkshire','England','SE269884',426942,488413,54.29064,-1.58761,47,'DL8 1','North Yorkshire','Yorkshire and the Humber','Village'),
(472,'Aislaby','Durham','England','NZ404123',440448,512360,54.50495,-1.37688,30,'TS16 0','Stockton-on-Tees','North East','Village'),
(473,'Aislaby','North Yorkshire','England','SE776856',477602,485694,54.26104,-0.81018,48,'YO18 8','North Yorkshire','Yorkshire and the Humber','Village'),
(474,'Aislaby','North Yorkshire','England','NZ858086',485801,508630,54.46580,-0.67774,156,'YO21 1','North Yorkshire','Yorkshire and the Humber','Village'),
(475,'Aisthorpe','Lincolnshire','England','SK949802',494908,380219,53.31042,-0.57702,25,'LN1 2','West Lindsey District','East Midlands','Village'),
(476,'Aith','Orkney','Scotland','HY648256',364812,1025647,59.11621,-2.61628,23,'KW17 2','Orkney Islands','Scotland','Hamlet'),
(477,'Aith','Shetland','Scotland','HU341557',434170,1155796,60.28491,-1.38389,20,'ZE2 9','Shetland Islands','Scotland','Village'),
(478,'Aithnen','Powys','Wales','SJ205225',320500,322500,52.79419,-3.18045,200,'SY10 9','Powys','Wales','Locality'),
(479,'Aithsetter','Shetland','Scotland','HU440304',444089,1130479,60.05666,-1.21001,55,'ZE2 9','Shetland Islands','Scotland','Hamlet'),
(480,'Akeld','Northumberland','England','NT957297',395701,629719,55.56113,-2.06972,54,'NE71 6','Northumberland','North East','Hamlet'),
(481,'Akeley','Buckinghamshire','England','SP707374',470770,237481,52.03123,-0.96984,128,'MK18 5','Buckinghamshire','South East','Village'),
(482,'Akenham','Suffolk','England','TM147486',614716,248657,52.09457,1.13315,32,'IP1 6','Mid Suffolk District','Eastern','Hamlet'),
(483,'Akroydon','West Yorkshire','England','SE089262',408958,426257,53.73263,-1.86569,179,'HX3 6','Calderdale District','Yorkshire and the Humber','Suburban Area'),
(484,'Albany','Tyne and Wear','England','NZ300570',430082,557026,54.90705,-1.53236,73,'NE37 1','Sunderland District','North East','Suburban Area'),
(485,'Albany Park','Greater London','England','TQ462718',546276,171807,51.42640,0.10260,63,'DA14 6','Bexley','London','Suburban Area'),
(486,'Albaston','Cornwall','England','SX423702',242300,70298,50.51118,-4.22552,143,'PL18 9','Cornwall','South West','Suburban Area'),
(487,'Alberbury','Shropshire','England','SJ358143',335821,314313,52.72264,-2.95166,94,'SY5 9','Shropshire','West Midlands','Village'),
(488,'Albert Hill','Durham','England','NZ298154',429889,515418,54.53316,-1.53963,53,'DL1 2','Darlington','North East','Suburban Area'),
(489,'Albert Town','Dyfed','Wales','SM938155',193888,215503,51.80009,-4.99067,72,'SA61 2','Pembrokeshire / Sir Benfro','Wales','Suburban Area'),
(490,'Albert Village','Leicestershire','England','SK302179',430273,317945,52.75827,-1.55286,107,'DE11 8','North West Leicestershire District','East Midlands','Suburban Area'),
(491,'Albion','West Midlands','England','SO986910',398605,291022,52.51708,-2.02199,144,'B70 9','Sandwell District','West Midlands','Suburban Area'),
(492,'Albourne','West Sussex','England','TQ266164',526608,116419,50.93333,-0.19963,40,'BN6 9','Mid Sussex District','South East','Village'),
(493,'Albourne Green','West Sussex','England','TQ264168',526484,116859,50.93731,-0.20124,42,'BN6 9','Mid Sussex District','South East','Village'),
(494,'Albourne Street','West Sussex','England','TQ264164',526419,116463,50.93377,-0.20230,41,'BN6 9','Mid Sussex District','South East','Village'),
(495,'Albrighton','Shropshire','England','SJ496183',349690,318380,52.76067,-2.74697,99,'SY4 3','Shropshire','West Midlands','Hamlet'),
(496,'Albrighton','Shropshire','England','SJ812041',381259,304162,52.63488,-2.27835,99,'WV7 3','Shropshire','West Midlands','Village'),
(497,'Albro Castle','Dyfed','Wales','SN165465',216500,246500,52.08635,-4.67969,6,'SA43 3','Ceredigion / Sir Ceredigion','Wales','Locality'),
(498,'Alburgh','Norfolk','England','TM270867',627081,286743,52.43147,1.33895,42,'IP20 0','South Norfolk District','Eastern','Village'),
(499,'Alburgh Street','Norfolk','England','TM265873',626575,287379,52.43739,1.33195,46,'IP20 0','South Norfolk District','Eastern','Village'),
(500,'Alburne Park','Fife','Scotland','NO286012',328694,701216,56.19819,-3.15079,71,'KY7 5','Fife','Scotland','Suburban Area'),
(501,'Albury','Hertfordshire','England','TL432246',543202,224631,51.90182,0.08005,108,'SG11 2','East Hertfordshire District','Eastern','Village'),
(502,'Albury','Oxfordshire','England','SP655051',465521,205106,51.74084,-1.05248,81,'OX9 2','South Oxfordshire District','South East','Hamlet'),
(503,'Albury','Surrey','England','TQ050476',505066,147698,51.21882,-0.49699,69,'GU5 9','Guildford District','South East','Village'),
(504,'Albury End','Hertfordshire','England','TL428237',542893,223798,51.89442,0.07521,111,'SG11 2','East Hertfordshire District','Eastern','Hamlet'),
(505,'Albury Heath','Surrey','England','TQ063470',506362,147001,51.21232,-0.47864,107,'GU5 9','Guildford District','South East','Hamlet'),
(506,'Alby','Norfolk','England','TG216330',621666,333082,52.84958,1.29053,25,'NR11 7','North Norfolk District','Eastern','Hamlet'),
(507,'Albyfield','Cumbria','England','NY545525',354500,552500,54.86520,-2.71042,198,'CA8 9','Cumberland','North West','Locality'),
(508,'Alby Hill','Norfolk','England','TG192341',619248,334195,52.86056,1.25543,35,'NR11 7','North Norfolk District','Eastern','Village'),
(509,'Alcaig','Ross and Cromarty','Scotland','NH566572',256674,857214,57.58215,-4.39879,15,'IV7 8','Highland','Scotland','Village'),
(510,'Alcaston','Shropshire','England','SO456871',345678,287154,52.47959,-2.80127,153,'SY6 6','Shropshire','West Midlands','Hamlet'),
(511,'Alcester','Dorset','England','ST856226',385642,122633,51.00290,-2.20600,184,'SP7 8','Dorset','South West','Suburban Area'),
(512,'Alcester','Warwickshire','England','SP089572',408912,257278,52.21365,-1.87098,44,'B49 5','Stratford-on-Avon District','West Midlands','Town'),
(513,'Alcester Lane''s End','West Midlands','England','SP073806',407375,280637,52.42367,-1.89297,157,'B14 6','Birmingham District','West Midlands','Suburban Area'),
(514,'Alciston','East Sussex','England','TQ506056',550627,105688,50.83113,0.13753,48,'BN26 6','Wealden District','South East','Village'),
(515,'Alcombe','Somerset','England','SS975451',297599,145179,51.19662,-3.46691,23,'TA24 6','Somerset','South West','Suburban Area'),
(516,'Alcombe','Wiltshire','England','ST809693',380930,169345,51.42279,-2.27565,71,'SN13 8','Wiltshire','South West','Hamlet'),
(517,'Alconbury','Cambridgeshire','England','TL185759',518556,275955,52.36883,-0.26011,19,'PE28 4','Huntingdonshire District','Eastern','Village'),
(518,'Alconbury Weald','Cambridgeshire','England','TL210765',521091,276540,52.37353,-0.22269,34,'PE28 4','Huntingdonshire District','Eastern','Locality'),
(519,'Alconbury Weston','Cambridgeshire','England','TL178769',517802,276950,52.37793,-0.27083,20,'PE28 4','Huntingdonshire District','Eastern','Village'),
(520,'Aldborough','Norfolk','England','TG183342',618343,334211,52.86107,1.24202,28,'NR11 7','North Norfolk District','Eastern','Village'),
(521,'Aldborough','North Yorkshire','England','SE405662',440572,466298,54.09100,-1.38120,29,'YO51 9','North Yorkshire','Yorkshire and the Humber','Village'),
(522,'Aldborough Hatch','Greater London','England','TQ456892',545687,189215,51.58297,0.10132,28,'IG2 7','Redbridge','London','Suburban Area'),
(523,'Aldbourne','Wiltshire','England','SU264756',426418,175611,51.47884,-1.62098,130,'SN8 2','Wiltshire','South West','Village'),
(524,'Aldbrough','East Riding of Yorkshire','England','TA243387',524306,438703,53.82973,-0.11277,17,'HU11 4','East Riding of Yorkshire','Yorkshire and the Humber','Village'),
(525,'Aldbrough St John','North Yorkshire','England','NZ203114',420364,511411,54.49762,-1.68709,86,'DL11 7','North Yorkshire','Yorkshire and the Humber','Village'),
(526,'Aldbury','Hertfordshire','England','SP964124',496486,212426,51.80216,-0.60211,138,'HP23 5','Dacorum District','Eastern','Village'),
(527,'Aldcliffe','Lancashire','England','SD466601',346689,460146,54.03453,-2.81544,35,'LA1 5','Lancaster District','North West','Village'),
(528,'Aldclune','Perth and Kinross','Scotland','NN901635',290139,763584,56.75089,-3.79817,126,'PH16 5','Perth and Kinross','Scotland','Hamlet'),
(529,'Aldeburgh','Suffolk','England','TM464565',646460,256533,52.15203,1.60134,7,'IP15 5','East Suffolk District','Eastern','Town'),
(530,'Aldeby','Norfolk','England','TM450936',645033,293684,52.48600,1.60757,7,'NR34 0','South Norfolk District','Eastern','Village'),
(531,'Aldenham','Hertfordshire','England','TQ139984',513947,198457,51.67334,-0.35355,83,'WD25 8','Hertsmere District','Eastern','Village'),
(532,'Alderbrook','East Sussex','England','TQ521290',552151,129088,51.04101,0.16891,162,'TN6 3','Wealden District','South East','Suburban Area'),
(533,'Alderbury','Wiltshire','England','SU189270',418906,127067,51.04265,-1.73170,84,'SP5 3','Wiltshire','South West','Village'),
(534,'Aldercar','Derbyshire','England','SK445475',444500,347500,53.02295,-1.33803,87,'NG16 4','Amber Valley District','East Midlands','Locality'),
(535,'Alderford','Devon','England','SS762477',276297,147745,51.21547,-3.77252,204,'EX35 6','North Devon District','South West','Hamlet'),
(536,'Alderford','Norfolk','England','TG125186',612548,318675,52.72394,1.14599,16,'NR9 5','Broadland District','Eastern','Hamlet'),
(537,'Alder Forest','Greater Manchester','England','SJ751997',375187,399743,53.49380,-2.37547,23,'M30 8','Salford District','North West','Suburban Area'),
(538,'Aldergrove','County Antrim','Northern Ireland','J134788',313472,378815,54.64472,-6.24306,61,'BT29 4','Antrim and Newtownabbey','Northern Ireland','Locality'),
(539,'Alderholt','Dorset','England','SU115124',411501,112468,50.91157,-1.83778,54,'SP6 3','Dorset','South West','Village'),
(540,'Alderley','Gloucestershire','England','ST768909',376836,190960,51.61698,-2.33596,93,'GL12 7','Stroud District','South West','Hamlet'),
(541,'Alderley Edge','Cheshire','England','SJ843783',384359,378323,53.30162,-2.23616,88,'SK9 7','Cheshire East','North West','Village'),
(542,'Alderman''s Green','West Midlands','England','SP359834',435962,283484,52.44814,-1.47230,91,'CV2 1','Coventry District','West Midlands','Suburban Area'),
(543,'Aldermaston','Berkshire','England','SU591651',459134,165101,51.38189,-1.15168,69,'RG7 4','West Berkshire','South East','Village'),
(544,'Aldermaston Soke','Berkshire','England','SU613637',461301,163792,51.36989,-1.12077,103,'RG7 4','West Berkshire','South East','Village'),
(545,'Aldermaston Wharf','Berkshire','England','SU600672',460069,167254,51.40115,-1.13788,57,'RG7 4','West Berkshire','South East','Village'),
(546,'Alderminster','Warwickshire','England','SP231487',423104,248741,52.13649,-1.66385,56,'CV37 8','Stratford-on-Avon District','West Midlands','Village'),
(547,'Aldermoor','Hampshire','England','SU397151',439712,115138,50.93433,-1.43624,34,'SO16 5','City of Southampton','South East','Suburban Area'),
(548,'Alder Moor','Staffordshire','England','SK222272',422266,327224,52.84207,-1.67088,76,'DE13 9','East Staffordshire District','West Midlands','Village'),
(549,'Alderney','Dorset','England','SZ045945',404500,94500,50.75008,-1.93758,59,'BH12 4','Bournemouth, Christchurch and Poole','South West','Locality'),
(550,'Alder Root','Greater Manchester','England','SD910047',391053,404707,53.53893,-2.13647,143,'OL9 8','Oldham District','North West','Suburban Area'),
(551,'Alder Row','Somerset','England','ST775435',377500,143500,51.19028,-2.32334,87,'BA11 5','Somerset','South West','Locality'),
(552,'Alders','Staffordshire','England','SK090388',409038,338854,52.94700,-1.86694,90,'ST14 5','East Staffordshire District','West Midlands','Hamlet'),
(553,'Aldersbrook','Greater London','England','TQ403868',540399,186869,51.56323,0.02411,21,'E11 3','Redbridge','London','Suburban Area'),
(554,'Alder''s End','Herefordshire','England','SO625395',362500,239500,52.05261,-2.54828,113,'HR1 4','County of Herefordshire','West Midlands','Locality'),
(555,'Aldersey Green','Cheshire','England','SJ461567',346168,356750,53.10521,-2.80553,18,'CH3 9','Cheshire West and Chester','North West','Hamlet'),
(556,'Aldersey Park','Cheshire','England','SJ459561',345927,356108,53.09942,-2.80903,20,'CH3 9','Cheshire West and Chester','North West','Hamlet'),
(557,'Aldershawe','Staffordshire','England','SK105075',410500,307500,52.66512,-1.84618,123,'WS14 0','Lichfield District','West Midlands','Locality'),
(558,'Aldershot','Hampshire','England','SU865508',486522,150808,51.24989,-0.76169,90,'GU11 1','Rushmoor District','South East','Town'),
(559,'Aldersley','West Midlands','England','SJ898010',389851,301052,52.60715,-2.15130,123,'WV6 9','City of Wolverhampton District','West Midlands','Suburban Area'),
(560,'Alderton','Gloucestershire','England','SP001333',400151,233307,51.99821,-1.99921,58,'GL20 8','Tewkesbury District','South West','Village'),
(561,'Alderton','Northamptonshire','England','SP740467',474047,246731,52.11395,-0.92008,106,'NN12 7','West Northamptonshire','East Midlands','Village'),
(562,'Alderton','Shropshire','England','SJ496238',349644,323867,52.80999,-2.74850,118,'SY4 3','Shropshire','West Midlands','Hamlet'),
(563,'Alderton','Suffolk','England','TM343416',634399,241648,52.02369,1.41516,7,'IP12 3','East Suffolk District','Eastern','Village'),
(564,'Alderton','Wiltshire','England','ST838827',383882,182775,51.54364,-2.23381,124,'SN14 6','Wiltshire','South West','Village'),
(565,'Alderton Fields','Gloucestershire','England','SP000322',400085,232230,51.98852,-2.00017,51,'GL54 5','Tewkesbury District','South West','Hamlet'),
(566,'Alderwasley','Derbyshire','England','SK316535',431668,353576,53.07848,-1.52873,205,'DE56 2','Amber Valley District','East Midlands','Village'),
(567,'Alderwood Terrace','Greater London','England','TQ483922',548379,192225,51.60931,0.14142,39,'IG7 4','Redbridge','London','Locality'),
(568,'Aldfield','North Yorkshire','England','SE266694',426619,469465,54.12037,-1.59424,142,'HG4 3','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(569,'Aldford','Cheshire','England','SJ418593',341888,359398,53.12856,-2.86994,20,'CH3 6','Cheshire West and Chester','North West','Village'),
(570,'Aldgate','Greater London','England','TQ334811',533488,181115,51.51320,-0.07770,10,'EC3M 4','City of London','London','Suburban Area'),
(571,'Aldgate','Rutland','England','SK985045',498500,304500,52.62933,-0.54614,45,'PE9 3','Rutland','East Midlands','Locality'),
(572,'Aldham','Essex','England','TL917258',591784,225814,51.89786,0.78606,47,'CO6 3','Colchester District','Eastern','Village'),
(573,'Aldham','Suffolk','England','TM037447',603776,244711,52.06328,0.97133,47,'IP7 6','Babergh District','Eastern','Village'),
(574,'Aldie','Aberdeenshire','Scotland','NK068398',406841,839824,57.44868,-1.88767,76,'AB42 0','Aberdeenshire','Scotland','Hamlet'),
(575,'Aldingbourne','West Sussex','England','SU925053',492534,105393,50.84068,-0.68716,8,'PO20 3','Arun District','South East','Village'),
(576,'Aldingham','Cumbria','England','SD283710',328307,471052,54.13030,-3.09863,39,'LA12 9','Westmorland and Furness','North West','Hamlet'),
(577,'Aldington','Kent','England','TR059361',605972,136198,51.08810,0.93973,50,'TN25 7','Ashford District','South East','Village'),
(578,'Aldington','Worcestershire','England','SP063440',406364,244077,52.09500,-1.90852,38,'WR11 7','Wychavon District','West Midlands','Village'),
(579,'Aldington Frith','Kent','England','TR044368',604448,136871,51.09469,0.91838,53,'TN25 7','Ashford District','South East','Village'),
(580,'Aldochlay','Dunbartonshire','Scotland','NS360913',236026,691304,56.08633,-4.63688,18,'G83 8','Argyll and Bute','Scotland','Hamlet'),
(581,'Aldon','Shropshire','England','SO436796',343618,279627,52.41172,-2.83032,118,'SY7 9','Shropshire','West Midlands','Hamlet'),
(582,'Aldoth','Cumbria','England','NY143486',314348,548690,54.82570,-3.33472,27,'CA7 4','Cumberland','North West','Hamlet'),
(583,'Aldreth','Cambridgeshire','England','TL445734',544555,273430,52.33991,0.12041,13,'CB6 3','East Cambridgeshire District','Eastern','Village'),
(584,'Aldridge','West Midlands','England','SK057008',405703,300851,52.60541,-1.91722,163,'WS9 8','Walsall District','West Midlands','Town'),
(585,'Aldringham','Suffolk','England','TM446610',644609,261038,52.19328,1.57759,7,'IP16 4','East Suffolk District','Eastern','Village'),
(586,'Aldrington','East Sussex','England','TQ273050',527300,105054,50.83103,-0.19374,11,'BN3 4','The City of Brighton and Hove','South East','Suburban Area'),
(587,'Aldroughty','Moray','Scotland','NJ184624',318450,862429,57.64437,-3.36781,65,'IV30 8','Moray','Scotland','Hamlet'),
(588,'Aldsworth','Gloucestershire','England','SP154100',415485,210099,51.78934,-1.77690,124,'GL54 3','Cotswold District','South West','Village'),
(589,'Aldsworth','West Sussex','England','SU763087',476355,108761,50.87331,-0.91619,19,'PO10 8','Chichester District','South East','Hamlet'),
(590,'Aldwark','Derbyshire','England','SK228573',422898,357334,53.11270,-1.65937,329,'DE4 4','Derbyshire Dales District','East Midlands','Hamlet'),
(591,'Aldwark','North Yorkshire','England','SE466635',446607,463565,54.06593,-1.28936,19,'YO61 1','North Yorkshire','Yorkshire and the Humber','Village'),
(592,'Aldwarke','South Yorkshire','England','SK448948',444888,394841,53.44843,-1.32559,27,'S65 3','Rotherham District','Yorkshire and the Humber','Suburban Area'),
(593,'Aldwick','Somerset','England','ST493609',349368,160997,51.34579,-2.72835,35,'BS40 5','North Somerset','South West','Hamlet'),
(594,'Aldwick','West Sussex','England','SZ911988',491193,98881,50.78234,-0.70782,5,'PO21 4','Arun District','South East','Suburban Area'),
(595,'Aldwincle','Northamptonshire','England','TL005818',500501,281890,52.42577,-0.52341,42,'NN14 3','North Northamptonshire','East Midlands','Village'),
(596,'Aldworth','Berkshire','England','SU555796',455529,179661,51.51315,-1.20120,165,'RG8 9','West Berkshire','South East','Hamlet'),
(597,'Aldwych','Greater London','England','TQ307810',530782,181045,51.51320,-0.11670,41,'WC2B 4','City of Westminster','London','Suburban Area'),
(598,'Ale Oak','Shropshire','England','SO225845',322500,284500,52.45294,-3.14186,349,'SY7 8','Shropshire','West Midlands','Locality'),
(599,'Alexandra Park','Greater London','England','TQ291905',529139,190549,51.59899,-0.13688,61,'N22 7','Haringey','London','Suburban Area'),
(600,'Alexandra Park','Nottinghamshire','England','SK579418',457968,341877,52.97112,-1.13827,103,'NG3 4','City of Nottingham','East Midlands','Suburban Area'),
(601,'Alexandria','Dunbartonshire','Scotland','NS390802',239008,680230,55.98795,-4.58236,22,'G83 0','West Dunbartonshire','Scotland','Town'),
(602,'Aley','Somerset','England','ST187381',318792,138102,51.13641,-3.16208,115,'TA5 1','Somerset','South West','Hamlet'),
(603,'Aley Green','Bedfordshire','England','TL070183',507095,218395,51.85388,-0.44646,157,'LU1 4','Central Bedfordshire','Eastern','Village'),
(604,'Alfardisworthy','Devon','England','SS294116',229415,111625,50.87887,-4.42618,163,'EX22 7','Torridge District','South West','Hamlet'),
(605,'Alfington','Devon','England','SY115979',311507,97972,50.77455,-3.25641,78,'EX11 1','East Devon District','South West','Village'),
(606,'Alfold','Surrey','England','TQ038339',503818,133980,51.09574,-0.51880,52,'GU6 8','Waverley District','South East','Village'),
(607,'Alfold Bars','West Sussex','England','TQ036333',503686,133300,51.08965,-0.52088,37,'RH14 0','Chichester District','South East','Village'),
(608,'Alfold Crossways','Surrey','England','TQ039350',503997,135081,51.10560,-0.51593,53,'GU6 8','Waverley District','South East','Village'),
(609,'Alford','Aberdeenshire','Scotland','NJ577159',357715,815904,57.23190,-2.70206,148,'AB33 8','Aberdeenshire','Scotland','Town'),
(610,'Alford','Lincolnshire','England','TF454760',545461,376055,53.26156,0.17932,8,'LN13 9','East Lindsey District','East Midlands','Village'),
(611,'Alford','Somerset','England','ST604322',360497,132217,51.08790,-2.56539,33,'BA7 7','Somerset','South West','Village'),
(612,'Alfred''s Well','Worcestershire','England','SO945725',394500,272500,52.35054,-2.08217,120,'B61 9','Bromsgrove District','West Midlands','Locality'),
(613,'Alfreton','Derbyshire','England','SK411557',441103,355767,53.09753,-1.38761,139,'DE55 7','Amber Valley District','East Midlands','Town'),
(614,'Alfrick','Worcestershire','England','SO748531',374853,253178,52.17628,-2.36916,63,'WR6 5','Malvern Hills District','West Midlands','Village'),
(615,'Alfrick Pound','Worcestershire','England','SO743521',374369,252107,52.16663,-2.37615,85,'WR6 5','Malvern Hills District','West Midlands','Hamlet'),
(616,'Alfriston','East Sussex','England','TQ519032',551986,103277,50.80911,0.15581,10,'BN26 5','Wealden District','South East','Village'),
(617,'Algarkirk','Lincolnshire','England','TF292352',529250,335291,52.89953,-0.07993,4,'PE20 2','Boston District','East Midlands','Village'),
(618,'Alhampton','Somerset','England','ST627348',362787,134820,51.11146,-2.53297,44,'BA4 6','Somerset','South West','Village'),
(619,'Alisary','Inverness','Scotland','NM745795',174500,779500,56.85201,-5.69994,79,'PH38 4','Highland','Scotland','Locality'),
(620,'Alkborough','Lincolnshire','England','SE884220',488445,422041,53.68734,-0.66221,49,'DN15 9','North Lincolnshire','Yorkshire and the Humber','Village'),
(621,'Alkerton','Oxfordshire','England','SP377428',437760,242841,52.08264,-1.45038,156,'OX15 6','Cherwell District','South East','Village'),
(622,'Alkham','Kent','England','TR256423',625641,142335,51.13581,1.22396,61,'CT15 7','Dover District','South East','Village'),
(623,'Alkington','Shropshire','England','SJ531393',353111,339320,52.94920,-2.69930,122,'SY13 3','Shropshire','West Midlands','Hamlet'),
(624,'Alkmonton','Derbyshire','England','SK186385',418663,338534,52.94387,-1.72372,148,'DE6 3','Derbyshire Dales District','East Midlands','Hamlet'),
(625,'Alkrington Garden Village','Greater Manchester','England','SD870045',387091,404550,53.53744,-2.19625,106,'M24 1','Rochdale District','North West','Suburban Area'),
(626,'Allaleigh','Devon','England','SX809536',280916,53685,50.37098,-3.67590,149,'TQ9 7','South Hams District','South West','Hamlet'),
(627,'Allanaquoich','Aberdeenshire','Scotland','NO125915',312500,791500,57.00633,-3.44227,328,'AB35 5','Aberdeenshire','Scotland','Locality'),
(628,'Allanbank','Lanarkshire','Scotland','NS845575',284500,657500,55.79694,-3.84390,171,'ML7 5','North Lanarkshire','Scotland','Locality'),
(629,'Allandale','Stirling and Falkirk','Scotland','NS799786',279920,678667,55.98590,-3.92631,55,'FK4 2','Falkirk','Scotland','Village'),
(630,'Allanshaugh','Roxburgh, Ettrick and Lauderdale','Scotland','NT435495',343500,649500,55.73558,-2.90134,222,'TD1 2','Scottish Borders','Scotland','Locality'),
(631,'Allanshaws','Roxburgh, Ettrick and Lauderdale','Scotland','NT495435',349500,643500,55.68234,-2.80469,297,'TD1 2','Scottish Borders','Scotland','Locality'),
(632,'Allanton','Berwickshire','Scotland','NT864544',386487,654496,55.78359,-2.21703,47,'TD11 3','Scottish Borders','Scotland','Village'),
(633,'Allanton','Lanarkshire','Scotland','NS851578',285134,657858,55.80031,-3.83394,179,'ML7 5','North Lanarkshire','Scotland','Village'),
(634,'Allanton','Lanarkshire','Scotland','NS744542',274470,654251,55.76527,-4.00229,58,'ML3 7','South Lanarkshire','Scotland','Village'),
(635,'Allardice','Kincardineshire','Scotland','NO819746',381963,774607,56.86253,-2.29744,61,'DD10 0','Aberdeenshire','Scotland','Hamlet'),
(636,'Allasdale / Allathasdal','Western Isles','Scotland','NF659029',65921,802962,56.99652,-7.50383,15,'HS9 5','Na h-Eileanan an Iar','Scotland','Hamlet'),
(637,'Allaston','Gloucestershire','England','SO638048',363836,204840,51.74109,-2.52515,112,'GL15 5','Forest of Dean District','South West','Suburban Area'),
(638,'Allbrook','Hampshire','England','SU456219',445660,121900,50.99469,-1.35076,61,'SO50 4','Eastleigh District','South East','Suburban Area'),
(639,'All Cannings','Wiltshire','England','SU072619',407239,161947,51.35655,-1.89743,125,'SN10 3','Wiltshire','South West','Village'),
(640,'Allendale Town','Northumberland','England','NY838558',383826,555840,54.89703,-2.25372,244,'NE47 9','Northumberland','North East','Village'),
(641,'Allen End','Warwickshire','England','SP165966',416566,296611,52.56708,-1.75703,116,'B78 2','North Warwickshire District','West Midlands','Hamlet'),
(642,'Allenheads','Northumberland','England','NY859453',385966,545318,54.80254,-2.21984,413,'NE47 9','Northumberland','North East','Village'),
(643,'Allensford','Durham','England','NZ078501',407803,550163,54.84622,-1.88001,118,'DH8 9','County Durham','North East','Hamlet'),
(644,'Allen''s Green','Hertfordshire','England','TL454168',545472,216803,51.83090,0.10972,85,'CM21 0','East Hertfordshire District','Eastern','Village'),
(645,'Allen''s Green','Nottinghamshire','England','SK467526',446733,352696,53.06946,-1.30399,113,'NG16 6','Ashfield District','East Midlands','Suburban Area'),
(646,'Allensmore','Herefordshire','England','SO467360',346720,236059,52.02038,-2.77785,92,'HR2 9','County of Herefordshire','West Midlands','Hamlet'),
(647,'Allenton','Derbyshire','England','SK365325',436500,332500,52.88872,-1.45897,56,'DE24 9','City of Derby','East Midlands','Locality'),
(648,'Allenwood','Cumbria','England','NY489558',348965,555862,54.89487,-2.79725,54,'CA8 9','Cumberland','North West','Hamlet'),
(649,'Aller','Devon','England','ST053065',305316,106577,50.85093,-3.34641,85,'EX15 2','Mid Devon District','South West','Hamlet'),
(650,'Aller','Dorset','England','ST766030',376693,103012,50.82617,-2.33228,130,'DT2 7','Dorset','South West','Hamlet'),
(651,'Aller','Somerset','England','ST399292',339965,129222,51.05918,-2.85802,10,'TA10 0','Somerset','South West','Village'),
(652,'Allerby','Cumbria','England','NY088395',308879,539509,54.74225,-3.41693,49,'CA7 2','Cumberland','North West','Village'),
(653,'Allercombe','Devon','England','SY049945',304941,94577,50.74299,-3.34862,83,'EX5 2','East Devon District','South West','Hamlet'),
(654,'Allerdene','Tyne and Wear','England','NZ259586',425971,558641,54.92179,-1.59633,58,'NE9 6','Gateshead District','North East','Suburban Area'),
(655,'Allerford','Somerset','England','ST179251',317916,125120,51.01957,-3.17164,32,'TA4 1','Somerset','South West','Hamlet'),
(656,'Allerford','Somerset','England','SS905469',290511,146911,51.21087,-3.56884,33,'TA24 8','Somerset','South West','Village'),
(657,'Aller Grove','Devon','England','SY055965',305500,96500,50.76037,-3.34120,100,'EX5 2','East Devon District','South West','Locality'),
(658,'Aller Park','Devon','England','SX880701',288021,70184,50.52069,-3.58096,71,'TQ12 4','Teignbridge District','South West','Suburban Area'),
(659,'Allerston','North Yorkshire','England','SE879825',487912,482534,54.23098,-0.65287,36,'YO18 7','North Yorkshire','Yorkshire and the Humber','Village'),
(660,'Allerthorpe','East Riding of Yorkshire','England','SE783473',478319,447302,53.91595,-0.80909,19,'YO42 4','East Riding of Yorkshire','Yorkshire and the Humber','Village'),
(661,'Allerton','Merseyside','England','SJ409861',340965,386114,53.36858,-2.88869,46,'L18 9','Liverpool District','North West','Suburban Area'),
(662,'Allerton','West Yorkshire','England','SE121341',412121,434107,53.80312,-1.81744,209,'BD15 7','Bradford District','Yorkshire and the Humber','Suburban Area'),
(663,'Allerton Bywater','West Yorkshire','England','SE417278',441750,427856,53.74542,-1.36843,15,'WF10 2','Leeds District','Yorkshire and the Humber','Village'),
(664,'Allerton Mauleverer','North Yorkshire','England','SE415578',441576,457802,54.01456,-1.36702,50,'HG5 0','North Yorkshire','Yorkshire and the Humber','Village'),
(665,'Allesley','West Midlands','England','SP293814',429379,281469,52.43042,-1.56933,107,'CV5 9','Coventry District','West Midlands','Suburban Area'),
(666,'Allesley Green','West Midlands','England','SP290804',429064,280408,52.42090,-1.57406,106,'CV5 7','Coventry District','West Midlands','Suburban Area'),
(667,'Allestree','Derbyshire','England','SK342394',434261,339496,52.95176,-1.49151,87,'DE22 2','City of Derby','East Midlands','Suburban Area'),
(668,'Allet','Cornwall','England','SW795485',179500,48500,50.29515,-5.09726,89,'TR4 9','Cornwall','South West','Locality'),
(669,'Allexton','Leicestershire','England','SK818004',481855,300426,52.59547,-0.79300,100,'LE15 9','Harborough District','East Midlands','Hamlet'),
(670,'Alleytroyds','Lancashire','England','SD742284',374290,428404,53.75136,-2.39137,133,'BB5 0','Hyndburn District','North West','Suburban Area'),
(671,'Allgreave','Cheshire','England','SJ973669',397329,366940,53.19953,-2.04144,275,'SK11 0','Cheshire East','North West','Locality'),
(672,'Allhallows','Kent','England','TQ838778',583836,177858,51.46982,0.64544,12,'ME3 9','Medway','South East','Village'),
(673,'Allhallows-on-Sea','Kent','England','TQ842782',584292,178281,51.47347,0.65222,11,'ME3 9','Medway','South East','Village'),
(674,'Alligin Shuas','Ross and Cromarty','Scotland','NG835585',183500,858500,57.56455,-5.62146,136,'IV22 2','Highland','Scotland','Locality'),
(675,'Allimore Green','Staffordshire','England','SJ853189',385341,318962,52.76805,-2.21870,96,'ST18 9','Stafford District','West Midlands','Hamlet'),
(676,'Allington','Dorset','England','SY461933',346150,93348,50.73723,-2.76447,14,'DT6 5','Dorset','South West','Suburban Area'),
(677,'Allington','Kent','England','TQ742571',574213,157126,51.28663,0.49688,48,'ME16 0','Maidstone District','South East','Suburban Area'),
(678,'Allington','Lincolnshire','England','SK856402',485691,340202,52.95236,-0.72599,50,'NG32 2','South Kesteven District','East Midlands','Village'),
(679,'Allington','Wiltshire','England','ST893753',389321,175337,51.47689,-2.15516,102,'SN14 6','Wiltshire','South West','Hamlet'),
(680,'Allington','Wiltshire','England','SU069631',406942,163173,51.36758,-1.90167,131,'SN10 3','Wiltshire','South West','Hamlet'),
(681,'Allington','Wiltshire','England','SU205393',420516,139349,51.15303,-1.70804,74,'SP4 0','Wiltshire','South West','Village'),
(682,'Allington Bar','Wiltshire','England','ST896745',389602,174576,51.47005,-2.15109,86,'SN14 6','Wiltshire','South West','Hamlet'),
(683,'Allithwaite','Cumbria','England','SD386766',338679,476668,54.18211,-2.94108,56,'LA11 7','Westmorland and Furness','North West','Village'),
(684,'Alloa','Clackmannan','Scotland','NS886929',288690,692922,56.11603,-3.79174,24,'FK10 1','Clackmannanshire','Scotland','Town'),
(685,'Allonby','Cumbria','England','NY080427',308070,542719,54.77094,-3.43051,7,'CA15 6','Cumberland','North West','Village'),
(686,'Allostock','Cheshire','England','SJ743711',374303,371160,53.23684,-2.38646,51,'WA16 9','Cheshire West and Chester','North West','Village'),
(687,'Alloway','Ayrshire and Arran','Scotland','NS333183',233303,618397,55.43102,-4.63604,24,'KA7 4','South Ayrshire','Scotland','Suburban Area'),
(688,'Allowenshay','Somerset','England','ST392133',339260,113305,50.91600,-2.86541,74,'TA17 8','Somerset','South West','Hamlet'),
(689,'All Saints','Devon','England','ST308014',330889,101419,50.80818,-2.98222,80,'EX13 7','East Devon District','South West','Village'),
(690,'All Saints','West Midlands','England','SP053883',405380,288314,52.49271,-1.92219,130,'B18 5','Birmingham District','West Midlands','Suburban Area'),
(691,'All Saints'' South Elmham','Suffolk','England','TM341825',634142,282551,52.39088,1.43968,51,'IP19 0','East Suffolk District','Eastern','Village'),
(692,'Allscott','Shropshire','England','SO737961',373768,296190,52.56290,-2.38840,72,'WV15 5','Shropshire','West Midlands','Locality'),
(693,'Allscott','Shropshire','England','SJ612127',361238,312714,52.71069,-2.57518,60,'TF6 5','Telford and Wrekin','West Midlands','Village'),
(694,'All Stretton','Shropshire','England','SO460956',346039,295634,52.55586,-2.79733,186,'SY6 6','Shropshire','West Midlands','Village'),
(695,'Allt','Dyfed','Wales','SN557023',255767,202350,51.70131,-4.08856,21,'SA14 8','Carmarthenshire / Sir Gaerfyrddin','Wales','Village'),
(696,'Allt a'' Chruinn','Ross and Cromarty','Scotland','NG946203',194673,820365,57.22782,-5.40316,12,'IV40 8','Highland','Scotland','Hamlet'),
(697,'Alltami','Clwyd','Wales','SJ271651',327105,365198,53.17887,-3.09215,133,'CH7 6','Flintshire / Sir y Fflint','Wales','Village'),
(698,'Alltmawr','Powys','Wales','SO073469',307310,246918,52.11279,-3.35498,139,'LD2 3','Powys','Wales','Locality'),
(699,'Alltnacaillich','Sutherland','Scotland','NC458454',245847,945495,58.37069,-4.63727,37,'IV27 4','Highland','Scotland','Locality'),
(700,'Allt nan Sùgh','Ross and Cromarty','Scotland','NG902298',190269,829884,57.31118,-5.48403,29,'IV40 8','Highland','Scotland','Hamlet'),
(701,'Alltour','Inverness','Scotland','NN225815',222500,781500,56.89079,-4.91543,62,'PH34 4','Highland','Scotland','Locality'),
(702,'Alltsigh','Inverness','Scotland','NH457190',245703,819096,57.23648,-4.55811,37,'IV63 7','Highland','Scotland','Hamlet'),
(703,'Alltwalis','Dyfed','Wales','SN445317',244553,231753,51.96246,-4.26391,110,'SA32 7','Carmarthenshire / Sir Gaerfyrddin','Wales','Village'),
(704,'Alltwen','West Glamorgan','Wales','SN726033',272641,203342,51.71431,-3.84489,86,'SA8 3','Neath Port Talbot / Castell-nedd Port Talbot','Wales','Village'),
(705,'Alltyblaca','Dyfed','Wales','SN520451',252078,245131,52.08471,-4.16026,125,'SA40 9','Ceredigion / Sir Ceredigion','Wales','Village'),
(706,'Allt-yr-yn','Gwent','Wales','ST302885',330216,188502,51.59103,-3.00873,52,'NP20 5','Newport / Casnewydd','Wales','Suburban Area'),
(707,'Allum Green','Hampshire','England','SU279070',427944,107017,50.86199,-1.60432,39,'SO43 7','New Forest District','South East','Hamlet'),
(708,'Allwood Green','Suffolk','England','TM052723',605222,272363,52.31101,1.00911,68,'IP22 1','Mid Suffolk District','Eastern','Hamlet'),
(709,'Alma','Nottinghamshire','England','SK470522',447077,352214,53.06510,-1.29892,132,'NG16 6','Ashfield District','East Midlands','Suburban Area'),
(710,'Almagill','Dumfries','Scotland','NY095755',309500,575500,55.06569,-3.41862,150,'DG11 1','Dumfries and Galloway','Scotland','Locality'),
(711,'Almeley','Herefordshire','England','SO336516',333671,251626,52.15891,-2.97102,114,'HR3 6','County of Herefordshire','West Midlands','Village'),
(712,'Almeley Wootton','Herefordshire','England','SO332525',333281,252514,52.16684,-2.97689,141,'HR3 6','County of Herefordshire','West Midlands','Hamlet'),
(713,'Almer','Dorset','England','SY912989',391293,98915,50.78974,-2.12489,35,'DT11 9','Dorset','South West','Hamlet'),
(714,'Almholme','South Yorkshire','England','SE590080',459068,408095,53.56615,-1.10962,7,'DN5 0','Doncaster District','Yorkshire and the Humber','Hamlet'),
(715,'Almington','Staffordshire','England','SJ701346',370192,334680,52.90872,-2.44466,98,'TF9 2','Newcastle-under-Lyme District','West Midlands','Hamlet'),
(716,'Alminstone Cross','Devon','England','SS347201',234781,120108,50.95665,-4.35382,155,'EX39 5','Torridge District','South West','Hamlet'),
(717,'Almodington','West Sussex','England','SZ826976',482636,97641,50.77248,-0.82945,4,'PO20 7','Chichester District','South East','Village'),
(718,'Almondbank','Perth and Kinross','Scotland','NO065262',306541,726299,56.41962,-3.51659,38,'PH1 3','Perth and Kinross','Scotland','Village'),
(719,'Almondbury','West Yorkshire','England','SE167154',416735,415461,53.63541,-1.74839,157,'HD5 8','Kirklees District','Yorkshire and the Humber','Suburban Area'),
(720,'Almondbury Common','West Yorkshire','England','SE166143',416609,414369,53.62560,-1.75035,121,'HD4 6','Kirklees District','Yorkshire and the Humber','Suburban Area'),
(721,'Almondhill','City of Edinburgh','Scotland','NT131748',313122,674841,55.95870,-3.39310,46,'EH29 9','City of Edinburgh','Scotland','Hamlet'),
(722,'Almondsbury','Gloucestershire','England','ST603841',360320,184121,51.55457,-2.57372,41,'BS32 4','South Gloucestershire','South West','Village'),
(723,'Almondvale','West Lothian','Scotland','NT053665',305385,666536,55.88265,-3.51406,117,'EH54 6','West Lothian','Scotland','Suburban Area'),
(724,'Almshouse Common','Surrey','England','SU920326',492010,132683,51.08609,-0.68771,130,'GU27 2','Waverley District','South East','Suburban Area'),
(725,'Almshouse Green','Essex','England','TL756333',575691,233344,51.97080,0.55626,94,'CO9 3','Braintree District','Eastern','Locality'),
(726,'Almshouse Green','Suffolk','England','TL938535',593805,253545,52.14618,0.83108,69,'IP30 0','Babergh District','Eastern','Hamlet'),
(727,'Alne','North Yorkshire','England','SE497655',449720,465504,54.08306,-1.24148,17,'YO61 1','North Yorkshire','Yorkshire and the Humber','Village'),
(728,'Alne End','Warwickshire','England','SP113592',411306,259264,52.23146,-1.83588,55,'B49 6','Stratford-on-Avon District','West Midlands','Village'),
(729,'Alne Hills','Warwickshire','England','SP115605',411500,260500,52.24257,-1.83300,100,'B49 6','Stratford-on-Avon District','West Midlands','Locality'),
(730,'Alness','Ross and Cromarty','Scotland','NH660695',266003,869523,57.69550,-4.24973,27,'IV17 0','Highland','Scotland','Town'),
(731,'Alnessferry','Ross and Cromarty','Scotland','NH664660',266449,866079,57.66472,-4.24035,28,'IV7 8','Highland','Scotland','Hamlet'),
(732,'Alne Station','North Yorkshire','England','SE505665',450500,466500,54.09194,-1.22940,19,'YO61 1','North Yorkshire','Yorkshire and the Humber','Locality'),
(733,'Alnham','Northumberland','England','NT995108',399575,610889,55.39196,-2.00826,144,'NE66 4','Northumberland','North East','Hamlet'),
(734,'Alnmouth','Northumberland','England','NU246106',424624,610692,55.38958,-1.61285,17,'NE66 2','Northumberland','North East','Village'),
(735,'Alnwick','Northumberland','England','NU187131',418736,613117,55.41162,-1.70563,70,'NE66 1','Northumberland','North East','Town'),
(736,'Alnwickhill','City of Edinburgh','Scotland','NT271688',327132,668816,55.90691,-3.16713,129,'EH16 6','City of Edinburgh','Scotland','Suburban Area'),
(737,'Alperton','Greater London','England','TQ182839',518283,183945,51.54202,-0.29576,50,'HA0 1','Brent','London','Suburban Area'),
(738,'Alphamstone','Essex','England','TL876353',587698,235347,51.98486,0.73194,67,'CO8 5','Braintree District','Eastern','Village'),
(739,'Alpheton','Suffolk','England','TL883512',588374,251229,52.12726,0.75053,74,'CO10 9','Babergh District','Eastern','Village'),
(740,'Alphington','Devon','England','SX917900',291789,90011,50.69964,-3.53362,18,'EX2 8','Exeter District','South West','Suburban Area'),
(741,'Alpington','Norfolk','England','TG296013',629600,301351,52.56152,1.38600,31,'NR14 7','South Norfolk District','Eastern','Village'),
(742,'Alport','Derbyshire','England','SK221645',422178,364575,53.17782,-1.66963,136,'DE45 1','Derbyshire Dales District','East Midlands','Hamlet'),
(743,'Alport','Powys','Wales','SO273952',327357,295208,52.54985,-3.07275,159,'SY15 6','Powys','Wales','Hamlet'),
(744,'Alpraham','Cheshire','England','SJ586595',358677,359523,53.13126,-2.61906,61,'CW6 9','Cheshire East','North West','Village'),
(745,'Alresford','Essex','England','TM065213',606549,221378,51.85276,0.99770,29,'CO7 8','Tendring District','Eastern','Village'),
(746,'Alrewas','Staffordshire','England','SK170150',417021,315042,52.73275,-1.74937,57,'DE13 7','Lichfield District','West Midlands','Village'),
(747,'Alsager','Cheshire','England','SJ796554',379692,355473,53.09607,-2.30472,95,'ST7 2','Cheshire East','North West','Town'),
(748,'Alsagers Bank','Staffordshire','England','SJ805482',380555,348267,53.03133,-2.29140,215,'ST7 8','Newcastle-under-Lyme District','West Midlands','Village'),
(749,'Alscot','Buckinghamshire','England','SP802044',480294,204435,51.73289,-0.83872,103,'HP27 9','Buckinghamshire','South East','Hamlet'),
(750,'Alsop en le Dale','Derbyshire','England','SK160551',416020,355149,53.09331,-1.76223,239,'DE6 1','Derbyshire Dales District','East Midlands','Hamlet'),
(751,'Alston','Cumbria','England','NY717464',371731,546494,54.81250,-2.44138,280,'CA9 3','Westmorland and Furness','North West','Town'),
(752,'Alston','Devon','England','ST307026',330713,102605,50.81883,-2.98495,102,'EX13 7','East Devon District','South West','Hamlet'),
(753,'Alstone','Gloucestershire','England','SO937225',393709,222524,51.90122,-2.09284,55,'GL51 8','Cheltenham District','South West','Suburban Area'),
(754,'Alstone','Gloucestershire','England','SO983326',398338,232628,51.99210,-2.02561,54,'GL20 8','Tewkesbury District','South West','Village'),
(755,'Alstone','Somerset','England','ST314468',331441,146821,51.21645,-2.98298,6,'TA9 3','Somerset','South West','Village'),
(756,'Alstonefield','Staffordshire','England','SK129557',412995,355700,53.09835,-1.80738,276,'DE6 2','Staffordshire Moorlands District','West Midlands','Village'),
(757,'Alston Sutton','Somerset','England','ST414515',341448,151545,51.26004,-2.84050,52,'BS26 2','Somerset','South West','Locality'),
(758,'Alswear','Devon','England','SS724221',272474,122171,50.98478,-3.81819,82,'EX36 4','North Devon District','South West','Hamlet'),
(759,'Alt','Greater Manchester','England','SD944031',394480,403139,53.52489,-2.08473,174,'OL8 2','Oldham District','North West','Suburban Area'),
(760,'Altamuskin','County Tyrone','Northern Ireland','H594635',259435,363565,54.51700,-7.08300,205,'BT79 9','Fermanagh and Omagh','Northern Ireland','Locality'),
(761,'Altandhu','Ross and Cromarty','Scotland','NB983126',198390,912618,58.05668,-5.41868,19,'IV26 2','Highland','Scotland','Locality'),
(762,'Altarnun','Cornwall','England','SX223812',222325,81276,50.60408,-4.51222,176,'PL15 7','Cornwall','South West','Village'),
(763,'Altass','Sutherland','Scotland','NC495005',249500,900500,57.96824,-4.54585,56,'IV24 3','Highland','Scotland','Locality'),
(764,'Altbough','Herefordshire','England','SO545305',354500,230500,51.97110,-2.66374,129,'HR2 6','County of Herefordshire','West Midlands','Locality'),
(765,'Altens','City of Aberdeen','Scotland','NJ953027',395364,802742,57.11560,-2.07818,78,'AB12 3','Aberdeen City','Scotland','Suburban Area'),
(766,'Alterwall','Caithness','Scotland','ND287645',328731,964531,58.56296,-3.22672,33,'KW1 4','Highland','Scotland','Locality'),
(767,'Altham','Lancashire','England','SD772326',377216,432643,53.78960,-2.34731,85,'BB5 5','Hyndburn District','North West','Village'),
(768,'Alt Hill','Greater Manchester','England','SD944019',394456,401938,53.51409,-2.08507,164,'OL6 8','Tameside District','North West','Hamlet'),
(769,'Althorne','Essex','England','TQ908996',590896,199662,51.66331,0.75880,24,'CM3 6','Maldon District','Eastern','Village'),
(770,'Althorpe','Lincolnshire','England','SE832094',483228,409443,53.57499,-0.74455,8,'DN17 3','North Lincolnshire','Yorkshire and the Humber','Village'),
(771,'Altishane','County Tyrone','Northern Ireland','H462989',246249,398927,54.83600,-7.28100,141,'BT82 0','Derry City and Strabane','Northern Ireland','Locality'),
(772,'Altmore','Berkshire','England','SU855795',485500,179500,51.50797,-0.76943,34,'SL6 3','Windsor and Maidenhead','South East','Locality'),
(773,'Altmore','County Tyrone','Northern Ireland','H656677',265650,367789,54.55417,-6.98611,225,'BT79 9','Fermanagh and Omagh','Northern Ireland','Locality'),
(774,'Altnaharra','Sutherland','Scotland','NC568351',256859,935108,58.28122,-4.44276,86,'IV27 4','Highland','Scotland','Hamlet'),
(775,'Altofts','West Yorkshire','England','SE373236',437318,423637,53.70783,-1.43613,43,'WF6 2','Wakefield District','Yorkshire and the Humber','Suburban Area'),
(776,'Alton','Derbyshire','England','SK362642',436278,364277,53.17437,-1.45871,241,'S42 6','North East Derbyshire District','East Midlands','Village'),
(777,'Alton','Hampshire','England','SU717393',471733,139318,51.14864,-0.97584,105,'GU34 1','East Hampshire District','South East','Town'),
(778,'Alton','Staffordshire','England','SK072422',407265,342222,52.97730,-1.89325,149,'ST10 4','Staffordshire Moorlands District','West Midlands','Village'),
(779,'Alton','Wiltshire','England','SU153466',415351,146659,51.21893,-1.78158,83,'SP4 8','Wiltshire','South West','Hamlet'),
(780,'Alton Barnes','Wiltshire','England','SU105620',410509,162044,51.35737,-1.85046,135,'SN8 4','Wiltshire','South West','Village'),
(781,'Altonhill','Ayrshire and Arran','Scotland','NS424390',242481,639036,55.61933,-4.50289,59,'KA3 1','East Ayrshire','Scotland','Suburban Area'),
(782,'Alton Pancras','Dorset','England','ST700022',370038,102286,50.81934,-2.42670,122,'DT2 7','Dorset','South West','Village'),
(783,'Alton Priors','Wiltshire','England','SU110623',411057,162334,51.35997,-1.84258,134,'SN8 4','Wiltshire','South West','Village'),
(784,'Altonside','Moray','Scotland','NJ292571',329296,857112,57.59846,-3.18461,102,'IV30 8','Moray','Scotland','Hamlet'),
(785,'Altrincham','Greater Manchester','England','SJ767879',376722,387974,53.38809,-2.35146,50,'WA14 1','Trafford District','North West','Town'),
(786,'Altskeith','Stirling and Falkirk','Scotland','NN465025',246500,702500,56.19030,-4.47518,91,'FK8 3','Stirling','Scotland','Locality'),
(787,'Alturlie','Inverness','Scotland','NH715495',271512,849544,57.51777,-4.14678,6,'IV2 7','Highland','Scotland','Hamlet'),
(788,'Alum Chine','Dorset','England','SZ068905',406876,90541,50.71446,-1.90397,41,'BH4 8','Bournemouth, Christchurch and Poole','South West','Suburban Area'),
(789,'Alum Rock','West Midlands','England','SP119876',411990,287634,52.48649,-1.82486,106,'B8 3','Birmingham District','West Midlands','Suburban Area'),
(790,'Alum Waters','Durham','England','NZ234414',423476,541460,54.76752,-1.63665,96,'DH7 7','County Durham','North East','Hamlet'),
(791,'Alva','Clackmannan','Scotland','NS881970',288115,697051,56.15297,-3.80272,25,'FK12 5','Clackmannanshire','Scotland','Town'),
(792,'Alvanley','Cheshire','England','SJ496740',349669,374097,53.26147,-2.75598,75,'WA6 9','Cheshire West and Chester','North West','Village'),
(793,'Alvaston','Derbyshire','England','SK386332',438648,333247,52.89529,-1.42696,45,'DE24 0','City of Derby','East Midlands','Suburban Area'),
(794,'Alvechurch','Worcestershire','England','SP028726',402852,272631,52.35174,-1.95955,119,'B48 7','Bromsgrove District','West Midlands','Village'),
(795,'Alvecote','Warwickshire','England','SK250044',425059,304431,52.63705,-1.63114,69,'B79 0','North Warwickshire District','West Midlands','Village'),
(796,'Alvediston','Wiltshire','England','ST976234',397661,123416,51.01012,-2.03471,117,'SP5 5','Wiltshire','South West','Hamlet'),
(797,'Alveley','Shropshire','England','SO760844',376016,284412,52.45713,-2.35439,119,'WV15 6','Shropshire','West Midlands','Village'),
(798,'Alverdiscott','Devon','England','SS518251',251890,125131,51.00644,-4.11245,145,'EX31 3','Torridge District','South West','Hamlet'),
(799,'Alverstoke','Hampshire','England','SZ600989',460004,98935,50.78689,-1.15015,7,'PO12 2','Gosport District','South East','Suburban Area'),
(800,'Alverstone','Isle of Wight','England','SZ577854',457715,85446,50.66583,-1.18473,6,'PO36 0','Isle of Wight','South East','Village'),
(801,'Alverstone Garden Village','Isle of Wight','England','SZ572853',457237,85377,50.66526,-1.19150,34,'PO36 0','Isle of Wight','South East','Village'),
(802,'Alverthorpe','West Yorkshire','England','SE307217',430793,421768,53.69146,-1.53516,55,'WF2 0','Wakefield District','Yorkshire and the Humber','Suburban Area'),
(803,'Alverton','Cornwall','England','SW461299',146161,29939,50.11514,-5.55205,29,'TR18 4','Cornwall','South West','Suburban Area'),
(804,'Alverton','Nottinghamshire','England','SK793423',479386,342310,52.97228,-0.81930,31,'NG13 9','Newark and Sherwood District','East Midlands','Hamlet'),
(805,'Alves','Moray','Scotland','NJ132621',313244,862136,57.64077,-3.45488,34,'IV30 8','Moray','Scotland','Village'),
(806,'Alvescot','Oxfordshire','England','SP271045',427157,204516,51.73870,-1.60811,87,'OX18 2','West Oxfordshire District','South East','Village'),
(807,'Alveston','Gloucestershire','England','ST632879',363249,187999,51.58964,-2.53188,96,'BS35 3','South Gloucestershire','South West','Village'),
(808,'Alveston','Warwickshire','England','SP234565',423456,256515,52.20636,-1.65817,43,'CV37 7','Stratford-on-Avon District','West Midlands','Village'),
(809,'Alveston Down','Gloucestershire','England','ST628881',362890,188198,51.59140,-2.53708,96,'BS35 3','South Gloucestershire','South West','Suburban Area'),
(810,'Alveston Hill','Warwickshire','England','SP225545',422500,254500,52.18829,-1.67230,53,'CV37 7','Stratford-on-Avon District','West Midlands','Locality'),
(811,'Alvie','Inverness','Scotland','NH864090',286482,809057,57.15829,-3.87837,218,'PH22 1','Highland','Scotland','Locality'),
(812,'Alvingham','Lincolnshire','England','TF362913',536264,391336,53.40126,0.04810,8,'LN11 0','East Lindsey District','East Midlands','Village'),
(813,'Alvington','Gloucestershire','England','SO602009',360239,200978,51.70612,-2.57680,44,'GL15 6','Forest of Dean District','South West','Village'),
(814,'Alvington','Somerset','England','ST525161',352558,116164,50.94295,-2.67663,66,'BA22 8','Somerset','South West','Suburban Area'),
(815,'Alwalton','Cambridgeshire','England','TL133958',513395,295863,52.54881,-0.32912,26,'PE7 3','Huntingdonshire District','Eastern','Suburban Area'),
(816,'Alway','Gwent','Wales','ST338880',333886,188044,51.58735,-2.95568,26,'NP19 9','Newport / Casnewydd','Wales','Suburban Area'),
(817,'Alweston','Dorset','England','ST664143',366450,114303,50.92720,-2.47874,96,'DT9 5','Dorset','South West','Village'),
(818,'Alwington','Devon','England','SS405232',240502,123247,50.98647,-4.27381,122,'EX39 5','Torridge District','South West','Hamlet'),
(819,'Alwinton','Northumberland','England','NT921063',392120,606325,55.35088,-2.12582,159,'NE65 7','Northumberland','North East','Hamlet'),
(820,'Alwoodley','West Yorkshire','England','SE303395',430302,439593,53.85169,-1.54086,154,'LS17 7','Leeds District','Yorkshire and the Humber','Suburban Area'),
(821,'Alwoodley Gates','West Yorkshire','England','SE312407',431209,440729,53.86185,-1.52695,142,'LS17 8','Leeds District','Yorkshire and the Humber','Suburban Area'),
(822,'Alwoodley Park','West Yorkshire','England','SE291407',429174,440797,53.86258,-1.55789,158,'LS17 7','Leeds District','Yorkshire and the Humber','Suburban Area'),
(823,'Alyth','Perth and Kinross','Scotland','NO246484',324638,748460,56.62191,-3.22975,100,'PH11 8','Perth and Kinross','Scotland','Town'),
(824,'Amalebra','Cornwall','England','SW495365',149500,36500,50.17545,-5.50975,133,'TR20 8','Cornwall','South West','Locality'),
(825,'Amalveor','Cornwall','England','SW485375',148500,37500,50.18401,-5.52439,165,'TR26 3','Cornwall','South West','Locality'),
(826,'Amatnatua','Sutherland','Scotland','NH486914',248695,891486,57.88709,-4.55369,91,'IV24 3','Highland','Scotland','Hamlet'),
(827,'Ambaston','Derbyshire','England','SK428323',442881,332380,52.88717,-1.36416,39,'DE72 3','South Derbyshire District','East Midlands','Village'),
(828,'Ambergate','Derbyshire','England','SK348516',434850,351622,53.06072,-1.48144,71,'DE56 2','Amber Valley District','East Midlands','Village'),
(829,'Amber Hill','Lincolnshire','England','TF238463',523802,346391,53.00054,-0.15664,4,'PE20 3','Boston District','East Midlands','Village'),
(830,'Amberley','Gloucestershire','England','SO850009',385080,200920,51.70682,-2.21732,177,'GL5 5','Stroud District','South West','Village'),
(831,'Amberley','Herefordshire','England','SO544478',354414,247800,52.12662,-2.66731,73,'HR1 3','County of Herefordshire','West Midlands','Locality'),
(832,'Amberley','West Sussex','England','TQ027122',502789,112225,50.90036,-0.53964,15,'BN18 9','Horsham District','South East','Village'),
(833,'Amble','Northumberland','England','NU264044',426470,604472,55.33359,-1.58429,8,'NE65 0','Northumberland','North East','Town'),
(834,'Amblecote','West Midlands','England','SO901851',390121,285186,52.46452,-2.14684,88,'DY8 4','Dudley District','West Midlands','Suburban Area'),
(835,'Ambler Thorn','West Yorkshire','England','SE095295',409500,429500,53.76177,-1.85738,315,'BD13 2','Bradford District','Yorkshire and the Humber','Locality'),
(836,'Ambleside','Cumbria','England','NY376045',337621,504558,54.43260,-2.96312,61,'LA22 9','Westmorland and Furness','North West','Town'),
(837,'Ambleston','Dyfed','Wales','SN001258',200141,225845,51.89522,-4.90609,139,'SA62 5','Pembrokeshire / Sir Benfro','Wales','Village'),
(838,'Ambrosden','Oxfordshire','England','SP604193',460451,219398,51.86989,-1.12341,68,'OX25 2','Cherwell District','South East','Village'),
(839,'Amcotts','Lincolnshire','England','SE853141',485386,414123,53.61670,-0.71069,6,'DN17 4','North Lincolnshire','Yorkshire and the Humber','Village'),
(840,'Amen Corner','Berkshire','England','SU844688',484420,168861,51.41250,-0.78752,70,'RG12 8','Bracknell Forest','South East','Suburban Area'),
(841,'America Moor','West Yorkshire','England','SE261263',426170,426302,53.73246,-1.60479,158,'LS27 0','Leeds District','Yorkshire and the Humber','Suburban Area'),
(842,'Amersham','Buckinghamshire','England','SU963984',496370,198483,51.67686,-0.60764,159,'HP6 5','Buckinghamshire','South East','Town'),
(843,'Amersham Common','Buckinghamshire','England','SU972978',497206,197872,51.67122,-0.59573,143,'HP7 9','Buckinghamshire','South East','Suburban Area'),
(844,'Amersham Old Town','Buckinghamshire','England','SU956973',495623,197357,51.66686,-0.61875,95,'HP7 0','Buckinghamshire','South East','Suburban Area'),
(845,'Amersham on the Hill','Buckinghamshire','England','SU966984',496670,198403,51.67609,-0.60333,153,'HP6 5','Buckinghamshire','South East','Suburban Area'),
(846,'Amerton','Staffordshire','England','SJ994276',399446,327644,52.84630,-2.00967,83,'ST18 0','Stafford District','West Midlands','Hamlet'),
(847,'Amesbury','Somerset','England','ST655587',365513,158707,51.32641,-2.49633,135,'BA2 0','Bath and North East Somerset','South West','Hamlet'),
(848,'Amesbury','Wiltshire','England','SU154414',415441,141429,51.17190,-1.78052,69,'SP4 7','Wiltshire','South West','Town'),
(849,'Ameysford','Dorset','England','SU069022',406992,102243,50.81969,-1.90211,14,'BH22 9','Dorset','South West','Suburban Area'),
(850,'Amhuinnsuidhe / Abhainn Suidhe','Western Isles','Scotland','NB047079',104771,907917,57.96225,-6.99368,8,'HS3 3','Na h-Eileanan an Iar','Scotland','Hamlet'),
(851,'Amington','Staffordshire','England','SK230036',423072,303692,52.63050,-1.66056,96,'B77 4','Tamworth District','West Midlands','Suburban Area'),
(852,'Amisfield','Dumfries','Scotland','NX999827',299919,582767,55.12913,-3.57114,47,'DG1 3','Dumfries and Galloway','Scotland','Village'),
(853,'Amlwch','Gwynedd','Wales','SH441929',244184,392936,53.41016,-4.34565,31,'LL68 9','Isle of Anglesey / Sir Ynys Mon','Wales','Town'),
(854,'Amlwch Port / Porth Amlwch','Gwynedd','Wales','SH449931',244976,393110,53.41196,-4.33383,20,'LL68 9','Isle of Anglesey / Sir Ynys Mon','Wales','Suburban Area'),
(855,'Ammanford / Rhydaman','Dyfed','Wales','SN629123',262987,212335,51.79284,-3.98808,39,'SA18 3','Carmarthenshire / Sir Gaerfyrddin','Wales','Town'),
(856,'Ammerham','Somerset','England','ST366059',336628,105916,50.84928,-2.90156,89,'TA20 4','Somerset','South West','Hamlet'),
(857,'Amotherby','North Yorkshire','England','SE749734',474963,473444,54.15136,-0.85373,35,'YO17 6','North Yorkshire','Yorkshire and the Humber','Village'),
(858,'Ampfield','Hampshire','England','SU397231',439779,123151,51.00638,-1.43441,56,'SO51 9','Test Valley District','South East','Village'),
(859,'Ampleforth','North Yorkshire','England','SE582787',458297,478732,54.20103,-1.10784,112,'YO62 4','North Yorkshire','Yorkshire and the Humber','Village'),
(860,'Ampney Crucis','Gloucestershire','England','SP066018',406638,201810,51.71498,-1.90532,107,'GL7 5','Cotswold District','South West','Village'),
(861,'Ampney St Mary','Gloucestershire','England','SP086020',408659,202086,51.71744,-1.87606,104,'GL7 5','Cotswold District','South West','Village'),
(862,'Ampney St Peter','Gloucestershire','England','SP081014',408133,201444,51.71167,-1.88369,99,'GL7 5','Cotswold District','South West','Village'),
(863,'Amport','Hampshire','England','SU301442',430197,144259,51.19676,-1.56922,72,'SP11 8','Test Valley District','South East','Village'),
(864,'Ampthill','Bedfordshire','England','TL034381',503471,238108,52.03174,-0.49313,102,'MK45 2','Central Bedfordshire','Eastern','Town'),
(865,'Ampton','Suffolk','England','TL866713',586671,271347,52.30850,0.73677,44,'IP31 1','West Suffolk District','Eastern','Hamlet'),
(866,'Amroth','Dyfed','Wales','SN167071',216747,207142,51.73296,-4.65514,8,'SA67 8','Pembrokeshire / Sir Benfro','Wales','Village'),
(867,'Amulree','Perth and Kinross','Scotland','NN899368',289944,736816,56.51048,-3.78994,277,'PH8 0','Perth and Kinross','Scotland','Hamlet'),
(868,'Amwell','Hertfordshire','England','TL167131',516726,213153,51.80484,-0.30845,112,'AL4 8','St. Albans District','Eastern','Hamlet'),
(869,'Anagach','Inverness','Scotland','NJ035265',303500,826500,57.31881,-3.60394,202,'PH26 3','Highland','Scotland','Locality'),
(870,'Anaheilt','Inverness','Scotland','NM820630',182039,763083,56.70841,-5.56258,21,'PH36 4','Highland','Scotland','Suburban Area'),
(871,'Anancaun','Ross and Cromarty','Scotland','NH025635',202500,863500,57.61809,-5.30849,16,'IV22 2','Highland','Scotland','Locality'),
(872,'An Àrd','Ross and Cromarty','Scotland','NG808751',180869,875124,57.71230,-5.68041,8,'IV21 2','Highland','Scotland','Suburban Area'),
(873,'Ancaster','Lincolnshire','England','SK984439',498439,343978,52.98411,-0.53516,45,'NG32 3','South Kesteven District','East Midlands','Village'),
(874,'Anchor','Lancashire','England','SD684241',368481,424108,53.71243,-2.47902,149,'BB3 0','Blackburn with Darwen','North West','Suburban Area'),
(875,'Anchor','Shropshire','England','SO173854',317368,285499,52.46116,-3.21761,360,'SY7 8','Shropshire','West Midlands','Hamlet'),
(876,'Anchorage Hill','North Yorkshire','England','NZ178010',417847,501096,54.40502,-1.72657,150,'DL10 7','North Yorkshire','Yorkshire and the Humber','Suburban Area'),
(877,'Anchorage Park','Hampshire','England','SU668034',466832,103460,50.82683,-1.05248,3,'PO3 5','City of Portsmouth','South East','Suburban Area'),
(878,'Anchor Corner','Norfolk','England','TM004979',600479,297957,52.54254,0.95498,59,'NR17 1','Breckland District','Eastern','Hamlet'),
(879,'Anchorsholme','Lancashire','England','SD321422',332151,442211,53.87165,-3.03338,6,'FY5 3','Blackpool','North West','Suburban Area'),
(880,'Anchor Street','Norfolk','England','TG315245',631500,324500,52.76844,1.43022,6,'NR12 8','North Norfolk District','Eastern','Locality'),
(881,'An Cnoc Ard','Western Isles','Scotland','NB535645',153500,964500,58.49873,-6.23254,37,'HS2 0','Na h-Eileanan an Iar','Scotland','Locality'),
(882,'Ancoats','Greater Manchester','England','SJ849982',384975,398295,53.48116,-2.22787,52,'M1 2','Manchester District','North West','Suburban Area'),
(883,'Ancroft','Northumberland','England','NU000451',400021,645165,55.69994,-2.00123,32,'TD15 2','Northumberland','North East','Hamlet'),
(884,'Ancroft Northmoor','Northumberland','England','NT965455',396500,645500,55.70294,-2.05726,74,'TD15 2','Northumberland','North East','Locality'),
(885,'Ancrum','Roxburgh, Ettrick and Lauderdale','Scotland','NT627245',362770,624595,55.51369,-2.59110,89,'TD8 6','Scottish Borders','Scotland','Village'),
(886,'Ancton','West Sussex','England','SU982004',498229,100461,50.79540,-0.60762,4,'PO22 6','Arun District','South East','Suburban Area'),
(887,'Ancumtoun','Orkney','Scotland','HY761548',376194,1054805,59.37883,-2.42072,10,'KW17 2','Orkney Islands','Scotland','Locality'),
(888,'Anderby','Lincolnshire','England','TF531756',553122,375698,53.25620,0.29390,4,'PE24 5','East Lindsey District','East Midlands','Village'),
(889,'Anderby Creek','Lincolnshire','England','TF549761',554922,376130,53.25956,0.32107,4,'PE24 5','East Lindsey District','East Midlands','Village'),
(890,'Andersea','Somerset','England','ST330333',333031,133343,51.09547,-2.95771,6,'TA7 0','Somerset','South West','Hamlet'),
(891,'Andersfield','Somerset','England','ST245345',324500,134500,51.10481,-3.07976,65,'TA5 2','Somerset','South West','Locality'),
(892,'Anderson','Dorset','England','SY879973',387951,97342,50.77553,-2.17225,45,'DT11 9','Dorset','South West','Village'),
(893,'Anderston','City of Glasgow','Scotland','NS578656',257876,665659,55.86309,-4.27251,22,'G3 8','Glasgow City','Scotland','Suburban Area'),
(894,'Anderton','Cheshire','England','SJ640755',364033,375563,53.27582,-2.54083,46,'CW9 6','Cheshire West and Chester','North West','Suburban Area'),
(895,'Anderton','Lancashire','England','SD606136',360623,413638,53.61780,-2.59674,120,'PR6 9','Chorley District','North West','Suburban Area'),
(896,'Andertons Mill','Lancashire','England','SD513142',351326,414224,53.62228,-2.73737,58,'L40 3','West Lancashire District','North West','Village'),
(897,'Andover','Hampshire','England','SU364454',436479,145495,51.20750,-1.47919,61,'SP10 1','Test Valley District','South East','Town'),
(898,'Andover Down','Hampshire','England','SU394461',439483,146129,51.21301,-1.43612,104,'SP11 6','Test Valley District','South East','Village'),
(899,'Andoversford','Gloucestershire','England','SP024196',402440,219623,51.87517,-1.96596,167,'GL54 4','Cotswold District','South West','Village'),
(900,'Andreas','Isle of Man','Isle of Man','SC415995',241500,499500,54.36629,-4.44115,20,'IM7 4','Isle of Man','Isle of Man','Locality'),
(901,'Andrew''s Hill','West Sussex','England','TQ078242',507881,124278,51.00778,-0.46369,25,'RH14 9','Horsham District','South East','Suburban Area'),
(902,'Andwell','Hampshire','England','SU688526',468830,152623,51.26861,-1.01479,70,'RG27 9','Basingstoke and Deane District','South East','Hamlet'),
(903,'Anelog','Gwynedd','Wales','SH153279',215377,327931,52.81722,-4.74112,83,'LL53 8','Gwynedd','Wales','Locality'),
(904,'Anerley','Greater London','England','TQ346698',534617,169884,51.41200,-0.06572,56,'SE20 8','Bromley','London','Suburban Area'),
(905,'Anfield','Merseyside','England','SJ367932',336719,393253,53.43225,-2.95393,47,'L4 2','Liverpool District','North West','Suburban Area'),
(906,'Angarrack','Cornwall','England','SW584382',158427,38239,50.19477,-5.38606,26,'TR27 5','Cornwall','South West','Village'),
(907,'Angarrick','Cornwall','England','SW795375',179500,37500,50.19636,-5.09085,44,'TR11 5','Cornwall','South West','Locality'),
(908,'Angel','Greater London','England','TQ314831',531429,183165,51.53210,-0.10660,40,'N1 9','Islington','London','Suburban Area'),
(909,'Angelbank','Shropshire','England','SO575765',357500,276500,52.38487,-2.62586,248,'SY8 3','Shropshire','West Midlands','Locality'),
(910,'Angersleigh','Somerset','England','ST198188',319824,118824,50.96324,-3.14306,107,'TA3 7','Somerset','South West','Hamlet'),
(911,'Angerton','Cumbria','England','NY228570',322870,557074,54.90241,-3.20435,10,'CA7 5','Cumberland','North West','Village'),
(912,'Angle','Dyfed','Wales','SM863029',186381,202980,51.68484,-5.09169,9,'SA71 5','Pembrokeshire / Sir Benfro','Wales','Village'),
(913,'An Gleann Ur','Western Isles','Scotland','NB415345',141500,934500,58.22315,-6.40417,54,'HS2 0','Na h-Eileanan an Iar','Scotland','Locality'),
(914,'Anglefield Corner','Surrey','England','TQ357468',535791,146888,51.20507,-0.05760,69,'RH9 8','Tandridge District','South East','Village'),
(915,'Angmering','West Sussex','England','TQ068043',506899,104392,50.82920,-0.48351,6,'BN16 4','Arun District','South East','Village'),
(916,'Angram','North Yorkshire','England','SD887997',388772,499778,54.39335,-2.17443,361,'DL11 6','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(917,'Angram','North Yorkshire','England','SE519486',451996,448613,53.93104,-1.20958,22,'YO23 3','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(918,'Anick','Northumberland','England','NY953654',395373,565484,54.98393,-2.07383,86,'NE46 4','Northumberland','North East','Hamlet'),
(919,'Ankerdine Hill','Worcestershire','England','SO735565',373500,256500,52.20608,-2.38920,99,'WR6 5','Malvern Hills District','West Midlands','Locality'),
(920,'Anlaby','East Riding of Yorkshire','England','TA034287',503490,428780,53.74513,-0.43223,8,'HU10 7','East Riding of Yorkshire','Yorkshire and the Humber','Village'),
(921,'Anlaby Common','East Riding of Yorkshire','England','TA049286',504946,428696,53.74409,-0.41019,5,'HU4 7','City of Kingston upon Hull','Yorkshire and the Humber','Suburban Area'),
(922,'Anlaby Park','East Riding of Yorkshire','England','TA049282',504957,428238,53.73997,-0.41018,4,'HU4 6','City of Kingston upon Hull','Yorkshire and the Humber','Suburban Area'),
(923,'An Leth Meadhanach','Western Isles','Scotland','NF745175',74500,817500,57.13267,-7.38209,9,'HS8 5','Na h-Eileanan an Iar','Scotland','Locality'),
(924,'An Leth-Pheighinn / Lephin','Ross and Cromarty','Scotland','NG177495',117713,849519,57.44789,-6.70726,11,'IV55 8','Highland','Scotland','Suburban Area'),
(925,'Anmer','Norfolk','England','TF741294',574161,329476,52.83465,0.58399,70,'PE31 6','King''s Lynn and West Norfolk District','Eastern','Village'),
(926,'Anmore','Hampshire','England','SU669117',466953,111705,50.90095,-1.04926,45,'PO7 6','Winchester District','South East','Hamlet'),
(927,'Annaclone','County Down','Northern Ireland','J175406',317504,340614,54.30080,-6.19580,97,'BT32 5','Armagh City Banbridge and Craigavon','Northern Ireland','Locality'),
(928,'Annaghmore','County Armagh','Northern Ireland','H908566',290862,356623,54.45000,-6.60000,17,'BT62 1','Armagh City Banbridge and Craigavon','Northern Ireland','Locality'),
(929,'Annahilt','County Down','Northern Ireland','J296561',329689,356182,54.43763,-6.00197,103,'BT26 6','Lisburn and Castlereagh','Northern Ireland','Locality'),
(930,'Annahugh','County Armagh','Northern Ireland','H934528',293463,352840,54.41556,-6.56111,36,'BT61 8','Armagh City Banbridge and Craigavon','Northern Ireland','Locality'),
(931,'Annalong','County Down','Northern Ireland','J373196',337331,319688,54.10800,-5.90100,21,'BT34 4','Newry Mourne and Down','Northern Ireland','Locality'),
(932,'Annan','Dumfries','Scotland','NY193665',319357,566587,54.98732,-3.26180,17,'DG12 6','Dumfries and Galloway','Scotland','Town'),
(933,'Annaside','Cumbria','England','SD091866',309112,486641,54.26732,-3.39701,7,'LA19 5','Cumberland','North West','Locality'),
(934,'Annat','Argyll and Bute','Scotland','NN035221',203582,722135,56.35067,-5.18032,63,'PA35 1','Argyll and Bute','Scotland','Hamlet'),
(935,'Annat','Ross and Cromarty','Scotland','NG890542',189067,854263,57.52920,-5.52491,14,'IV22 2','Highland','Scotland','Hamlet'),
(936,'Annathill','Lanarkshire','Scotland','NS726704',272684,670482,55.91054,-4.03835,108,'ML5 2','North Lanarkshire','Scotland','Village'),
(937,'Anna Valley','Hampshire','England','SU344439',434475,143930,51.19356,-1.50803,58,'SP11 7','Test Valley District','South East','Village'),
(938,'Annbank','Ayrshire and Arran','Scotland','NS408232',240802,623258,55.47715,-4.52044,71,'KA6 5','South Ayrshire','Scotland','Village'),
(939,'Annesley','Nottinghamshire','England','SK514534',451430,353432,53.07565,-1.23378,156,'NG15 0','Ashfield District','East Midlands','Suburban Area'),
(940,'Annesley Lane End','Nottinghamshire','England','SK476528',447688,352862,53.07087,-1.28971,152,'NG16 6','Ashfield District','East Midlands','Suburban Area'),
(941,'Annesley Woodhouse','Nottinghamshire','England','SK498534',449840,353473,53.07617,-1.25750,183,'NG17 9','Ashfield District','East Midlands','Village'),
(942,'Annesons Corner','Suffolk','England','TM427667',642767,266791,52.24571,1.55482,9,'IP17 3','East Suffolk District','Eastern','Hamlet'),
(943,'Annfield Plain','Durham','England','NZ164521',416462,552102,54.86343,-1.74506,233,'DH9 8','County Durham','North East','Town'),
(944,'Anniesland','City of Glasgow','Scotland','NS545687',254513,668773,55.89005,-4.32787,24,'G13 1','Glasgow City','Scotland','Suburban Area'),
(945,'Annishader','Ross and Cromarty','Scotland','NG428510',142839,851060,57.47662,-6.29144,34,'IV51 9','Highland','Scotland','Hamlet'),
(946,'Annis Hill','Suffolk','England','TM355895',635500,289500,52.45265,1.46449,30,'NR35 1','East Suffolk District','Eastern','Locality'),
(947,'Annitsford','Northumberland','England','NZ264745',426479,574558,55.06479,-1.58694,52,'NE23 7','Northumberland','North East','Suburban Area'),
(948,'Annochie','Aberdeenshire','Scotland','NJ936424',393647,842455,57.47231,-2.10757,90,'AB41 8','Aberdeenshire','Scotland','Locality'),
(949,'Annsborough','County Down','Northern Ireland','J352368',335236,336898,54.26306,-5.92528,45,'BT31 9','Newry Mourne and Down','Northern Ireland','Locality'),
(950,'Annscroft','Shropshire','England','SJ448074',344883,307449,52.66194,-2.81636,102,'SY5 8','Shropshire','West Midlands','Village'),
(951,'Ann''s Hill','Hampshire','England','SU595005',459500,100500,50.80101,-1.15705,8,'PO12 3','Gosport District','South East','Locality'),
(952,'Annwell Place','Derbyshire','England','SK345185',434500,318500,52.76301,-1.49017,153,'LE65 2','South Derbyshire District','East Midlands','Locality'),
(953,'Ansdell','Lancashire','England','SD346282',334648,428287,53.74684,-2.99245,11,'FY8 4','Fylde District','North West','Suburban Area'),
(954,'Ansdore','Kent','England','TR121490',612129,149001,51.20082,1.03505,76,'CT4 5','Canterbury District','South East','Hamlet'),
(955,'Ansells End','Hertfordshire','England','TL159189',515905,218964,51.85724,-0.31841,116,'SG4 8','North Hertfordshire District','Eastern','Hamlet'),
(956,'Ansford','Somerset','England','ST640328',364028,132850,51.09382,-2.51504,92,'BA7 7','Somerset','South West','Suburban Area'),
(957,'Ansley','Warwickshire','England','SP295921',429574,292146,52.52639,-1.56552,158,'CV10 9','North Warwickshire District','West Midlands','Village'),
(958,'Ansley Common','Warwickshire','England','SP316934',431681,293455,52.53804,-1.53434,133,'CV10 0','North Warwickshire District','West Midlands','Suburban Area'),
(959,'Anslow','Staffordshire','England','SK212253',421213,325354,52.82530,-1.68663,94,'DE13 9','East Staffordshire District','West Midlands','Village'),
(960,'Anslow Common','Staffordshire','England','SK205244',420538,324401,52.81676,-1.69671,105,'DE13 9','East Staffordshire District','West Midlands','Hamlet'),
(961,'Anslow Gate','Staffordshire','England','SK196250',419684,325027,52.82242,-1.70934,98,'DE13 9','East Staffordshire District','West Midlands','Hamlet'),
(962,'Ansteadbrook','Surrey','England','SU929325',492939,132561,51.08485,-0.67448,102,'GU27 2','Waverley District','South East','Hamlet'),
(963,'Anstey','Hampshire','England','SU726403',472681,140311,51.15745,-0.96209,107,'GU34 2','East Hampshire District','South East','Suburban Area'),
(964,'Anstey','Hertfordshire','England','TL405330',540588,233031,51.97796,0.04551,124,'SG9 0','East Hertfordshire District','Eastern','Village'),
(965,'Anstey','Leicestershire','England','SK550086',455025,308675,52.67300,-1.18767,67,'LE7 7','Charnwood District','East Midlands','Village'),
(966,'Anstruther','Fife','Scotland','NO569038',356910,703807,56.22486,-2.69652,5,'KY10 3','Fife','Scotland','Town'),
(967,'Anstruther Easter','Fife','Scotland','NO566035',356659,703579,56.22279,-2.70053,5,'KY10 3','Fife','Scotland','Suburban Area'),
(968,'Anstruther Wester','Fife','Scotland','NO564035',356425,703501,56.22207,-2.70429,10,'KY10 3','Fife','Scotland','Suburban Area'),
(969,'Ansty','Dorset','England','ST763028',376304,102896,50.82511,-2.33779,129,'DT2 7','Dorset','South West','Village'),
(970,'Ansty','Warwickshire','England','SP397832',439719,283272,52.44597,-1.41705,90,'CV7 9','Rugby District','West Midlands','Village'),
(971,'Ansty','West Sussex','England','TQ292229',529235,122977,50.99169,-0.15994,67,'RH17 5','Mid Sussex District','South East','Village'),
(972,'Ansty','Wiltshire','England','ST955267',395540,126702,51.03966,-2.06499,117,'SP3 5','Wiltshire','South West','Village'),
(973,'Ansty Coombe','Wiltshire','England','ST955265',395500,126500,51.03784,-2.06556,119,'SP3 5','Wiltshire','South West','Locality'),
(974,'Ansty Cross','Dorset','England','ST769036',376939,103603,50.83150,-2.32882,162,'DT2 7','Dorset','South West','Hamlet'),
(975,'Anthill Common','Hampshire','England','SU643127',464367,112722,50.91039,-1.08585,64,'PO7 6','Winchester District','South East','Suburban Area'),
(976,'Anthony''s Cross','Gloucestershire','England','SO715235',371500,223500,51.90930,-2.41570,64,'GL18 1','Forest of Dean District','South West','Locality'),
(977,'Anthorn','Cumbria','England','NY194582',319484,558224,54.91221,-3.25747,10,'CA7 5','Cumberland','North West','Village'),
(978,'Antingham','Norfolk','England','TG253328',625387,332886,52.84628,1.34555,39,'NR28 0','North Norfolk District','Eastern','Village'),
(979,'An t-Ob','Western Isles','Scotland','NG015862',101539,886293,57.76662,-7.02101,7,'HS5 3','Na h-Eileanan an Iar','Scotland','Village'),
(980,'Anton''s Gowt','Lincolnshire','England','TF295476',529550,347667,53.01064,-0.07053,4,'PE22 7','East Lindsey District','East Midlands','Village'),
(981,'Antonshill','Stirling and Falkirk','Scotland','NS871839',287101,683999,56.03553,-3.81352,32,'FK5 4','Falkirk','Scotland','Suburban Area'),
(982,'Antony','Cornwall','England','SX399545',239996,54505,50.36864,-4.25125,59,'PL11 3','Cornwall','South West','Village'),
(983,'Antony Passage','Cornwall','England','SX414573',241412,57389,50.39494,-4.23257,5,'PL12 4','Cornwall','South West','Hamlet'),
(984,'Antrim','County Antrim','Northern Ireland','J156869',315690,386954,54.71730,-6.20550,37,'BT41 1','Antrim and Newtownabbey','Northern Ireland','Town'),
(985,'Antrobus','Cheshire','England','SJ643797',364308,379760,53.31356,-2.53718,73,'CW9 6','Cheshire West and Chester','North West','Village'),
(986,'Antron','Cornwall','England','SW761334',176163,33447,50.15872,-5.13515,135,'TR10 9','Cornwall','South West','Hamlet'),
(987,'Anvil Green','Kent','England','TR107495',610707,149598,51.20671,1.01507,142,'CT4 7','Canterbury District','South East','Hamlet'),
(988,'Anvilles','Berkshire','England','SU345655',434500,165500,51.38750,-1.50559,113,'RG17 0','West Berkshire','South East','Locality'),
(989,'Anwick','Lincolnshire','England','TF114505',511467,350574,53.04083,-0.33892,14,'NG34 9','North Kesteven District','East Midlands','Village'),
(990,'Anwoth','The Stewartry of Kirkcudbright','Scotland','NX582562',258242,556225,54.88062,-4.21115,25,'DG7 2','Dumfries and Galloway','Scotland','Hamlet'),
(991,'Aonachan','Inverness','Scotland','NN206813',220692,781314,56.88842,-4.94493,76,'PH34 4','Highland','Scotland','Locality'),
(992,'Apedale','Staffordshire','England','SJ813490',381346,349082,53.03868,-2.27965,205,'ST5 6','Newcastle-under-Lyme District','West Midlands','Hamlet'),
(993,'Aperfield','Greater London','England','TQ425585',542500,158500,51.30778,0.04300,208,'TN16 3','Bromley','London','Locality'),
(994,'Apes Dale','Worcestershire','England','SO988729',398809,272938,52.35450,-2.01891,172,'B60 1','Bromsgrove District','West Midlands','Hamlet'),
(995,'Apethorpe','Northamptonshire','England','TL023957',502323,295733,52.54984,-0.49238,44,'PE8 5','North Northamptonshire','East Midlands','Village'),
(996,'Apeton','Staffordshire','England','SJ851182',385183,318273,52.76185,-2.22101,94,'ST20 0','Stafford District','West Midlands','Hamlet'),
(997,'Apley','Lincolnshire','England','TF110751',511022,375150,53.26174,-0.33704,16,'LN8 5','West Lindsey District','East Midlands','Hamlet'),
(998,'Apley Forge','Shropshire','England','SO705985',370500,298500,52.58350,-2.43682,43,'WV16 4','Shropshire','West Midlands','Locality'),
(999,'Apperknowle','Derbyshire','England','SK380780',438084,378037,53.29793,-1.43005,157,'S18 4','North East Derbyshire District','East Midlands','Village'),
(1000,'Apperley','Gloucestershire','England','SO862283',386216,228366,51.95361,-2.20198,41,'GL19 4','Tewkesbury District','South West','Village'),
(1001,'Apperley Bridge','West Yorkshire','England','SE189379',418921,437926,53.83725,-1.71396,57,'BD10 0','Bradford District','Yorkshire and the Humber','Suburban Area'),
(1002,'Apperley Dene','Northumberland','England','NZ055585',405500,558500,54.92117,-1.91572,92,'NE43 7','Northumberland','North East','Locality'),
(1003,'Appersett','North Yorkshire','England','SD857906',385783,490665,54.31138,-2.22002,235,'DL8 3','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(1004,'Appietown','Orkney','Scotland','HY316177',331673,1017778,59.04152,-3.19246,31,'KW17 2','Orkney Islands','Scotland','Suburban Area'),
(1005,'Appin','Argyll and Bute','Scotland','NM936462',193653,746218,56.56244,-5.35973,14,'PA38 4','Argyll and Bute','Scotland','Village'),
(1006,'Appleby','Lincolnshire','England','SE952150',495230,415029,53.62315,-0.56165,14,'DN15 0','North Lincolnshire','Yorkshire and the Humber','Village'),
(1007,'Appleby-in-Westmorland','Cumbria','England','NY683203',368343,520394,54.57776,-2.49126,133,'CA16 6','Westmorland and Furness','North West','Town'),
(1008,'Appleby Magna','Leicestershire','England','SK318097',431809,309793,52.68490,-1.53089,96,'DE12 7','North West Leicestershire District','East Midlands','Village'),
(1009,'Appleby Parva','Leicestershire','England','SK308089',430894,308981,52.67765,-1.54450,103,'DE12 7','North West Leicestershire District','East Midlands','Hamlet'),
(1010,'Appleby Yard','Greater London','England','TQ392797',539284,179792,51.49991,0.00524,11,'SE10 0','Greenwich','London','Locality'),
(1011,'Applecross','Ross and Cromarty','Scotland','NG712445',171222,844565,57.43361,-5.81317,9,'IV54 8','Highland','Scotland','Village'),
(1012,'Appledore','Devon','England','ST067144',306755,114478,50.92220,-3.32799,129,'EX16 7','Mid Devon District','South West','Hamlet'),
(1013,'Appledore','Devon','England','SS464304',246497,130469,51.05300,-4.19152,9,'EX39 1','Torridge District','South West','Village'),
(1014,'Appledore','Kent','England','TQ956293',595673,129321,51.02994,0.78914,11,'TN26 2','Ashford District','South East','Village'),
(1015,'Appledore Heath','Kent','England','TQ951310',595128,131074,51.04587,0.78232,14,'TN26 2','Ashford District','South East','Village');
INSERT INTO uk_towns VALUES
(1016,'Appleford-on-Thames','Oxfordshire','England','SU526936',452672,193615,51.63888,-1.24028,54,'OX14 4','Vale of White Horse District','South East','Village'),
(1017,'Applegarth','North Yorkshire','England','NZ129016',412936,501652,54.41016,-1.80220,176,'DL10 4','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(1018,'Applegarthtown','Dumfries','Scotland','NY105845',310500,584500,55.14672,-3.40580,49,'DG11 1','Dumfries and Galloway','Scotland','Locality'),
(1019,'Applehouse Hill','Berkshire','England','SU835825',483500,182500,51.53524,-0.79753,86,'SL6 6','Windsor and Maidenhead','South East','Locality'),
(1020,'Applemore','Hampshire','England','SU398072',439898,107296,50.86380,-1.43445,16,'SO45 5','New Forest District','South East','Hamlet'),
(1021,'Appleshaw','Hampshire','England','SU307486',430757,148600,51.23576,-1.56083,90,'SP11 9','Test Valley District','South East','Village'),
(1022,'Applethwaite','Cumbria','England','NY265257',326517,525723,54.62128,-3.13955,137,'CA12 4','Cumberland','North West','Village'),
(1023,'Appleton','Cheshire','England','SJ513866',351309,386643,53.37439,-2.73333,33,'WA8 7','Halton','North West','Suburban Area'),
(1024,'Appleton','Oxfordshire','England','SP442013',444229,201374,51.70937,-1.36129,90,'OX13 5','Vale of White Horse District','South East','Village'),
(1025,'Appleton-le-Moors','North Yorkshire','England','SE734880',473456,488079,54.28308,-0.87323,133,'YO62 6','North Yorkshire','Yorkshire and the Humber','Village'),
(1026,'Appleton-le-Street','North Yorkshire','England','SE737734',473738,473497,54.15201,-0.87247,45,'YO17 6','North Yorkshire','Yorkshire and the Humber','Village'),
(1027,'Appleton Park','Cheshire','England','SJ618837',361836,383768,53.34941,-2.57476,79,'WA4 5','Warrington','North West','Suburban Area'),
(1028,'Appleton Roebuck','North Yorkshire','England','SE554423',455475,442353,53.87442,-1.15773,10,'YO23 7','North Yorkshire','Yorkshire and the Humber','Village'),
(1029,'Appleton Thorn','Cheshire','England','SJ638838',363808,383861,53.35039,-2.54515,77,'WA4 4','Warrington','North West','Village'),
(1030,'Appleton Wiske','North Yorkshire','England','NZ390048',439043,504818,54.43728,-1.39957,52,'DL6 2','North Yorkshire','Yorkshire and the Humber','Village'),
(1031,'Appletree','Northamptonshire','England','SP484496',448426,249688,52.14337,-1.29377,145,'NN11 6','West Northamptonshire','East Midlands','Hamlet'),
(1032,'Appletree','Powys','Wales','SO321967',332194,296722,52.56408,-3.00174,282,'SY5 0','Powys','Wales','Hamlet'),
(1033,'Appletreehall','Roxburgh, Ettrick and Lauderdale','Scotland','NT518174',351836,617479,55.44879,-2.76299,160,'TD9 8','Scottish Borders','Scotland','Hamlet'),
(1034,'Appletreewick','North Yorkshire','England','SE052601',405239,460107,54.03692,-1.92150,157,'BD23 6','North Yorkshire','Yorkshire and the Humber','Village'),
(1035,'Appley','Isle of Wight','England','SZ604918',460476,91860,50.72323,-1.14462,46,'PO33 1','Isle of Wight','South East','Suburban Area'),
(1036,'Appley','Somerset','England','ST071214',307137,121470,50.98512,-3.32434,122,'TA21 0','Somerset','South West','Hamlet'),
(1037,'Appley Bridge','Lancashire','England','SD523100',352384,410007,53.58448,-2.72073,63,'WN6 9','West Lancashire District','North West','Village'),
(1038,'Appley Corner','Bedfordshire','England','TL106411',510622,241112,52.05736,-0.38797,62,'MK45 3','Central Bedfordshire','Eastern','Hamlet'),
(1039,'Appspond','Hertfordshire','England','TL113055',511301,205535,51.73748,-0.38954,124,'AL2 3','St. Albans District','Eastern','Locality'),
(1040,'Apse Heath','Isle of Wight','England','SZ564833',456459,83357,50.64717,-1.20281,54,'PO36 0','Isle of Wight','South East','Village'),
(1041,'Apsey Green','Suffolk','England','TM273634',627320,263456,52.22237,1.32673,36,'IP13 9','East Suffolk District','Eastern','Hamlet'),
(1042,'Apsley','Hertfordshire','England','TL061051',506118,205130,51.73484,-0.46470,80,'HP3 9','Dacorum District','Eastern','Suburban Area'),
(1043,'Apsley End','Bedfordshire','England','TL122331',512209,233104,51.98507,-0.36745,54,'SG5 3','Central Bedfordshire','Eastern','Village'),
(1044,'Apuldram','West Sussex','England','SU842031',484235,103183,50.82207,-0.80550,5,'PO20 7','Chichester District','South East','Hamlet'),
(1045,'Aqueduct','Shropshire','England','SJ689056',368968,305656,52.64774,-2.46010,131,'TF4 3','Telford and Wrekin','West Midlands','Suburban Area'),
(1046,'Aquhythie','Aberdeenshire','Scotland','NJ743183',374339,818338,57.25500,-2.42696,121,'AB51 5','Aberdeenshire','Scotland','Hamlet'),
(1047,'Arabella','Ross and Cromarty','Scotland','NH801754',280161,875448,57.75268,-4.01534,5,'IV19 1','Highland','Scotland','Village'),
(1048,'Arbirlot','Angus','Scotland','NO600404',360067,740481,56.55460,-2.65121,51,'DD11 2','Angus','Scotland','Village'),
(1049,'Arborfield','Berkshire','England','SU753676',475350,167648,51.40287,-0.91817,49,'RG2 9','Wokingham','South East','Village'),
(1050,'Arborfield Cross','Berkshire','England','SU762668',476235,166826,51.39536,-0.90563,69,'RG2 9','Wokingham','South East','Village'),
(1051,'Arborfield Garrison','Berkshire','England','SU769658',476954,165841,51.38641,-0.89551,52,'RG2 9','Wokingham','South East','Village'),
(1052,'Arbourthorne','South Yorkshire','England','SK370859',437048,385926,53.36891,-1.44467,138,'S2 2','Sheffield District','Yorkshire and the Humber','Suburban Area'),
(1053,'Arbourthorne Estate','South Yorkshire','England','SK368847',436869,384738,53.35824,-1.44750,189,'S2 2','Sheffield District','Yorkshire and the Humber','Suburban Area'),
(1054,'Arbroath','Angus','Scotland','NO642413',364201,741306,56.56234,-2.58408,15,'DD11 1','Angus','Scotland','Town'),
(1055,'Arbury','Cambridgeshire','England','TL450607',545034,260760,52.22595,0.12199,16,'CB4 2','Cambridge District','Eastern','Suburban Area'),
(1056,'Arbuthnott','Kincardineshire','Scotland','NO798753',379830,775386,56.86944,-2.33248,84,'AB30 1','Aberdeenshire','Scotland','Village'),
(1057,'Arcan','Ross and Cromarty','Scotland','NH500531',250022,853126,57.54331,-4.50741,22,'IV6 7','Highland','Scotland','Locality'),
(1058,'Arcan Muir','Ross and Cromarty','Scotland','NH489530',248942,853036,57.54214,-4.52537,88,'IV6 7','Highland','Scotland','Locality'),
(1059,'Archdeacon Newton','Durham','England','NZ254171',425442,517197,54.54939,-1.60819,64,'DL2 2','Darlington','North East','Hamlet'),
(1060,'Archenfield','Herefordshire','England','SO259424',325996,242494,52.07584,-3.08120,129,'HR3 5','County of Herefordshire','West Midlands','Hamlet'),
(1061,'Archenfield','Herefordshire','England','SO594234',359439,223446,51.90806,-2.59102,51,'HR9 5','County of Herefordshire','West Midlands','Suburban Area'),
(1062,'Archerfield the Village','East Lothian','Scotland','NT509850',350950,685006,56.05538,-2.78916,13,'EH39 5','East Lothian','Scotland','Village'),
(1063,'Archerfield The Village','East Lothian','Scotland','NT505845',350500,684500,56.05079,-2.79629,13,'EH39 5','East Lothian','Scotland','Locality'),
(1064,'Archiestown','Moray','Scotland','NJ231441',323176,844174,57.48127,-3.28288,231,'AB38 7','Moray','Scotland','Village'),
(1065,'Archway','Greater London','England','TQ294868',529446,186886,51.56600,-0.13380,58,'N19 3','Islington','London','Suburban Area'),
(1066,'Arclid','Cheshire','England','SJ788623',378896,362397,53.15828,-2.31707,74,'CW11 2','Cheshire East','North West','Village'),
(1067,'Arclid Green','Cheshire','England','SJ783617',378379,361789,53.15279,-2.32476,69,'CW11 4','Cheshire East','North West','Hamlet'),
(1068,'Ardachew','Sutherland','Scotland','NC895042',289575,904281,58.01394,-3.87065,40,'KW9 6','Highland','Scotland','Suburban Area'),
(1069,'Ardachu','Sutherland','Scotland','NC674035',267454,903594,58.00172,-4.24436,130,'IV28 3','Highland','Scotland','Hamlet'),
(1070,'Ardalanish','Argyll and Bute','Scotland','NM375195',137500,719500,56.29506,-6.24423,28,'PA67 6','Argyll and Bute','Scotland','Locality'),
(1071,'Ardallie','Aberdeenshire','Scotland','NK010391',401054,839193,57.44306,-1.98409,94,'AB42 5','Aberdeenshire','Scotland','Hamlet'),
(1072,'Ardanaiseig','Argyll and Bute','Scotland','NN085245',208500,724500,56.37390,-5.10259,71,'PA35 1','Argyll and Bute','Scotland','Locality'),
(1073,'Ardaneaskan','Ross and Cromarty','Scotland','NG831353',183159,835351,57.35687,-5.60663,14,'IV54 8','Highland','Scotland','Hamlet'),
(1074,'Ardanstur','Argyll and Bute','Scotland','NM825137',182580,713762,56.26641,-5.51261,17,'PA34 4','Argyll and Bute','Scotland','Hamlet'),
(1075,'Ardarroch','Ross and Cromarty','Scotland','NG836396',183641,839693,57.39602,-5.60245,10,'IV54 8','Highland','Scotland','Hamlet'),
(1076,'Ardbeg','Argyll and Bute','Scotland','NR414464',141498,646424,55.64240,-6.10968,18,'PA42 7','Argyll and Bute','Scotland','Hamlet'),
(1077,'Ardbeg','Argyll and Bute','Scotland','NS083661',208354,666192,55.85074,-5.06307,10,'PA20 0','Argyll and Bute','Scotland','Village'),
(1078,'Ardboe','County Tyrone','Northern Ireland','H960759',296033,375993,54.62300,-6.51400,17,'BT80 0','Mid Ulster','Northern Ireland','Locality'),
(1079,'Ardbrecknish','Argyll and Bute','Scotland','NN070211',207010,721134,56.34310,-5.12420,97,'PA33 1','Argyll and Bute','Scotland','Hamlet'),
(1080,'Ardcharnich','Ross and Cromarty','Scotland','NH173886',217386,888607,57.84956,-5.07876,25,'IV23 2','Highland','Scotland','Hamlet'),
(1081,'Ardchattan','Argyll and Bute','Scotland','NM970348',197044,734887,56.46229,-5.29581,6,'PA37 1','Argyll and Bute','Scotland','Village'),
(1082,'Ardchiavaig','Argyll and Bute','Scotland','NM385191',138537,719178,56.29274,-6.22720,34,'PA67 6','Argyll and Bute','Scotland','Locality'),
(1083,'Ardchonnell','Argyll and Bute','Scotland','NM982123',198202,712368,56.26080,-5.25975,46,'PA35 1','Argyll and Bute','Scotland','Locality'),
(1084,'Ardchronie','Sutherland','Scotland','NH615885',261500,888500,57.86445,-4.33619,57,'IV24 3','Highland','Scotland','Locality'),
(1085,'Ardchullarie More','Stirling and Falkirk','Scotland','NN585135',258500,713500,56.29277,-4.28787,140,'FK17 8','Stirling','Scotland','Locality'),
(1086,'Ardchyle','Stirling and Falkirk','Scotland','NN526290',252613,729024,56.43032,-4.39161,168,'FK21 8','Stirling','Scotland','Hamlet'),
(1087,'Arddleen / Arddlin','Powys','Wales','SJ258157',325865,315789,52.73463,-3.09938,80,'SY22 6','Powys','Wales','Village'),
(1088,'Ard Dorch / An Àird Dhorcha','Ross and Cromarty','Scotland','NG581286',158135,828689,57.28458,-6.01502,9,'IV49 9','Highland','Scotland','Hamlet'),
(1089,'Ardeley','Hertfordshire','England','TL309271',530951,227180,51.92774,-0.09694,125,'SG2 7','East Hertfordshire District','Eastern','Village'),
(1090,'Ardelve','Ross and Cromarty','Scotland','NG871270',187190,827088,57.28468,-5.53264,19,'IV40 8','Highland','Scotland','Village'),
(1091,'Arden','City of Glasgow','Scotland','NS540595',254055,659567,55.80726,-4.33023,36,'G46 8','Glasgow City','Scotland','Suburban Area'),
(1092,'Arden','Dunbartonshire','Scotland','NS359845',235916,684576,56.02590,-4.63452,22,'G83 8','Argyll and Bute','Scotland','Hamlet'),
(1093,'Ardendrain','Inverness','Scotland','NH510381',251038,838180,57.40952,-4.48133,203,'IV4 7','Highland','Scotland','Locality'),
(1094,'Arden Park','Greater Manchester','England','SJ918914',391884,391475,53.42001,-2.12359,87,'SK6 2','Stockport District','North West','Suburban Area'),
(1095,'Ardens Grafton','Warwickshire','England','SP114542',411423,254292,52.18676,-1.83433,92,'B49 6','Stratford-on-Avon District','West Midlands','Village'),
(1096,'Ardentallen','Argyll and Bute','Scotland','NM837240',183708,724033,56.35903,-5.50286,14,'PA34 4','Argyll and Bute','Scotland','Locality'),
(1097,'Ardentinny','Argyll and Bute','Scotland','NS188871',218873,687150,56.04286,-4.90936,4,'PA23 8','Argyll and Bute','Scotland','Village'),
(1098,'Ardeonaig','Stirling and Falkirk','Scotland','NN668357',266844,735775,56.49516,-4.16448,126,'FK21 8','Stirling','Scotland','Village'),
(1099,'Ardersier','Inverness','Scotland','NH782549',278280,854998,57.56860,-4.03660,13,'IV2 7','Highland','Scotland','Village'),
(1100,'Ardery','Inverness','Scotland','NM753626',175371,762615,56.70106,-5.67086,18,'PH36 4','Highland','Scotland','Locality'),
(1101,'Ardessie','Ross and Cromarty','Scotland','NH052896',205251,889681,57.85407,-5.28375,7,'IV23 2','Highland','Scotland','Hamlet'),
(1102,'Ardfern','Argyll and Bute','Scotland','NM806043',180616,704343,56.18105,-5.53646,6,'PA31 8','Argyll and Bute','Scotland','Village'),
(1103,'Ardfernal','Argyll and Bute','Scotland','NR559716',155995,671621,55.87577,-5.90243,42,'PA60 7','Argyll and Bute','Scotland','Hamlet'),
(1104,'Ardfin','Argyll and Bute','Scotland','NR487637',148722,663744,55.80143,-6.01110,66,'PA60 7','Argyll and Bute','Scotland','Locality'),
(1105,'Ardgartan','Argyll and Bute','Scotland','NN273029',227357,702999,56.18822,-4.78360,13,'G83 7','Argyll and Bute','Scotland','Hamlet'),
(1106,'Ardgarvan','County Derry / Londonderry','Northern Ireland','C685200',268548,420032,55.02300,-6.92900,59,'BT49 0','Causeway Coast and Glens','Northern Ireland','Locality'),
(1107,'Ardgay','Sutherland','Scotland','NH599905',259955,890509,57.88199,-4.36339,15,'IV24 3','Highland','Scotland','Village'),
(1108,'Ardgayhill','Sutherland','Scotland','NH594903',259440,890312,57.88006,-4.37195,52,'IV24 3','Highland','Scotland','Locality'),
(1109,'Ardglass','County Down','Northern Ireland','J557375',355784,337575,54.26330,-5.60987,7,'BT30 7','Newry Mourne and Down','Northern Ireland','Locality'),
(1110,'Ardhasaig / Àird Asaig','Western Isles','Scotland','NB127025',112719,902543,57.91935,-6.85334,23,'HS3 3','Na h-Eileanan an Iar','Scotland','Locality'),
(1111,'Ardheisker','Western Isles','Scotland','NF765675',76500,867500,57.58123,-7.41484,2,'HS6 5','Na h-Eileanan an Iar','Scotland','Locality'),
(1112,'Ardheslaig','Ross and Cromarty','Scotland','NG782559',178227,855947,57.53911,-5.70709,16,'IV54 8','Highland','Scotland','Hamlet'),
(1113,'Ardifuir','Argyll and Bute','Scotland','NR785965',178500,696500,56.10974,-5.56396,3,'PA31 8','Argyll and Bute','Scotland','Locality'),
(1114,'Ardinamir','Argyll and Bute','Scotland','NM755115',175500,711500,56.24283,-5.62477,52,'PA34 4','Argyll and Bute','Scotland','Locality'),
(1115,'Ardindrean','Ross and Cromarty','Scotland','NH159879',215995,887984,57.84340,-5.10168,44,'IV23 2','Highland','Scotland','Hamlet'),
(1116,'Ardingly','West Sussex','England','TQ348294',534814,129440,51.04850,-0.07809,113,'RH17 6','Mid Sussex District','South East','Village'),
(1117,'Ardington','Oxfordshire','England','SU431883',443137,188351,51.59236,-1.37869,96,'OX12 8','Vale of White Horse District','South East','Village'),
(1118,'Ardington Wick','Oxfordshire','England','SU435895',443500,189500,51.60267,-1.37331,77,'OX12 8','Vale of White Horse District','South East','Locality'),
(1119,'Ardintoul','Ross and Cromarty','Scotland','NG835245',183500,824500,57.25975,-5.59146,1,'IV40 8','Highland','Scotland','Locality'),
(1120,'Ardlawhill','Aberdeenshire','Scotland','NJ875625',387500,862500,57.65223,-2.21110,102,'AB43 6','Aberdeenshire','Scotland','Locality'),
(1121,'Ardleigh','Essex','England','TM053293',605330,229311,51.92444,0.98475,39,'CO7 7','Tendring District','Eastern','Village'),
(1122,'Ardleigh Green','Greater London','England','TQ539892',553926,189223,51.58085,0.22015,33,'RM11 2','Havering','London','Suburban Area'),
(1123,'Ardleigh Heath','Essex','England','TM046302',604613,230295,51.93354,0.97492,38,'CO7 7','Tendring District','Eastern','Hamlet'),
(1124,'Ardler','City of Dundee','Scotland','NO375331',337527,733123,56.48604,-3.01605,121,'DD2 3','Dundee City','Scotland','Suburban Area'),
(1125,'Ardler','Perth and Kinross','Scotland','NO263419',326356,741922,56.56346,-3.19990,56,'PH12 8','Perth and Kinross','Scotland','Village'),
(1126,'Ardley','Oxfordshire','England','SP542273',454270,227321,51.94175,-1.21192,123,'OX27 7','Cherwell District','South East','Village'),
(1127,'Ardley End','Essex','England','TL526144',552650,214440,51.80776,0.21277,80,'CM22 7','Uttlesford District','Eastern','Village'),
(1128,'Ardlui','Dunbartonshire','Scotland','NN317152',231772,715267,56.29990,-4.72035,25,'G83 7','Argyll and Bute','Scotland','Locality'),
(1129,'Ardmair','Ross and Cromarty','Scotland','NH108983',210853,898307,57.93383,-5.19637,5,'IV26 2','Highland','Scotland','Locality'),
(1130,'Ardmenish','Argyll and Bute','Scotland','NR575735',157500,673500,55.89337,-5.88011,3,'PA60 7','Argyll and Bute','Scotland','Locality'),
(1131,'Ardminish','Argyll and Bute','Scotland','NR648486',164871,648628,55.67403,-5.74105,7,'PA41 7','Argyll and Bute','Scotland','Village'),
(1132,'Ardmolich','Inverness','Scotland','NM715725',171500,772500,56.78780,-5.74276,12,'PH38 4','Highland','Scotland','Locality'),
(1133,'Ardmore','County Derry / Londonderry','Northern Ireland','C462122',246240,412287,54.95600,-7.27900,127,'BT47 3','Derry City and Strabane','Northern Ireland','Locality'),
(1134,'Ardmore','Ross and Cromarty','Scotland','NH702861',270249,886109,57.84561,-4.18754,6,'IV19 1','Highland','Scotland','Hamlet'),
(1135,'Ardmore / Àird Mhòr','Western Isles','Scotland','NF796461',79691,846185,57.39287,-7.33377,5,'HS8 5','Na h-Eileanan an Iar','Scotland','Locality'),
(1136,'Ardnadam','Argyll and Bute','Scotland','NS164801',216492,680158,55.97922,-4.94275,15,'PA23 8','Argyll and Bute','Scotland','Suburban Area'),
(1137,'Ardnagoine','Ross and Cromarty','Scotland','NB995085',199500,908500,58.02026,-5.39640,2,'IV26 2','Highland','Scotland','Locality'),
(1138,'Ardnagrask','Ross and Cromarty','Scotland','NH517495',251719,849512,57.51144,-4.47688,73,'IV6 7','Highland','Scotland','Hamlet'),
(1139,'Ardnarff','Ross and Cromarty','Scotland','NG889356',188910,835643,57.36219,-5.51147,10,'IV53 8','Highland','Scotland','Locality'),
(1140,'Ardnastang','Inverness','Scotland','NM802617',180217,761759,56.69569,-5.59115,42,'PH36 4','Highland','Scotland','Suburban Area'),
(1141,'Ardnastruban / Àird nan Srùban','Western Isles','Scotland','NF845573',84503,857352,57.49612,-7.26843,6,'HS6 5','Na h-Eileanan an Iar','Scotland','Locality'),
(1142,'Ardo','Aberdeenshire','Scotland','NJ844391',384426,839158,57.44247,-2.26110,30,'AB41 7','Aberdeenshire','Scotland','Locality'),
(1143,'Ardoch','Dunbartonshire','Scotland','NS364763',236402,676341,55.95216,-4.62172,14,'G82 5','Argyll and Bute','Scotland','Hamlet'),
(1144,'Ardonald','Aberdeenshire','Scotland','NJ455445',345500,844500,57.48744,-2.91071,207,'AB54 4','Aberdeenshire','Scotland','Locality'),
(1145,'Ardoyne','Aberdeenshire','Scotland','NJ655275',365500,827500,57.33671,-2.57474,180,'AB52 6','Aberdeenshire','Scotland','Locality'),
(1146,'Ardpeaton','Dunbartonshire','Scotland','NS217854',221774,685461,56.02879,-4.86173,55,'G84 0','Argyll and Bute','Scotland','Village'),
(1147,'Ardrishaig','Argyll and Bute','Scotland','NR851857',185120,685799,56.01679,-5.44912,9,'PA30 8','Argyll and Bute','Scotland','Village'),
(1148,'Ardroag','Ross and Cromarty','Scotland','NG275435',127500,843500,57.39998,-6.53802,1,'IV55 8','Highland','Scotland','Locality'),
(1149,'Ardroil / Eadar Dha Fhadhail','Western Isles','Scotland','NB044321',104406,932173,58.17903,-7.03034,14,'HS2 9','Na h-Eileanan an Iar','Scotland','Locality'),
(1150,'Ardross','Ross and Cromarty','Scotland','NH616743',261609,874346,57.73745,-4.32616,183,'IV17 0','Highland','Scotland','Village'),
(1151,'Ardrossan','Ayrshire and Arran','Scotland','NS229421',222959,642152,55.64058,-4.81450,5,'KA22 8','North Ayrshire','Scotland','Town'),
(1152,'Ardshealach','Inverness','Scotland','NM685675',168500,767500,56.74149,-5.78723,9,'PH36 4','Highland','Scotland','Locality'),
(1153,'Ardskenish','Argyll and Bute','Scotland','NR345915',134500,691500,56.04253,-6.26462,7,'PA61 7','Argyll and Bute','Scotland','Locality'),
(1154,'Ardslave / Àird Shleibhe','Western Isles','Scotland','NG110895',111005,889544,57.80191,-6.86640,36,'HS3 3','Na h-Eileanan an Iar','Scotland','Hamlet'),
(1155,'Ardsley','South Yorkshire','England','SE377058',437745,405815,53.54762,-1.43182,75,'S71 5','Barnsley District','Yorkshire and the Humber','Suburban Area'),
(1156,'Ardstraw','County Tyrone','Northern Ireland','H349873',234979,387303,54.73250,-7.45778,38,'BT78 4','Derry City and Strabane','Northern Ireland','Locality'),
(1157,'Ardtalnaig','Perth and Kinross','Scotland','NN701392',270189,739213,56.52696,-4.11191,137,'PH15 2','Perth and Kinross','Scotland','Hamlet'),
(1158,'Ardtoe / Àird Tobha','Inverness','Scotland','NM633703',163330,770359,56.76453,-5.87420,28,'PH36 4','Highland','Scotland','Hamlet'),
(1159,'Ardtreck','Ross and Cromarty','Scotland','NG335345',133500,834500,57.32293,-6.42874,3,'IV47 8','Highland','Scotland','Locality'),
(1160,'Ardtun','Argyll and Bute','Scotland','NM382230',138292,723050,56.32730,-6.23499,10,'PA67 6','Argyll and Bute','Scotland','Village'),
(1161,'Arduaine','Argyll and Bute','Scotland','NM801100',180106,710067,56.23214,-5.54940,14,'PA34 4','Argyll and Bute','Scotland','Locality'),
(1162,'Ardullie','Ross and Cromarty','Scotland','NH585635',258500,863500,57.63915,-4.37196,81,'IV16 9','Highland','Scotland','Locality'),
(1163,'Ardvannie','Ross and Cromarty','Scotland','NH682873',268237,887348,57.85614,-4.22210,32,'IV19 1','Highland','Scotland','Locality'),
(1164,'Ardvasar / Àird a'' Bhasair','Ross and Cromarty','Scotland','NG633033',163329,803343,57.06015,-5.90500,12,'IV45 8','Highland','Scotland','Village'),
(1165,'Ardverikie','Inverness','Scotland','NN505875',250500,787500,56.95451,-4.45985,260,'PH20 1','Highland','Scotland','Locality'),
(1166,'Ardvey / Àird Mhìghe','Western Isles','Scotland','NG080868',108010,886889,57.77621,-6.91337,10,'HS3 3','Na h-Eileanan an Iar','Scotland','Hamlet'),
(1167,'Ardvourlie / Àird a'' Mhulaidh','Western Isles','Scotland','NB189105',118919,910574,57.99519,-6.75858,11,'HS3 3','Na h-Eileanan an Iar','Scotland','Locality'),
(1168,'Ardwell','Wigtown','Scotland','NX109457',210910,545725,54.77073,-4.94112,5,'DG9 9','Dumfries and Galloway','Scotland','Village'),
(1169,'Ardwick','Greater Manchester','England','SJ854972',385485,397253,53.47181,-2.22014,45,'M12 6','Manchester District','North West','Suburban Area'),
(1170,'Arean','Inverness','Scotland','NM645735',164500,773500,56.79327,-5.85800,119,'PH36 4','Highland','Scotland','Locality'),
(1171,'Areley Kings','Worcestershire','England','SO802703',380232,270385,52.33119,-2.29151,51,'DY13 0','Wyre Forest District','West Midlands','Suburban Area'),
(1172,'Arford','Hampshire','England','SU827367',482776,136743,51.12400,-0.81858,86,'GU35 8','East Hampshire District','South East','Village'),
(1173,'Argoed','Clwyd','Wales','SJ376425',337679,342562,52.97677,-2.92957,71,'LL13 0','Wrexham / Wrecsam','Wales','Hamlet'),
(1174,'Argoed','Gwent','Wales','SO175004',317553,200452,51.69674,-3.19431,238,'NP12 0','Caerphilly / Caerffili','Wales','Village'),
(1175,'Argoed','Shropshire','England','SJ330203',333010,320300,52.77611,-2.99450,69,'SY10 8','Shropshire','West Midlands','Hamlet'),
(1176,'Argoed','Shropshire','England','SO294845',329497,284514,52.45401,-3.03892,296,'SY7 8','Shropshire','West Midlands','Hamlet'),
(1177,'Argos Hill','East Sussex','England','TQ570284',557048,128474,51.03417,0.23844,157,'TN6 3','Wealden District','South East','Village'),
(1178,'Aridhglas','Argyll and Bute','Scotland','NM318232',131813,723255,56.32552,-6.33967,16,'PA66 6','Argyll and Bute','Scotland','Locality'),
(1179,'Arinagour','Argyll and Bute','Scotland','NM224571',122449,757147,56.62367,-6.52668,5,'PA78 6','Argyll and Bute','Scotland','Village'),
(1180,'Arisaig / Àrasaig','Inverness','Scotland','NM660863',166046,786363,56.90935,-5.84457,8,'PH39 4','Highland','Scotland','Village'),
(1181,'Ariundle','Inverness','Scotland','NM825635',182500,763500,56.71237,-5.55542,57,'PH36 4','Highland','Scotland','Locality'),
(1182,'Arivegaig / Airigh Bheagaig','Inverness','Scotland','NM651677',165196,767741,56.74200,-5.84135,7,'PH36 4','Highland','Scotland','Locality'),
(1183,'Arivruaich / Airidh a Bhruaich','Western Isles','Scotland','NB251176',125111,917649,58.06239,-6.66245,31,'HS2 9','Na h-Eileanan an Iar','Scotland','Locality'),
(1184,'Arkendale','North Yorkshire','England','SE389609',438900,460909,54.04269,-1.40745,64,'HG5 0','North Yorkshire','Yorkshire and the Humber','Village'),
(1185,'Arkesden','Essex','England','TL482344',548200,234488,51.98908,0.15688,87,'CB11 4','Uttlesford District','Eastern','Village'),
(1186,'Arkholme','Lancashire','England','SD582722',358265,472230,54.14419,-2.64038,50,'LA6 1','Lancaster District','North West','Village'),
(1187,'Arkleby','Cumbria','England','NY140394',314038,539405,54.74223,-3.33679,82,'CA7 2','Cumberland','North West','Locality'),
(1188,'Arkleside','North Yorkshire','England','SE043806',404383,480615,54.22124,-1.93428,248,'DL8 4','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(1189,'Arkleton','Dumfries','Scotland','NY375915',337500,591500,55.21377,-2.98380,133,'DG13 0','Dumfries and Galloway','Scotland','Locality'),
(1190,'Arkle Town','North Yorkshire','England','NZ007019',400721,501954,54.41304,-1.99040,275,'DL11 6','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(1191,'Arkley','Greater London','England','TQ224958',522421,195805,51.64772,-0.23199,138,'EN5 3','Barnet','London','Suburban Area'),
(1192,'Arksey','South Yorkshire','England','SE579068',457932,406854,53.55512,-1.12699,12,'DN5 0','Doncaster District','Yorkshire and the Humber','Village'),
(1193,'Arkwright Town','Derbyshire','England','SK428710',442807,371042,53.23469,-1.36013,95,'S44 5','North East Derbyshire District','East Midlands','Village'),
(1194,'Arle','Gloucestershire','England','SO930235',393000,223518,51.91015,-2.10317,46,'GL51 7','Cheltenham District','South West','Suburban Area'),
(1195,'Arlebrook','Gloucestershire','England','SO812080',381262,208013,51.77047,-2.27296,56,'GL10 3','Stroud District','South West','Hamlet'),
(1196,'Arlecdon','Cumbria','England','NY049189',304966,518948,54.55681,-3.47101,195,'CA26 3','Cumberland','North West','Village'),
(1197,'Arlescote','Warwickshire','England','SP389486',438999,248628,52.13458,-1.43164,160,'OX17 1','Stratford-on-Avon District','West Midlands','Hamlet'),
(1198,'Arlesey','Bedfordshire','England','TL191357',519152,235708,52.00703,-0.26550,43,'SG15 6','Central Bedfordshire','Eastern','Village'),
(1199,'Arleston','Shropshire','England','SJ661105',366160,310584,52.69188,-2.50211,118,'TF1 2','Telford and Wrekin','West Midlands','Suburban Area'),
(1200,'Arley','Cheshire','England','SJ670809',367087,380918,53.32415,-2.49559,67,'CW9 6','Cheshire East','North West','Hamlet'),
(1201,'Arley Green','Cheshire','England','SJ681808',368191,380852,53.32363,-2.47901,57,'CW9 6','Cheshire East','North West','Hamlet'),
(1202,'Arlingham','Gloucestershire','England','SO715107',371597,210780,51.79494,-2.41325,16,'GL2 7','Stroud District','South West','Village'),
(1203,'Arlington','Devon','England','SS613407',261339,140745,51.14912,-3.98385,199,'EX31 4','North Devon District','South West','Hamlet'),
(1204,'Arlington','East Sussex','England','TQ544074',554413,107419,50.84569,0.19198,13,'BN26 6','Wealden District','South East','Hamlet'),
(1205,'Arlington','Gloucestershire','England','SP110066',411082,206672,51.75863,-1.84084,124,'GL7 5','Cotswold District','South West','Village'),
(1206,'Arlington','Norfolk','England','TG218079',621887,307908,52.62356,1.27680,23,'NR2 2','Norwich District','Eastern','Suburban Area'),
(1207,'Arlington Beccott','Devon','England','SS618417',261837,141769,51.15844,-3.97713,181,'EX31 4','North Devon District','South West','Hamlet'),
(1208,'Armadale','Sutherland','Scotland','NC786646',278604,964664,58.55304,-4.08788,53,'KW14 7','Highland','Scotland','Village'),
(1209,'Armadale','West Lothian','Scotland','NS937685',293795,668594,55.89871,-3.70006,168,'EH48 2','West Lothian','Scotland','Town'),
(1210,'Armadale / Armadail','Ross and Cromarty','Scotland','NG637040',163732,804028,57.06650,-5.89902,17,'IV45 8','Highland','Scotland','Locality'),
(1211,'Armagh','County Armagh','Northern Ireland','H875454',287533,345412,54.34990,-6.65460,46,'BT61 7','Armagh City Banbridge and Craigavon','Northern Ireland','City'),
(1212,'Armathwaite','Cumbria','England','NY506462',350660,546278,54.80892,-2.76918,60,'CA4 9','Westmorland and Furness','North West','Village'),
(1213,'Armigers','Essex','England','TL595285',559500,228500,51.93216,0.31853,102,'CM6 2','Uttlesford District','Eastern','Locality'),
(1214,'Arminghall','Norfolk','England','TG252042',625265,304239,52.58924,1.32412,52,'NR14 8','South Norfolk District','Eastern','Village'),
(1215,'Armitage','Staffordshire','England','SK084160',408412,316021,52.74175,-1.87684,79,'WS15 4','Lichfield District','West Midlands','Village'),
(1216,'Armitage Bridge','West Yorkshire','England','SE133136',413310,413674,53.61944,-1.80026,88,'HD4 7','Kirklees District','Yorkshire and the Humber','Suburban Area'),
(1217,'Armley','West Yorkshire','England','SE274337',427460,433761,53.79943,-1.58457,61,'LS12 2','Leeds District','Yorkshire and the Humber','Suburban Area'),
(1218,'Armoy','County Antrim','Northern Ireland','D067328',306780,432823,55.13111,-6.32667,101,'BT53 8','Causeway Coast and Glens','Northern Ireland','Locality'),
(1219,'Armscote','Warwickshire','England','SP243447',424348,244727,52.10035,-1.64596,76,'CV37 8','Stratford-on-Avon District','West Midlands','Village'),
(1220,'Armsdale','Staffordshire','England','SJ765325',376500,332500,52.88943,-2.35071,111,'ST21 6','Stafford District','West Midlands','Locality'),
(1221,'Armshead','Staffordshire','England','SJ935484',393569,348476,53.03352,-2.09735,266,'ST9 0','Staffordshire Moorlands District','West Midlands','Suburban Area'),
(1222,'Armston','Northamptonshire','England','TL060859',506028,285917,52.46092,-0.44089,60,'PE8 5','North Northamptonshire','East Midlands','Hamlet'),
(1223,'Armthorpe','South Yorkshire','England','SE622048',462299,404856,53.53667,-1.06148,17,'DN3 3','Doncaster District','Yorkshire and the Humber','Village'),
(1224,'Arnaby','Cumbria','England','SD182846',318287,484668,54.25114,-3.25564,29,'LA18 5','Cumberland','North West','Hamlet'),
(1225,'Arnage','Aberdeenshire','Scotland','NJ955388',395593,838859,57.44003,-2.07506,98,'AB41 8','Aberdeenshire','Scotland','Hamlet'),
(1226,'Arncliffe','North Yorkshire','England','SD931718',393158,471819,54.14216,-2.10623,229,'BD23 5','North Yorkshire','Yorkshire and the Humber','Village'),
(1227,'Arncroach','Fife','Scotland','NO513051',351359,705113,56.23606,-2.78627,74,'KY10 2','Fife','Scotland','Village'),
(1228,'Arne','Dorset','England','SY972881',397254,88125,50.69277,-2.04024,31,'BH20 5','Dorset','South West','Hamlet'),
(1229,'Arnesby','Leicestershire','England','SP616924',461685,292447,52.52641,-1.09221,126,'LE8 5','Harborough District','East Midlands','Village'),
(1230,'Arney','County Fermanagh','Northern Ireland','H215386',221518,338643,54.29614,-7.67026,65,'BT92 2','Fermanagh and Omagh','Northern Ireland','Locality'),
(1231,'Arnisdale','Ross and Cromarty','Scotland','NG843104',184304,810484,57.13447,-5.56601,5,'IV40 8','Highland','Scotland','Hamlet'),
(1232,'Arnish','Ross and Cromarty','Scotland','NG594480',159418,848037,57.45863,-6.01271,46,'IV40 8','Highland','Scotland','Locality'),
(1233,'Arniston','Midlothian','Scotland','NT339621',333915,662114,55.84769,-3.05702,151,'EH23 4','Midlothian','Scotland','Suburban Area'),
(1234,'Arnol','Western Isles','Scotland','NB311486',131129,948610,58.34327,-6.59653,44,'HS2 9','Na h-Eileanan an Iar','Scotland','Village'),
(1235,'Arnold','East Riding of Yorkshire','England','TA126414',512637,441443,53.85700,-0.28897,8,'HU11 5','East Riding of Yorkshire','Yorkshire and the Humber','Village'),
(1236,'Arnold','Nottinghamshire','England','SK587453',458753,345363,53.00237,-1.12595,67,'NG5 7','Gedling District','East Midlands','Town'),
(1237,'Arnos Grove','Greater London','England','TQ296924',529663,192489,51.61630,-0.12860,33,'N11 1','Enfield','London','Suburban Area'),
(1238,'Arno''s Vale','Bristol','England','ST611715',361177,171535,51.44147,-2.55997,17,'BS4 3','City of Bristol','South West','Suburban Area'),
(1239,'Arnothill','Stirling and Falkirk','Scotland','NS882798',288250,679845,55.99849,-3.79335,32,'FK1 5','Falkirk','Scotland','Suburban Area'),
(1240,'Arnprior','Stirling and Falkirk','Scotland','NS612949',261251,694911,56.12670,-4.23373,32,'FK8 3','Stirling','Scotland','Locality'),
(1241,'Arnside','Cumbria','England','SD455787',345599,478751,54.20161,-2.83544,11,'LA5 0','Westmorland and Furness','North West','Village'),
(1242,'Aros','Argyll and Bute','Scotland','NM556448',155646,744832,56.53179,-5.97541,7,'PA72 6','Argyll and Bute','Scotland','Locality'),
(1243,'Arowry','Clwyd','Wales','SJ458391',345871,339164,52.94712,-2.80701,106,'SY13 3','Wrexham / Wrecsam','Wales','Hamlet'),
(1244,'Arpafeelie','Ross and Cromarty','Scotland','NH613504',261374,850443,57.52285,-4.31640,60,'IV1 3','Highland','Scotland','Hamlet'),
(1245,'Arpinge','Kent','England','TR192391',619252,139180,51.10996,1.13087,174,'CT18 8','Folkestone and Hythe District','South East','Hamlet'),
(1246,'Arrad Foot','Cumbria','England','SD308809',330817,480930,54.21940,-3.06250,15,'LA12 7','Westmorland and Furness','North West','Hamlet'),
(1247,'Arradoul','Banffshire','Scotland','NJ420629',342034,862945,57.65266,-2.97293,55,'AB56 5','Moray','Scotland','Village'),
(1248,'Arram','East Riding of Yorkshire','England','TA035443',503576,444311,53.88465,-0.42571,3,'HU17 7','East Riding of Yorkshire','Yorkshire and the Humber','Hamlet'),
(1249,'Arran Point','Ayrshire and Arran','Scotland','NS486414',248689,641409,55.64260,-4.40572,131,'KA4 8','East Ayrshire','Scotland','Locality'),
(1250,'Arrathorne','North Yorkshire','England','SE200932',420059,493268,54.33458,-1.69302,112,'DL8 1','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(1251,'Arreton','Isle of Wight','England','SZ540862',454037,86212,50.67307,-1.23665,23,'PO30 3','Isle of Wight','South East','Village'),
(1252,'Arrina / Arinacrinachd','Ross and Cromarty','Scotland','NG744582',174424,858217,57.55758,-5.77258,32,'IV54 8','Highland','Scotland','Hamlet'),
(1253,'Arrington','Cambridgeshire','England','TL327502',532731,250230,52.13444,-0.06214,40,'SG8 0','South Cambridgeshire District','Eastern','Village'),
(1254,'Arrisa','Ross and Cromarty','Scotland','NG745585',174500,858500,57.56015,-5.77157,36,'IV54 8','Highland','Scotland','Locality'),
(1255,'Arrochar / An t-Àrchar','Dunbartonshire','Scotland','NN298038',229841,703859,56.19684,-4.74417,22,'G83 7','Argyll and Bute','Scotland','Village'),
(1256,'Arrow','Warwickshire','England','SP079564',407994,256473,52.20643,-1.88444,47,'B49 5','Stratford-on-Avon District','West Midlands','Village'),
(1257,'Arrowe Hill','Merseyside','England','SJ269870',326944,387097,53.37566,-3.09960,44,'CH49 0','Wirral District','North West','Suburban Area'),
(1258,'Arrowfield Top','Worcestershire','England','SP035745',403500,274500,52.36854,-1.95002,130,'B48 7','Bromsgrove District','West Midlands','Locality'),
(1259,'Arrow Green','Herefordshire','England','SO437587',343725,258705,52.22366,-2.82525,82,'HR6 9','County of Herefordshire','West Midlands','Locality'),
(1260,'Arrowthwaite','Cumbria','England','NX969174',296912,517484,54.54208,-3.59498,78,'CA28 9','Cumberland','North West','Suburban Area'),
(1261,'Arrunden','West Yorkshire','England','SE138064',413887,406455,53.55454,-1.79185,248,'HD9 2','Kirklees District','Yorkshire and the Humber','Hamlet'),
(1262,'Arscott','Shropshire','England','SJ435077',343542,307796,52.66492,-2.83624,111,'SY5 0','Shropshire','West Midlands','Hamlet'),
(1263,'Artafallie','Ross and Cromarty','Scotland','NH625495',262500,849500,57.51473,-4.29708,81,'IV1 3','Highland','Scotland','Locality'),
(1264,'Arthill','Cheshire','England','SJ725855',372500,385500,53.36565,-2.41472,40,'WA14 3','Cheshire East','North West','Locality'),
(1265,'Arthington','West Yorkshire','England','SE272445',427289,444582,53.89670,-1.58621,56,'LS21 1','Leeds District','Yorkshire and the Humber','Village'),
(1266,'Arthingworth','Northamptonshire','England','SP754813',475432,281395,52.42535,-0.89211,124,'LE16 8','West Northamptonshire','East Midlands','Village'),
(1267,'Arthog','Gwynedd','Wales','SH640144',264096,314424,52.71036,-4.01313,26,'LL39 1','Gwynedd','Wales','Village'),
(1268,'Arthrath','Aberdeenshire','Scotland','NJ964363',396470,836312,57.41716,-2.06042,100,'AB41 8','Aberdeenshire','Scotland','Hamlet'),
(1269,'Arthurlie','Renfrewshire','Scotland','NS499585',249996,658525,55.79666,-4.39436,59,'G78 2','East Renfrewshire','Scotland','Suburban Area'),
(1270,'Arthursdale','West Yorkshire','England','SE379376',437901,437652,53.83375,-1.42559,106,'LS15 4','Leeds District','Yorkshire and the Humber','Suburban Area'),
(1271,'Arthur''s Hill','Tyne and Wear','England','NZ234646',423448,564621,54.97565,-1.63521,95,'NE4 5','Newcastle upon Tyne District','North East','Suburban Area'),
(1272,'Arthurstone','Perth and Kinross','Scotland','NO262434',326233,743421,56.57690,-3.20233,57,'PH12 8','Perth and Kinross','Scotland','Hamlet'),
(1273,'Arthurs View','Derbyshire','England','SK438515',443870,351525,53.05918,-1.34687,86,'NG16 5','Amber Valley District','East Midlands','Locality'),
(1274,'Articlave','County Derry / Londonderry','Northern Ireland','C786324',278692,432448,55.13300,-6.76700,67,'BT51 4','Causeway Coast and Glens','Northern Ireland','Locality'),
(1275,'Artigarvan','County Tyrone','Northern Ireland','C385004',238589,400413,54.85000,-7.40000,61,'BT82 0','Derry City and Strabane','Northern Ireland','Locality'),
(1276,'Artikelly','County Derry / Londonderry','Northern Ireland','C682249',268217,424927,55.06700,-6.93300,22,'BT49 0','Causeway Coast and Glens','Northern Ireland','Locality'),
(1277,'Artington','Surrey','England','SU992477',499227,147710,51.21997,-0.58056,40,'GU3 1','Guildford District','South East','Village'),
(1278,'Arundel','West Sussex','England','TQ018070',501889,107080,50.85427,-0.55387,6,'BN18 9','Arun District','South East','Town'),
(1279,'Aryhoulan','Inverness','Scotland','NN015687',201563,768772,56.76814,-5.24862,11,'PH33 7','Highland','Scotland','Locality'),
(1280,'Asby','Cumbria','England','NY061203',306150,520333,54.56948,-3.45315,154,'CA14 4','Cumberland','North West','Village'),
(1281,'Ascog','Argyll and Bute','Scotland','NS106630',210648,663085,55.82376,-5.02431,16,'PA20 9','Argyll and Bute','Scotland','Village'),
(1282,'Ascot','Berkshire','England','SU922688',492221,168808,51.41081,-0.67540,87,'SL5 7','Windsor and Maidenhead','South East','Village'),
(1283,'Ascott','Buckinghamshire','England','SP893233',489373,223314,51.90121,-0.70242,130,'LU7 0','Buckinghamshire','South East','Hamlet'),
(1284,'Ascott','Warwickshire','England','SP322347',432278,234734,52.01010,-1.53114,142,'CV36 5','Stratford-on-Avon District','West Midlands','Hamlet'),
(1285,'Ascott d'' Oyley','Oxfordshire','England','SP305185',430500,218500,51.86425,-1.55848,110,'OX7 6','West Oxfordshire District','South East','Locality'),
(1286,'Ascott Earl','Oxfordshire','England','SP295185',429500,218500,51.86431,-1.57300,96,'OX7 6','West Oxfordshire District','South East','Locality'),
(1287,'Ascott-under-Wychwood','Oxfordshire','England','SP300185',430052,218594,51.86512,-1.56497,100,'OX7 6','West Oxfordshire District','South East','Village'),
(1288,'Ascreavie','Angus','Scotland','NO335575',333500,757500,56.70445,-3.08770,278,'DD8 5','Angus','Scotland','Locality'),
(1289,'Asenby','North Yorkshire','England','SE399754',439910,475402,54.17286,-1.39012,29,'YO7 3','North Yorkshire','Yorkshire and the Humber','Village'),
(1290,'Asfordby','Leicestershire','England','SK708190',470852,319026,52.76420,-0.95141,69,'LE14 3','Melton District','East Midlands','Village'),
(1291,'Asfordby Hill','Leicestershire','England','SK726193',472640,319396,52.76729,-0.92484,106,'LE14 3','Melton District','East Midlands','Village'),
(1292,'Asgarby','Lincolnshire','England','TF335666',533513,366699,53.18065,-0.00360,104,'PE23 4','East Lindsey District','East Midlands','Hamlet'),
(1293,'Asgarby','Lincolnshire','England','TF116452',511624,345247,52.99293,-0.33842,10,'NG34 9','North Kesteven District','East Midlands','Hamlet'),
(1294,'Ash','Devon','England','SX837497',283783,49796,50.33659,-3.63440,129,'TQ6 0','South Hams District','South West','Hamlet'),
(1295,'Ash','Dorset','England','ST865102',386565,110297,50.89200,-2.19239,58,'DT11 8','Dorset','South West','Hamlet'),
(1296,'Ash','Kent','England','TQ598644',559850,164483,51.35693,0.29439,146,'TN15 7','Sevenoaks District','South East','Village'),
(1297,'Ash','Kent','England','TR287584',628703,158414,51.27894,1.27790,19,'CT3 2','Dover District','South East','Village'),
(1298,'Ash','Somerset','England','ST474206',347454,120645,50.98280,-2.74992,60,'TA12 6','Somerset','South West','Village'),
(1299,'Ash','Surrey','England','SU890503',489049,150381,51.24566,-0.72559,77,'GU12 6','Guildford District','South East','Village'),
(1300,'Ashaig / Aisig','Ross and Cromarty','Scotland','NG688240',168865,824012,57.24821,-5.83307,20,'IV42 8','Highland','Scotland','Hamlet'),
(1301,'Ashampstead','Berkshire','England','SU566769',456610,176966,51.48882,-1.18605,136,'RG8 8','West Berkshire','South East','Village'),
(1302,'Ashampstead Green','Berkshire','England','SU564773',456477,177319,51.49200,-1.18791,136,'RG8 8','West Berkshire','South East','Hamlet'),
(1303,'Ashbank','Kent','England','TQ827534',582787,153436,51.25080,0.61781,73,'ME17 1','Maidstone District','South East','Hamlet'),
(1304,'Ash Bank','Staffordshire','England','SJ926470',392682,347026,53.02048,-2.11054,201,'ST2 9','Staffordshire Moorlands District','West Midlands','Suburban Area'),
(1305,'Ashbeer','Somerset','England','ST085355',308500,135500,51.11146,-3.30848,227,'TA4 3','Somerset','South West','Locality'),
(1306,'Ashbocking','Suffolk','England','TM182538',618201,253821,52.13957,1.18725,71,'IP6 9','East Suffolk District','Eastern','Village'),
(1307,'Ashbourne','Derbyshire','England','SK180467',418094,346747,53.01772,-1.73173,130,'DE6 1','Derbyshire Dales District','East Midlands','Town'),
(1308,'Ash Brake','Wiltshire','England','SU138891',413825,189156,51.60108,-1.80179,103,'SN25 2','Swindon','South West','Suburban Area'),
(1309,'Ashbrittle','Somerset','England','ST052214',305218,121418,50.98434,-3.35166,184,'TA21 0','Somerset','South West','Village'),
(1310,'Ashbrook','Hertfordshire','England','TL202277',520247,227757,51.93534,-0.25233,69,'SG4 7','North Hertfordshire District','Eastern','Hamlet'),
(1311,'Ashbrook','Shropshire','England','SO451940',345186,294066,52.54168,-2.80966,214,'SY6 6','Shropshire','West Midlands','Suburban Area'),
(1312,'Ashbrooke','Tyne and Wear','England','NZ392557',439286,555792,54.89533,-1.38899,35,'SR2 7','Sunderland District','North East','Suburban Area'),
(1313,'Ashburnham Forge','East Sussex','England','TQ685165',568500,116500,50.92335,0.39608,35,'TN33 9','Rother District','South East','Locality'),
(1314,'Ashburton','Devon','England','SX756698',275626,69898,50.51562,-3.75563,75,'TQ13 7','Teignbridge District','South West','Town'),
(1315,'Ashbury','Devon','England','SX506978',250689,97897,50.76140,-4.11842,181,'EX20 3','West Devon District','South West','Hamlet'),
(1316,'Ashbury','Oxfordshire','England','SU264850',426440,185053,51.56374,-1.61996,134,'SN6 8','Vale of White Horse District','South East','Village'),
(1317,'Ashby','Lincolnshire','England','SE897083',489728,408326,53.56389,-0.64674,37,'DN16 3','North Lincolnshire','Yorkshire and the Humber','Suburban Area'),
(1318,'Ashby by Partney','Lincolnshire','England','TF428665',542805,366589,53.17725,0.13529,12,'PE23 5','East Lindsey District','East Midlands','Village'),
(1319,'Ashby cum Fenby','Lincolnshire','England','TA253008',525391,400812,53.48909,-0.11157,28,'DN37 0','North East Lincolnshire','Yorkshire and the Humber','Village'),
(1320,'Ashby de la Launde','Lincolnshire','England','TF055549',505516,354997,53.08178,-0.42619,38,'LN4 3','North Kesteven District','East Midlands','Village'),
(1321,'Ashby-de-la-Zouch','Leicestershire','England','SK357167',435749,316724,52.74696,-1.47185,127,'LE65 1','North West Leicestershire District','East Midlands','Town'),
(1322,'Ashby Folville','Leicestershire','England','SK703120',470312,312091,52.70194,-0.96090,89,'LE14 2','Melton District','East Midlands','Village'),
(1323,'Ashby Hill','Lincolnshire','England','TA243004',524330,400473,53.48629,-0.12769,61,'DN37 0','North East Lincolnshire','Yorkshire and the Humber','Hamlet'),
(1324,'Ashby Magna','Leicestershire','England','SP559907',455925,290773,52.51199,-1.17738,122,'LE17 5','Harborough District','East Midlands','Village'),
(1325,'Ashby Parva','Leicestershire','England','SP526883',452651,288362,52.49064,-1.22600,147,'LE17 5','Harborough District','East Midlands','Village'),
(1326,'Ashby Puerorum','Lincolnshire','England','TF327716',532721,371657,53.22538,-0.01338,76,'LN9 6','East Lindsey District','East Midlands','Locality'),
(1327,'Ashby St Ledgers','Northamptonshire','England','SP572681',457219,268131,52.30832,-1.16218,141,'CV23 8','West Northamptonshire','East Midlands','Village'),
(1328,'Ashby St Mary','Norfolk','England','TG325023',632565,302396,52.56963,1.43039,32,'NR14 7','South Norfolk District','Eastern','Village'),
(1329,'Ashby Woulds','Leicestershire','England','SK304161',430419,316161,52.74223,-1.55086,100,'DE12 6','North West Leicestershire District','East Midlands','Locality'),
(1330,'Ashchurch','Gloucestershire','England','SO928332',392853,233271,51.99784,-2.10551,21,'GL20 8','Tewkesbury District','South West','Village'),
(1331,'Ashcombe','Devon','England','SX913795',291344,79587,50.60585,-3.53686,104,'EX7 0','Teignbridge District','South West','Hamlet'),
(1332,'Ashcombe Park','Somerset','England','ST335625',333500,162500,51.35766,-2.95643,82,'BS22 9','North Somerset','South West','Locality'),
(1333,'Ash Corner','Suffolk','England','TM318561',631897,256114,52.15457,1.38859,22,'IP13 0','East Suffolk District','Eastern','Hamlet'),
(1334,'Ashcott','Somerset','England','ST433369',343372,136962,51.12912,-2.81063,45,'TA7 9','Somerset','South West','Village'),
(1335,'Ashcott Corner','Somerset','England','ST449396',344915,139671,51.15363,-2.78899,4,'BA6 9','Somerset','South West','Hamlet'),
(1336,'Ash Cross','Devon','England','SS518081',251820,108161,50.85393,-4.10654,112,'EX20 3','Torridge District','South West','Hamlet'),
(1337,'Ash Cross','Somerset','England','ST282230',328224,123035,51.00221,-3.02430,26,'TA3 5','Somerset','South West','Hamlet'),
(1338,'Ashculme','Devon','England','ST145145',314500,114500,50.92360,-3.21783,172,'EX15 3','Mid Devon District','South West','Locality'),
(1339,'Ashdon','Essex','England','TL586421',558697,242140,52.05492,0.31317,68,'CB10 2','Uttlesford District','Eastern','Village'),
(1340,'Ashe','Hampshire','England','SU534499',453485,149934,51.24608,-1.23512,102,'RG25 3','Basingstoke and Deane District','South East','Hamlet'),
(1341,'Asheldham','Essex','England','TL972013',597283,201398,51.67669,0.85201,22,'CM0 7','Maldon District','Eastern','Village'),
(1342,'Ashen','Essex','England','TL747422',574735,242205,52.05069,0.54688,87,'CO10 8','Braintree District','Eastern','Village'),
(1343,'Ashendon','Buckinghamshire','England','SP704141',470495,214170,51.82172,-0.97861,149,'HP18 0','Buckinghamshire','South East','Village'),
(1344,'Ashengrove','Isle of Wight','England','SZ443875',444354,87528,50.68572,-1.37351,63,'PO30 4','Isle of Wight','South East','Hamlet'),
(1345,'Ashenhurst','West Yorkshire','England','SE148152',414883,415222,53.63331,-1.77640,128,'HD4 6','Kirklees District','Yorkshire and the Humber','Suburban Area'),
(1346,'Asheridge','Buckinghamshire','England','SP939043',493986,204325,51.72977,-0.64054,167,'HP5 2','Buckinghamshire','South East','Village'),
(1347,'Ash Estates','Surrey','England','TQ097668',509733,166897,51.39051,-0.42429,12,'TW17 8','Elmbridge District','South East','Suburban Area'),
(1348,'Ashe Warren','Hampshire','England','SU536517',453668,151715,51.26208,-1.23223,117,'RG25 3','Basingstoke and Deane District','South East','Hamlet'),
(1349,'Ashey','Isle of Wight','England','SZ577892',457791,89274,50.70025,-1.18305,59,'PO33 4','Isle of Wight','South East','Hamlet'),
(1350,'Ashfield','Dyfed','Wales','SN692286',269290,228669,51.94112,-3.90293,54,'SA19 9','Carmarthenshire / Sir Gaerfyrddin','Wales','Village'),
(1351,'Ashfield','Hampshire','England','SU366195',436644,119575,50.97443,-1.47945,18,'SO51 9','Test Valley District','South East','Hamlet'),
(1352,'Ashfield','Herefordshire','England','SO598237',359808,223740,51.91073,-2.58569,71,'HR9 5','County of Herefordshire','West Midlands','Suburban Area'),
(1353,'Ashfield','Stirling and Falkirk','Scotland','NN786039',278607,703951,56.21260,-3.95884,94,'FK15 0','Stirling','Scotland','Village'),
(1354,'Ashfield','West Yorkshire','England','SE387232',438729,423232,53.70409,-1.41481,24,'WF6 2','Wakefield District','Yorkshire and the Humber','Suburban Area'),
(1355,'Ashfield','Worcestershire','England','SO763522',376336,252297,52.16843,-2.34741,47,'WR13 5','Malvern Hills District','West Midlands','Hamlet'),
(1356,'Ashfield Cum Thorpe','Suffolk','England','TM210629',621064,262953,52.22040,1.23496,57,'IP14 6','Mid Suffolk District','Eastern','Village'),
(1357,'Ashfield Green','Suffolk','England','TM260736',626033,273612,52.31405,1.31472,58,'IP21 5','Mid Suffolk District','Eastern','Hamlet'),
(1358,'Ashfield Green','Suffolk','England','TL759557',575978,255763,52.17206,0.57199,118,'CB8 8','West Suffolk District','Eastern','Hamlet'),
(1359,'Ashfields','Shropshire','England','SJ703263',370359,326329,52.83366,-2.44142,93,'TF9 2','Shropshire','West Midlands','Hamlet'),
(1360,'Ashfold Crossways','West Sussex','England','TQ235285',523500,128500,51.04259,-0.23973,102,'RH13 6','Horsham District','South East','Locality'),
(1361,'Ashfold Side','North Yorkshire','England','SE125665',412500,466500,54.09425,-1.81037,259,'HG3 5','North Yorkshire','Yorkshire and the Humber','Locality'),
(1362,'Ashford','Devon','England','SX688485',268875,48578,50.32251,-3.84335,18,'TQ7 4','South Hams District','South West','Hamlet'),
(1363,'Ashford','Devon','England','SS531352',253144,135216,51.09739,-4.09868,46,'EX31 4','North Devon District','South West','Village'),
(1364,'Ashford','Hampshire','England','SU137143',413721,114375,50.92867,-1.80614,39,'SP6 1','New Forest District','South East','Village'),
(1365,'Ashford','Kent','England','TR009427',600904,142717,51.14844,0.87109,58,'TN23 1','Ashford District','South East','Town'),
(1366,'Ashford','Surrey','England','TQ070715',507006,171551,51.43287,-0.46206,16,'TW15 2','Spelthorne District','South East','Town'),
(1367,'Ashford Bowdler','Shropshire','England','SO515710',351558,271057,52.33545,-2.71236,80,'SY8 4','Shropshire','West Midlands','Hamlet'),
(1368,'Ashford Carbonell','Shropshire','England','SO522711',352233,271155,52.33639,-2.70247,80,'SY8 4','Shropshire','West Midlands','Village'),
(1369,'Ashford Common','Surrey','England','TQ089707',508959,170766,51.42544,-0.43422,13,'TW15 1','Spelthorne District','South East','Village'),
(1370,'Ashford Hill','Hampshire','England','SU555619',455540,161918,51.35363,-1.20382,80,'RG19 8','Basingstoke and Deane District','South East','Village'),
(1371,'Ashford in the Water','Derbyshire','England','SK193702',419360,370209,53.22857,-1.71145,159,'DE45 1','Derbyshire Dales District','East Midlands','Village'),
(1372,'Ashgate','Derbyshire','England','SK350717',435019,371778,53.24188,-1.47672,132,'S42 7','Chesterfield District','East Midlands','Suburban Area'),
(1373,'Ashgate','Derbyshire','England','SK363715',436318,371548,53.23972,-1.45729,107,'S40 4','Chesterfield District','East Midlands','Suburban Area'),
(1374,'Ashgill','Lanarkshire','Scotland','NS789499',278921,649923,55.72753,-3.92947,122,'ML9 3','South Lanarkshire','Scotland','Village'),
(1375,'Ash Green','Surrey','England','SU902497',490215,149717,51.23951,-0.70906,90,'GU12 6','Guildford District','South East','Village'),
(1376,'Ash Green','Warwickshire','England','SP333850',433392,285031,52.46221,-1.50996,108,'CV7 9','Nuneaton and Bedworth District','West Midlands','Village'),
(1377,'Ashgrove','Somerset','England','ST708579',370879,157966,51.32005,-2.41926,160,'BA2 8','Bath and North East Somerset','South West','Suburban Area'),
(1378,'Ash Hill','Devon','England','SX915735',291500,73500,50.55116,-3.53287,75,'TQ14 9','Teignbridge District','South West','Locality'),
(1379,'Ashiestiel','Roxburgh, Ettrick and Lauderdale','Scotland','NT425355',342500,635500,55.60969,-2.91432,153,'TD1 3','Scottish Borders','Scotland','Locality'),
(1380,'Ashill','Devon','England','ST087113',308715,111334,50.89425,-3.29933,122,'EX15 3','Mid Devon District','South West','Village'),
(1381,'Ashill','Norfolk','England','TF887045',588741,304567,52.60609,0.78587,74,'IP25 7','Breckland District','Eastern','Village'),
(1382,'Ashill','Somerset','England','ST321173',332176,117397,50.95200,-2.96693,72,'TA19 9','Somerset','South West','Village'),
(1383,'Ashingdon','Essex','England','TQ864932',586465,193280,51.60747,0.69141,31,'SS4 3','Rochford District','Eastern','Village'),
(1384,'Ashington','Dorset','England','SZ000982',400095,98224,50.78359,-2.00002,56,'BH21 3','Bournemouth, Christchurch and Poole','South West','Hamlet'),
(1385,'Ashington','Northumberland','England','NZ275877',427540,587733,55.18312,-1.56906,40,'NE63 0','Northumberland','North East','Town'),
(1386,'Ashington','Somerset','England','ST561213',356144,121385,50.99018,-2.62623,29,'BA22 8','Somerset','South West','Hamlet'),
(1387,'Ashington','West Sussex','England','TQ132161',513230,116101,50.93325,-0.39002,33,'RH20 3','Horsham District','South East','Village'),
(1388,'Ashington End','Lincolnshire','England','TF525665',552500,366500,53.17376,0.28019,1,'PE24 4','East Lindsey District','East Midlands','Locality'),
(1389,'Ashkirk','Roxburgh, Ettrick and Lauderdale','Scotland','NT466219',346617,621914,55.48810,-2.84635,182,'TD7 4','Scottish Borders','Scotland','Village'),
(1390,'Ashland','Buckinghamshire','England','SP871359',487115,235984,52.01545,-0.73202,83,'MK6 4','Milton Keynes','South East','Suburban Area'),
(1391,'Ashlett','Hampshire','England','SU462032',446248,103216,50.82664,-1.34474,22,'SO45 1','New Forest District','South East','Hamlet'),
(1392,'Ashleworth','Gloucestershire','England','SO812255',381219,225583,51.92844,-2.27454,24,'GL19 4','Tewkesbury District','South West','Village'),
(1393,'Ashley','Cambridgeshire','England','TL697616',569797,261638,52.22677,0.48463,94,'CB8 9','East Cambridgeshire District','Eastern','Village'),
(1394,'Ashley','Cheshire','England','SJ774842',377458,384236,53.35452,-2.34013,46,'WA15 0','Cheshire East','North West','Village'),
(1395,'Ashley','Dorset','England','SU138043',413815,104391,50.83888,-1.80517,29,'BH24 2','Dorset','South West','Village'),
(1396,'Ashley','Gloucestershire','England','ST932948',393202,194852,51.65242,-2.09966,126,'GL8 8','Cotswold District','South West','Hamlet'),
(1397,'Ashley','Hampshire','England','SU384307',438419,130788,51.07514,-1.45299,95,'SO20 6','Test Valley District','South East','Hamlet'),
(1398,'Ashley','Hampshire','England','SZ256954',425640,95439,50.75798,-1.63786,37,'BH25 5','New Forest District','South East','Village'),
(1399,'Ashley','Kent','England','TR307487',630747,148739,51.19126,1.30093,79,'CT15 5','Dover District','South East','Village'),
(1400,'Ashley','Northamptonshire','England','SP795908',479552,290889,52.51010,-0.82928,81,'LE16 8','North Northamptonshire','East Midlands','Village'),
(1401,'Ashley','Staffordshire','England','SJ759367',375957,336717,52.92732,-2.35910,163,'TF9 4','Newcastle-under-Lyme District','West Midlands','Village'),
(1402,'Ashley','Wiltshire','England','ST815684',381505,168492,51.41514,-2.26734,54,'SN13 8','Wiltshire','South West','Village'),
(1403,'Ashley Dale','Staffordshire','England','SJ755359',375593,335940,52.92032,-2.36445,174,'TF9 4','Newcastle-under-Lyme District','West Midlands','Village'),
(1404,'Ashley Down','Bristol','England','ST596758',359680,175897,51.48058,-2.58200,50,'BS7 9','City of Bristol','South West','Suburban Area'),
(1405,'Ashley Green','Buckinghamshire','England','SP976051',497688,205187,51.73689,-0.58671,164,'HP5 3','Buckinghamshire','South East','Village'),
(1406,'Ashleyhay','Derbyshire','England','SK293512',429374,351225,53.05747,-1.56318,181,'DE4 4','Amber Valley District','East Midlands','Hamlet'),
(1407,'Ashley Heath','Dorset','England','SU114042',411481,104262,50.83778,-1.83832,28,'BH24 2','Dorset','South West','Village'),
(1408,'Ashley Heath','Greater Manchester','England','SJ771860',377107,386078,53.37106,-2.34554,40,'WA14 3','Trafford District','North West','Suburban Area'),
(1409,'Ashley Heath','Staffordshire','England','SJ748361',374844,336100,52.92172,-2.37560,223,'TF9 4','Newcastle-under-Lyme District','West Midlands','Suburban Area'),
(1410,'Ashley Moor','Herefordshire','England','SO474673',347445,267349,52.30173,-2.77214,125,'SY8 4','County of Herefordshire','West Midlands','Hamlet'),
(1411,'Ashley Park','Surrey','England','TQ101656',510106,165657,51.37930,-0.41932,24,'KT12 1','Elmbridge District','South East','Suburban Area'),
(1412,'Ash Magna','Shropshire','England','SJ569397',356962,339747,52.95336,-2.64204,135,'SY13 4','Shropshire','West Midlands','Village'),
(1413,'Ashmanhaugh','Norfolk','England','TG310208',631071,320819,52.73559,1.42128,14,'NR12 8','North Norfolk District','Eastern','Village'),
(1414,'Ashmansworth','Hampshire','England','SU415574',441512,157438,51.31455,-1.40577,234,'RG20 9','Basingstoke and Deane District','South East','Village'),
(1415,'Ashmansworthy','Devon','England','SS339179',233941,117997,50.93744,-4.36480,174,'EX39 5','Torridge District','South West','Hamlet'),
(1416,'Ashmead Green','Gloucestershire','England','ST766999',376672,199901,51.69737,-2.33893,102,'GL11 5','Stroud District','South West','Village'),
(1417,'Ashmill','Devon','England','SX393953',239347,95315,50.73517,-4.27798,114,'EX21 5','Torridge District','South West','Hamlet'),
(1418,'Ash Mill','Devon','England','SS785232',278560,123254,50.99583,-3.73189,130,'EX36 4','North Devon District','South West','Hamlet'),
(1419,'Ash Moor','Devon','England','SS795195',279500,119500,50.96228,-3.71725,234,'EX36 4','North Devon District','South West','Locality'),
(1420,'Ashmore','Dorset','England','ST912178',391290,117830,50.95983,-2.12539,220,'SP5 5','Dorset','South West','Village'),
(1421,'Ashmore Brook','Staffordshire','England','SK096110',409604,311034,52.69690,-1.85933,99,'WS13 8','Lichfield District','West Midlands','Hamlet'),
(1422,'Ashmore Green','Berkshire','England','SU505695',450525,169502,51.42229,-1.27475,114,'RG18 9','West Berkshire','South East','Village'),
(1423,'Ashmore Lake','West Midlands','England','SJ965001',396599,300118,52.59884,-2.05165,140,'WV12 4','Walsall District','West Midlands','Suburban Area'),
(1424,'Ashmore Park','West Midlands','England','SJ955017',395554,301744,52.61345,-2.06710,154,'WV11 2','City of Wolverhampton District','West Midlands','Suburban Area'),
(1425,'Ashopton','Derbyshire','England','SK195865',419500,386500,53.37500,-1.70836,233,'S33 0','High Peak District','East Midlands','Locality'),
(1426,'Ashorne','Warwickshire','England','SP305577',430536,257743,52.21706,-1.55446,62,'CV35 9','Stratford-on-Avon District','West Midlands','Village'),
(1427,'Ashover','Derbyshire','England','SK348634',434826,363477,53.16728,-1.48052,194,'S45 0','North East Derbyshire District','East Midlands','Village'),
(1428,'Ashover Hay','Derbyshire','England','SK357608',435758,360816,53.14330,-1.46687,210,'S45 0','North East Derbyshire District','East Midlands','Hamlet'),
(1429,'Ashow','Warwickshire','England','SP310703',431090,270350,52.33037,-1.54520,61,'CV8 2','Warwick District','West Midlands','Village'),
(1430,'Ash Parva','Shropshire','England','SJ576394',357646,339459,52.95083,-2.63183,127,'SY13 4','Shropshire','West Midlands','Hamlet'),
(1431,'Ashperton','Herefordshire','England','SO643416',364369,241681,52.07234,-2.52126,95,'HR8 2','County of Herefordshire','West Midlands','Village'),
(1432,'Ashprington','Devon','England','SX818570',281867,57064,50.40154,-3.66359,78,'TQ9 7','South Hams District','South West','Village'),
(1433,'Ash Priors','Somerset','England','ST151295',315191,129503,51.05858,-3.21151,83,'TA4 3','Somerset','South West','Village'),
(1434,'Ashreigney','Devon','England','SS629136',262952,113660,50.90610,-3.95056,170,'EX18 7','Torridge District','South West','Village'),
(1435,'Ashridge Court','Devon','England','SS665035',266500,103500,50.81562,-3.89641,133,'EX20 2','West Devon District','South West','Locality'),
(1436,'Ash Street','Suffolk','England','TM010465',601051,246579,52.08105,0.93273,25,'IP7 6','Babergh District','Eastern','Hamlet'),
(1437,'Ashtead','Surrey','England','TQ186580',518613,158069,51.30939,-0.29966,72,'KT21 1','Mole Valley District','South East','Locality'),
(1438,'Ashtead Common','Surrey','England','TQ170591',517062,159158,51.31949,-0.32155,59,'KT21 2','Mole Valley District','South East','Suburban Area'),
(1439,'Ash Thomas','Devon','England','ST004111',300498,111192,50.89161,-3.41609,75,'EX16 4','Mid Devon District','South West','Village'),
(1440,'Ashton','Cambridgeshire','England','TF102056',510213,305668,52.63758,-0.37277,19,'PE9 3','City of Peterborough','Eastern','Hamlet'),
(1441,'Ashton','Cornwall','England','SX384683',238424,68381,50.49290,-4.27931,137,'PL17 8','Cornwall','South West','Hamlet'),
(1442,'Ashton','Cornwall','England','SW603286',160342,28667,50.10961,-5.35326,128,'TR13 9','Cornwall','South West','Village'),
(1443,'Ashton','Hampshire','England','SU551193',455159,119323,50.97069,-1.21580,80,'SO32 1','Winchester District','South East','Hamlet'),
(1444,'Ashton','Herefordshire','England','SO514644',351466,264438,52.27594,-2.71276,107,'HR6 0','County of Herefordshire','West Midlands','Hamlet'),
(1445,'Ashton','Northamptonshire','England','TL055882',505574,288297,52.48239,-0.44681,43,'PE8 5','North Northamptonshire','East Midlands','Village'),
(1446,'Ashton','Northamptonshire','England','SP765498',476551,249894,52.14204,-0.88281,85,'NN7 2','West Northamptonshire','East Midlands','Village'),
(1447,'Ashton','Renfrewshire','Scotland','NS236772',223629,677265,55.95593,-4.82662,40,'PA19 1','Inverclyde','Scotland','Suburban Area'),
(1448,'Ashton','Somerset','England','ST412498',341285,149822,51.24454,-2.84255,30,'BS28 4','Somerset','South West','Hamlet'),
(1449,'Ashton Bank','Lancashire','England','SD507300',350738,430064,53.76458,-2.74878,22,'PR2 1','Preston District','North West','Suburban Area'),
(1450,'Ashton Common','Wiltshire','England','ST898581',389829,158176,51.32259,-2.14734,60,'BA14 6','Wiltshire','South West','Village'),
(1451,'Ashton Gate','Bristol','England','ST572714',357243,171417,51.44012,-2.61655,8,'BS3 2','City of Bristol','South West','Suburban Area'),
(1452,'Ashton Green','East Sussex','England','TQ462122',546275,112206,50.89082,0.07838,11,'BN8 5','Lewes District','South East','Hamlet'),
(1453,'Ashton Hayes','Cheshire','England','SJ504691',350497,369178,53.21734,-2.74281,41,'CH3 8','Cheshire West and Chester','North West','Village'),
(1454,'Ashton Heath','Greater Manchester','England','SJ584987',358495,398708,53.48344,-2.62692,45,'WN4 9','Wigan District','North West','Suburban Area'),
(1455,'Ashton-in-Makerfield','Greater Manchester','England','SJ577992',357731,399286,53.48858,-2.63851,52,'WN4 9','Wigan District','North West','Town'),
(1456,'Ashton Keynes','Wiltshire','England','SU049942',404955,194206,51.64663,-1.92978,86,'SN6 6','Wiltshire','South West','Village'),
(1457,'Ashton-on-Ribble','Lancashire','England','SD513304',351353,430496,53.76852,-2.73952,25,'PR2 1','Preston District','North West','Suburban Area'),
(1458,'Ashton''s Green','Merseyside','England','SJ540952',354016,395233,53.45184,-2.69390,35,'WA9 2','St. Helens District','North West','Suburban Area'),
(1459,'Ashton under Hill','Worcestershire','England','SO997381',399716,238162,52.04186,-2.00555,69,'WR11 7','Wychavon District','West Midlands','Village'),
(1460,'Ashton-under-Lyne','Greater Manchester','England','SJ938992',393874,399295,53.49033,-2.09380,119,'OL6 6','Tameside District','North West','Town'),
(1461,'Ashton upon Mersey','Greater Manchester','England','SJ777922',377700,392221,53.42630,-2.33706,29,'M33 6','Trafford District','North West','Suburban Area'),
(1462,'Ashton Vale','Bristol','England','ST566704',356609,170477,51.43162,-2.62556,12,'BS3 2','City of Bristol','South West','Suburban Area'),
(1463,'Ashton Watering','Somerset','England','ST526697',352628,169759,51.42485,-2.68272,56,'BS48 3','North Somerset','South West','Hamlet'),
(1464,'Ashurst','Hampshire','England','SU336104',433670,110436,50.89243,-1.52265,20,'SO40 7','New Forest District','South East','Village'),
(1465,'Ashurst','Kent','England','TQ512390',551221,139021,51.13051,0.15981,83,'TN3 9','Tunbridge Wells District','South East','Village'),
(1466,'Ashurst','Lancashire','England','SD487077',348750,407734,53.56370,-2.77524,78,'WN8 6','West Lancashire District','North West','Suburban Area'),
(1467,'Ashurst','West Sussex','England','TQ179160',517954,116096,50.93226,-0.32283,20,'BN44 3','Horsham District','South East','Village'),
(1468,'Ashurst Bridge','Hampshire','England','SU339125',433964,112552,50.91144,-1.51828,12,'SO40 7','New Forest District','South East','Village'),
(1469,'Ashurst Wood','West Sussex','England','TQ419365',541938,136564,51.11080,0.02627,132,'RH19 3','Mid Sussex District','South East','Village'),
(1470,'Ashvale','Gwent','Wales','SO133102',313393,210273,51.78439,-3.25693,335,'NP22 4','Blaenau Gwent','Wales','Suburban Area'),
(1471,'Ash Vale','Surrey','England','SU892533',489224,153365,51.27246,-0.72235,71,'GU12 5','Guildford District','South East','Village'),
(1472,'Ashwater','Devon','England','SX385952',238562,95258,50.73444,-4.28907,171,'EX21 5','Torridge District','South West','Village'),
(1473,'Ashwell','Hertfordshire','England','TL269397',526914,239710,52.04127,-0.15099,53,'SG7 5','North Hertfordshire District','Eastern','Village'),
(1474,'Ashwell','Rutland','England','SK866134',486638,313414,52.71146,-0.71900,108,'LE15 7','Rutland','East Midlands','Village'),
(1475,'Ashwell','Somerset','England','ST362158',336266,115884,50.93886,-2.90845,36,'TA19 9','Somerset','South West','Hamlet'),
(1476,'Ashwell End','Hertfordshire','England','TL252400',525263,240047,52.04467,-0.17493,40,'SG7 5','North Hertfordshire District','Eastern','Hamlet'),
(1477,'Ashwellthorpe','Norfolk','England','TM134976',613422,297682,52.53516,1.14536,55,'NR16 1','South Norfolk District','Eastern','Village'),
(1478,'Ashwick','Somerset','England','ST633478',363361,147893,51.22904,-2.52611,219,'BA3 5','Somerset','South West','Hamlet'),
(1479,'Ashwicken','Norfolk','England','TF691195',569126,319589,52.74746,0.50422,21,'PE32 1','King''s Lynn and West Norfolk District','Eastern','Village'),
(1480,'Ashwood','Staffordshire','England','SO864881',386431,288157,52.49115,-2.20127,70,'DY6 0','South Staffordshire District','West Midlands','Hamlet'),
(1481,'Askam in Furness','Cumbria','England','SD214776',321487,477663,54.18870,-3.20470,13,'LA16 7','Westmorland and Furness','North West','Village'),
(1482,'Aske','North Yorkshire','England','NZ177035',417765,503569,54.42724,-1.72769,169,'DL10 5','North Yorkshire','Yorkshire and the Humber','Hamlet'),
(1483,'Askern','South Yorkshire','England','SE561136',456178,413605,53.61599,-1.15226,12,'DN6 0','Doncaster District','Yorkshire and the Humber','Village'),
(1484,'Askerswell','Dorset','England','SY529927',352909,92777,50.73269,-2.66862,78,'DT2 9','Dorset','South West','Village'),
(1485,'Askerton Hill','Lincolnshire','England','SK805465',480500,346500,53.00977,-0.80167,26,'NG23 5','South Kesteven District','East Midlands','Locality'),
(1486,'Askett','Buckinghamshire','England','SP815051',481588,205188,51.73947,-0.81981,115,'HP27 9','Buckinghamshire','South East','Village'),
(1487,'Askham','Cumbria','England','NY512238',351223,523808,54.60707,-2.75665,207,'CA10 2','Westmorland and Furness','North West','Village'),
(1488,'Askham','Nottinghamshire','England','SK740750',474024,375015,53.26697,-0.89160,55,'NG22 0','Bassetlaw District','East Midlands','Village'),
(1489,'Askham Bryan','North Yorkshire','England','SE553478',455336,447841,53.92376,-1.15886,31,'YO23 3','York','Yorkshire and the Humber','Village'),
(1490,'Askham Richard','North Yorkshire','England','SE535480',453582,448057,53.92588,-1.18552,29,'YO23 3','York','Yorkshire and the Humber','Village'),
(1491,'Asknish','Argyll and Bute','Scotland','NR935915',193500,691500,56.07161,-5.31932,12,'PA31 8','Argyll and Bute','Scotland','Locality'),
(1492,'Askomill','Argyll and Bute','Scotland','NR732208',173248,620841,55.42883,-5.58534,31,'PA28 6','Argyll and Bute','Scotland','Suburban Area'),
(1493,'Askrigg','North Yorkshire','England','SD948910',394817,491025,54.31479,-2.08117,223,'DL8 3','North Yorkshire','Yorkshire and the Humber','Village'),
(1494,'Askwith','North Yorkshire','England','SE169482',416911,448272,53.93030,-1.74394,124,'LS21 2','North Yorkshire','Yorkshire and the Humber','Village'),
(1495,'Aslackby','Lincolnshire','England','TF084303',508461,330374,52.85994,-0.39048,34,'NG34 0','South Kesteven District','East Midlands','Village'),
(1496,'Aslacton','Norfolk','England','TM156910',615675,291092,52.47512,1.17426,47,'NR15 2','South Norfolk District','Eastern','Village'),
(1497,'Aslockton','Nottinghamshire','England','SK741400',474195,340070,52.95289,-0.89710,24,'NG13 9','Rushcliffe District','East Midlands','Village'),
(1498,'Asney','Somerset','England','ST466369',346699,136949,51.12933,-2.76308,11,'BA16 9','Somerset','South West','Hamlet'),
(1499,'Aspall','Suffolk','England','TM166648',616611,264855,52.23924,1.17110,54,'IP14 6','Mid Suffolk District','Eastern','Hamlet'),
(1500,'Aspatria','Cumbria','England','NY143417',314300,541762,54.76345,-3.33342,79,'CA7 3','Cumberland','North West','Town'),
(1501,'Aspenden','Hertfordshire','England','TL361282',536145,228240,51.93602,-0.02103,88,'SG9 9','East Hertfordshire District','Eastern','Village'),
(1502,'Asperton','Lincolnshire','England','TF260377',526042,337775,52.92261,-0.12663,4,'PE20 2','Boston District','East Midlands','Locality'),
(1503,'Aspley','Nottinghamshire','England','SK538417',453855,341710,52.97005,-1.19954,55,'NG8 3','City of Nottingham','East Midlands','Suburban Area'),
(1504,'Aspley','Staffordshire','England','SJ817330',381724,333008,52.89421,-2.27310,130,'ST21 6','Stafford District','West Midlands','Hamlet'),
(1505,'Aspley','West Yorkshire','England','SE149163',414955,416325,53.64323,-1.77526,68,'HD1 3','Kirklees District','Yorkshire and the Humber','Suburban Area'),
(1506,'Aspley Guise','Bedfordshire','England','SP942359',494235,235939,52.01389,-0.62832,103,'MK17 8','Central Bedfordshire','Eastern','Village'),
(1507,'Aspley Heath','Bedfordshire','England','SP926348',492639,234830,52.00419,-0.65187,157,'MK17 8','Central Bedfordshire','Eastern','Village'),
(1508,'Aspley Heath','Warwickshire','England','SP096704',409661,270432,52.33189,-1.85965,167,'B94 5','Stratford-on-Avon District','West Midlands','Village'),
(1509,'Aspull','Greater Manchester','England','SD613081',361330,408159,53.56860,-2.58537,129,'WN2 1','Wigan District','North West','Village'),
(1510,'Aspull Common','Greater Manchester','England','SJ639980',363912,398088,53.47827,-2.54522,31,'WN7 3','Wigan District','North West','Suburban Area'),
(1511,'Assater','Shetland','Scotland','HU297796',429784,1179678,60.49967,-1.45967,50,'ZE2 9','Shetland Islands','Scotland','Hamlet'),
(1512,'Asselby','East Riding of Yorkshire','England','SE718280',471836,428043,53.74383,-0.91226,6,'DN14 7','East Riding of Yorkshire','Yorkshire and the Humber','Village'),
(1513,'Asserby','Lincolnshire','England','TF495776',549530,377689,53.27510,0.24104,4,'LN13 9','East Lindsey District','East Midlands','Hamlet'),
(1514,'Asserby Turn','Lincolnshire','England','TF478775',547875,377503,53.27390,0.21615,8,'LN13 9','East Lindsey District','East Midlands','Hamlet'),
(1515,'Assington','Suffolk','England','TL934381',593409,238101,52.00764,0.81656,60,'CO10 5','Babergh District','Eastern','Village'),
(1516,'Assington Green','Suffolk','England','TL773516',577348,251658,52.13476,0.58986,84,'CO10 8','West Suffolk District','Eastern','Hamlet'),
(1517,'Astbury','Cheshire','England','SJ845615',384559,361570,53.15104,-2.23234,103,'CW12 4','Cheshire East','North West','Village'),
(1518,'Astbury Marsh','Cheshire','England','SJ844622',384418,362276,53.15738,-2.23448,98,'CW12 4','Cheshire East','North West','Suburban Area'),
(1519,'Astcote','Northamptonshire','England','SP676532',467698,253282,52.17365,-1.01147,128,'NN12 8','West Northamptonshire','East Midlands','Village'),
(1520,'Asterby','Lincolnshire','England','TF263786',526385,378601,53.28931,-0.10548,86,'LN9 5','East Lindsey District','East Midlands','Locality'),
(1521,'Asterley','Shropshire','England','SJ374071',337422,307123,52.65820,-2.92659,105,'SY5 0','Shropshire','West Midlands','Village'),
(1522,'Asterton','Shropshire','England','SO397911',339796,291189,52.51525,-2.88860,256,'SY7 8','Shropshire','West Midlands','Hamlet'),
(1523,'Asthall','Oxfordshire','England','SP288113',428875,211325,51.79983,-1.58267,96,'OX18 4','West Oxfordshire District','South East','Hamlet'),
(1524,'Asthall Leigh','Oxfordshire','England','SP307126',430777,212699,51.81208,-1.55497,131,'OX29 9','West Oxfordshire District','South East','Hamlet'),
(1525,'Astle','Sutherland','Scotland','NH745919',274506,891975,57.89948,-4.11898,63,'IV25 3','Highland','Scotland','Hamlet'),
(1526,'Astley','Greater Manchester','England','SD696004',369645,400468,53.50003,-2.45908,25,'M29 7','Wigan District','North West','Village'),
(1527,'Astley','Shropshire','England','SJ529186',352952,318683,52.76369,-2.69868,73,'SY4 4','Shropshire','West Midlands','Village'),
(1528,'Astley','Warwickshire','England','SP310894',431015,289401,52.50163,-1.54454,146,'CV10 7','North Warwickshire District','West Midlands','Hamlet'),
(1529,'Astley','Worcestershire','England','SO792680',379264,268091,52.31053,-2.30557,62,'DY13 0','Malvern Hills District','West Midlands','Village'),
(1530,'Astley Abbotts','Shropshire','England','SO709964',370936,296464,52.56522,-2.43020,94,'WV16 4','Shropshire','West Midlands','Village'),
(1531,'Astley Bridge','Greater Manchester','England','SD715120',371544,412044,53.60418,-2.43151,130,'BL1 7','Bolton District','North West','Suburban Area'),
(1532,'Astley Burf','Worcestershire','England','SO807679',380797,267922,52.30907,-2.28308,47,'DY13 0','Malvern Hills District','West Midlands','Hamlet'),
(1533,'Astley Cross','Worcestershire','England','SO800696',380033,269632,52.32442,-2.29439,37,'DY13 0','Wyre Forest District','West Midlands','Suburban Area'),
(1534,'Astley Green','Greater Manchester','England','SJ702996',370267,399684,53.49301,-2.44962,25,'M29 7','Wigan District','North West','Suburban Area'),
(1535,'Astley Village','Lancashire','England','SD574186',357461,418626,53.66238,-2.64522,75,'PR7 1','Chorley District','North West','Suburban Area'),
(1536,'Astmoor','Cheshire','England','SJ532832',353252,383238,53.34396,-2.70362,14,'WA7 1','Halton','North West','Suburban Area'),
(1537,'Aston','Berkshire','England','SU784841',478429,184199,51.55124,-0.87025,40,'RG9 3','Wokingham','South East','Hamlet'),
(1538,'Aston','Cheshire','England','SJ559782',355973,378266,53.29951,-2.66206,65,'WA7 3','Cheshire West and Chester','North West','Hamlet'),
(1539,'Aston','Cheshire','England','SJ610467',361094,346740,53.01654,-2.58139,71,'CW5 8','Cheshire East','North West','Village'),
(1540,'Aston','Clwyd','Wales','SJ305670',330505,367094,53.19637,-3.04170,49,'CH5 1','Flintshire / Sir y Fflint','Wales','Village'),
(1541,'Aston','Derbyshire','England','SK166319',416667,331920,52.88448,-1.75376,69,'DE6 5','Derbyshire Dales District','East Midlands','Hamlet'),
(1542,'Aston','Derbyshire','England','SK185839',418555,383916,53.35181,-1.72271,233,'S33 6','High Peak District','East Midlands','Hamlet'),
(1543,'Aston','Herefordshire','England','SO459626',345913,262674,52.25956,-2.79385,91,'HR6 9','County of Herefordshire','West Midlands','Hamlet'),
(1544,'Aston','Hertfordshire','England','TL273224',527349,222403,51.88565,-0.15106,103,'SG2 7','East Hertfordshire District','Eastern','Village'),
(1545,'Aston','Oxfordshire','England','SP340030',434071,203012,51.72480,-1.50814,73,'OX18 2','West Oxfordshire District','South East','Village'),
(1546,'Aston','Shropshire','England','SO808934',380865,293438,52.53846,-2.28355,82,'WV5 7','Shropshire','West Midlands','Hamlet'),
(1547,'Aston','Shropshire','England','SJ612096',361238,309688,52.68349,-2.57482,119,'TF6 5','Telford and Wrekin','West Midlands','Hamlet'),
(1548,'Aston','Shropshire','England','SJ533280',353367,328085,52.84824,-2.69387,83,'SY4 5','Shropshire','West Midlands','Village'),
(1549,'Aston','South Yorkshire','England','SK468853',446819,385318,53.36267,-1.29793,107,'S26 2','Rotherham District','Yorkshire and the Humber','Village'),
(1550,'Aston','Staffordshire','England','SJ895236',389558,323662,52.81040,-2.15635,84,'ST18 9','Stafford District','West Midlands','Hamlet'),
(1551,'Aston','Staffordshire','England','SJ754410',375475,341025,52.96602,-2.36659,128,'TF9 4','Newcastle-under-Lyme District','West Midlands','Village'),
(1552,'Aston','West Midlands','England','SP080893',408004,289312,52.50165,-1.88352,120,'B6 5','Birmingham District','West Midlands','Suburban Area'),
(1553,'Aston Abbotts','Buckinghamshire','England','SP847200',484758,220096,51.87301,-0.77027,139,'HP22 4','Buckinghamshire','South East','Village'),
(1554,'Aston Bank','Worcestershire','England','SO621703',362118,270327,52.32972,-2.55731,106,'WR15 8','Malvern Hills District','West Midlands','Hamlet'),
(1555,'Aston Botterell','Shropshire','England','SO632842',363206,284235,52.45482,-2.54288,182,'WV16 6','Shropshire','West Midlands','Hamlet'),
(1556,'Aston-by-Stone','Staffordshire','England','SJ913304',391331,330494,52.87185,-2.13023,100,'ST15 0','Stafford District','West Midlands','Village'),
(1557,'Aston Cantlow','Warwickshire','England','SP138599',413868,259946,52.23753,-1.79834,55,'B95 6','Stratford-on-Avon District','West Midlands','Village'),
(1558,'Aston Clinton','Buckinghamshire','England','SP874122',487437,212232,51.80191,-0.73335,95,'HP22 5','Buckinghamshire','South East','Village'),
(1559,'Aston Crews','Herefordshire','England','SO671232',367125,223295,51.90721,-2.47928,114,'HR9 7','County of Herefordshire','West Midlands','Hamlet'),
(1560,'Aston Cross','Gloucestershire','England','SO941337',394195,233745,52.00211,-2.08597,24,'GL20 8','Tewkesbury District','South West','Village'),
(1561,'Aston End','Hertfordshire','England','TL272242',527291,224221,51.90200,-0.15123,94,'SG2 7','East Hertfordshire District','Eastern','Hamlet'),
(1562,'Aston Eyre','Shropshire','England','SO653940',365359,294075,52.54342,-2.51223,114,'WV16 6','Shropshire','West Midlands','Hamlet'),
(1563,'Aston Fields','Worcestershire','England','SO966694',396664,269408,52.32276,-2.05037,84,'B60 3','Bromsgrove District','West Midlands','Suburban Area'),
(1564,'Aston Flamville','Leicestershire','England','SP462926',446264,292646,52.52973,-1.31946,109,'LE10 3','Blaby District','East Midlands','Village'),
(1565,'Aston Heath','Cheshire','England','SJ562789',356224,378955,53.30572,-2.65839,63,'WA7 3','Cheshire West and Chester','North West','Hamlet'),
(1566,'Aston Heath','Derbyshire','England','SK171327',417198,332742,52.89186,-1.74583,83,'DE6 5','Derbyshire Dales District','East Midlands','Hamlet'),
(1567,'Aston Ingham','Herefordshire','England','SO685236',368545,223660,51.91058,-2.45867,64,'HR9 7','County of Herefordshire','West Midlands','Village'),
(1568,'Aston juxta Mondrum','Cheshire','England','SJ651567',365195,356792,53.10718,-2.52135,50,'CW5 6','Cheshire East','North West','Village'),
(1569,'Aston le Walls','Northamptonshire','England','SP495507',449539,250774,52.15303,-1.27735,145,'NN11 6','West Northamptonshire','East Midlands','Village'),
(1570,'Aston Magna','Gloucestershire','England','SP197356',419765,235696,52.01934,-1.71339,143,'GL56 9','Cotswold District','South West','Village'),
(1571,'Aston Munslow','Shropshire','England','SO510866',351089,286690,52.47594,-2.72154,146,'SY7 9','Shropshire','West Midlands','Village'),
(1572,'Aston New Town','West Midlands','England','SP077887',407707,288707,52.49622,-1.88791,108,'B6 4','Birmingham District','West Midlands','Suburban Area'),
(1573,'Aston on Carrant','Gloucestershire','England','SO941345',394105,234556,52.00940,-2.08730,24,'GL20 8','Tewkesbury District','South West','Village'),
(1574,'Aston on Clun','Shropshire','England','SO392817',339263,281721,52.43008,-2.89472,142,'SY7 8','Shropshire','West Midlands','Village'),
(1575,'Aston-on-Trent','Derbyshire','England','SK414294',441499,329479,52.86121,-1.38506,44,'DE72 2','South Derbyshire District','East Midlands','Village'),
(1576,'Aston Pigott','Shropshire','England','SJ337060',333763,306014,52.64780,-2.98046,130,'SY5 9','Shropshire','West Midlands','Hamlet'),
(1577,'Aston Rogers','Shropshire','England','SJ342064',334266,306425,52.65155,-2.97311,109,'SY5 9','Shropshire','West Midlands','Hamlet'),
(1578,'Aston Rowant','Oxfordshire','England','SU728986',472870,198646,51.68186,-0.94741,118,'OX49 5','South Oxfordshire District','South East','Village'),
(1579,'Aston Sandford','Buckinghamshire','England','SP757078',475702,207807,51.76384,-0.90447,73,'HP17 8','Buckinghamshire','South East','Hamlet'),
(1580,'Aston Somerville','Worcestershire','England','SP046381',404680,238140,52.04164,-1.93318,53,'WR12 7','Wychavon District','West Midlands','Village'),
(1581,'Aston Square','Shropshire','England','SJ325285',332500,328500,52.84975,-3.00376,107,'SY11 4','Shropshire','West Midlands','Locality'),
(1582,'Aston Subedge','Gloucestershire','England','SP138414',413830,241464,52.07137,-1.79964,88,'GL55 6','Cotswold District','South West','Hamlet'),
(1583,'Aston Tirrold','Oxfordshire','England','SU555857',455574,185744,51.56784,-1.19959,58,'OX11 9','South Oxfordshire District','South East','Village'),
(1584,'Aston Upthorpe','Oxfordshire','England','SU555863',455511,186351,51.57330,-1.20040,62,'OX11 9','South Oxfordshire District','South East','Village'),
(1585,'Astrop','Northamptonshire','England','SP504362',450431,236271,52.02257,-1.26645,110,'OX17 3','West Northamptonshire','East Midlands','Suburban Area'),
(1586,'Astrope','Hertfordshire','England','SP894150',489433,215032,51.82676,-0.70369,89,'HP23 4','Dacorum District','Eastern','Hamlet'),
(1587,'Astwick','Bedfordshire','England','TL218385',521809,238576,52.03222,-0.22579,44,'SG5 4','Central Bedfordshire','Eastern','Hamlet'),
(1588,'Astwith','Derbyshire','England','SK437641',443735,364158,53.17274,-1.34717,177,'S45 8','Bolsover District','East Midlands','Hamlet'),
(1589,'Astwood','Buckinghamshire','England','SP952473',495239,247319,52.11600,-0.61052,98,'MK16 9','Milton Keynes','South East','Village'),
(1590,'Astwood','Worcestershire','England','SO933651',393398,265145,52.28440,-2.09820,58,'B60 4','Wychavon District','West Midlands','Hamlet'),
(1591,'Astwood','Worcestershire','England','SO859570',385968,257035,52.21135,-2.20678,31,'WR3 8','Worcester District','West Midlands','Suburban Area'),
(1592,'Astwood Bank','Worcestershire','England','SP043621',404384,262116,52.25720,-1.93719,143,'B96 6','Redditch District','West Midlands','Village'),
(1593,'Aswarby','Lincolnshire','England','TF067399',506760,339946,52.94629,-0.41260,25,'NG34 8','North Kesteven District','East Midlands','Locality'),
(1594,'Aswardby','Lincolnshire','England','TF377703',537703,370383,53.21267,0.06064,44,'PE23 4','East Lindsey District','East Midlands','Locality'),
(1595,'Atcham','Shropshire','England','SJ542093',354201,309316,52.67960,-2.67886,50,'SY5 6','Shropshire','West Midlands','Village'),
(1596,'Atch Lench','Worcestershire','England','SP033507',403387,250788,52.15536,-1.95191,111,'WR11 4','Wychavon District','West Midlands','Village'),
(1597,'Athelhampton','Dorset','England','SY769941',376939,94182,50.74678,-2.32823,58,'DT2 7','Dorset','South West','Hamlet'),
(1598,'Athelington','Suffolk','England','TM210710',621025,271050,52.29309,1.23969,59,'IP21 5','Mid Suffolk District','Eastern','Hamlet'),
(1599,'Athelney','Somerset','England','ST347290',334722,129035,51.05693,-2.93279,8,'TA7 0','Somerset','South West','Hamlet'),
(1600,'Athelstaneford','East Lothian','Scotland','NT535775',353578,677586,55.98898,-2.74568,59,'EH39 5','East Lothian','Scotland','Village'),
(1601,'Atherfield Green','Isle of Wight','England','SZ463795',446384,79571,50.61401,-1.34577,34,'PO38 2','Isle of Wight','South East','Hamlet'),
(1602,'Atherington','Devon','England','SS591229',259129,122999,50.98910,-4.00851,116,'EX37 9','North Devon District','South West','Village'),
(1603,'Atherington','West Sussex','England','TQ002012',500248,101266,50.80229,-0.57876,5,'BN17 5','Arun District','South East','Village'),
(1604,'Athersley North','South Yorkshire','England','SE349094',434948,409432,53.58032,-1.47363,85,'S71 3','Barnsley District','Yorkshire and the Humber','Suburban Area'),
(1605,'Athersley South','South Yorkshire','England','SE352089',435292,408963,53.57608,-1.46848,92,'S71 3','Barnsley District','Yorkshire and the Humber','Suburban Area'),
(1606,'Atherstone','Somerset','England','ST384164',338415,116497,50.94461,-2.87797,34,'TA19 9','Somerset','South West','Hamlet'),
(1607,'Atherstone','Warwickshire','England','SP308978',430834,297808,52.57722,-1.54642,89,'CV9 1','North Warwickshire District','West Midlands','Town'),
(1608,'Atherstone on Stour','Warwickshire','England','SP204509',420487,250987,52.15678,-1.70195,43,'CV37 8','Stratford-on-Avon District','West Midlands','Village'),
(1609,'Atherton','Greater Manchester','England','SD677033',367797,403316,53.52551,-2.48723,63,'M46 9','Wigan District','North West','Town'),
(1610,'Atkinson Hill','West Yorkshire','England','SE314316',431452,431621,53.77997,-1.52419,28,'LS10 2','Leeds District','Yorkshire and the Humber','Suburban Area'),
(1611,'Atlantic Wharf / Glanfa Iwerydd','South Glamorgan','Wales','ST191753',319187,175319,51.47104,-3.16488,11,'CF10 4','Cardiff / Caerdydd','Wales','Suburban Area'),
(1612,'Atlow','Derbyshire','England','SK231488',423106,348886,53.03676,-1.65687,160,'DE6 1','Derbyshire Dales District','East Midlands','Locality'),
(1613,'Atrim','Dorset','England','SY448956',344848,95696,50.75822,-2.78327,22,'DT6 5','Dorset','South West','Hamlet'),
(1614,'Attadale','Ross and Cromarty','Scotland','NG928389',192850,838929,57.39346,-5.44887,17,'IV54 8','Highland','Scotland','Hamlet'),
(1615,'Attenborough','Nottinghamshire','England','SK517346',451746,334670,52.90698,-1.23206,32,'NG9 6','Broxtowe District','East Midlands','Suburban Area'),
(1616,'Atterbury','Buckinghamshire','England','SP891396',489186,239683,52.04837,-0.70089,65,'MK10 9','Milton Keynes','South East','Suburban Area'),
(1617,'Atterby','Lincolnshire','England','SK981929',498150,392990,53.42458,-0.52442,28,'LN8 2','West Lindsey District','East Midlands','Hamlet'),
(1618,'Attercliffe','South Yorkshire','England','SK377885',437722,388515,53.39213,-1.43424,54,'S9 3','Sheffield District','Yorkshire and the Humber','Suburban Area'),
(1619,'Attercliffe Hill Top','South Yorkshire','England','SK386894',438624,389401,53.40003,-1.42057,51,'S9 2','Sheffield District','Yorkshire and the Humber','Suburban Area'),
(1620,'Atterley','Shropshire','England','SO640975',364084,297501,52.57413,-2.53140,143,'TF13 6','Shropshire','West Midlands','Hamlet'),
(1621,'Atterton','Leicestershire','England','SP353983',435305,298329,52.58163,-1.48039,86,'CV13 6','Hinckley and Bosworth District','East Midlands','Hamlet'),
(1622,'Atticall','County Down','Northern Ireland','J279195',327976,319531,54.10900,-6.04400,131,'BT34 4','Newry Mourne and Down','Northern Ireland','Locality'),
(1623,'Attleborough','Norfolk','England','TM046952',604640,295221,52.51644,1.01456,40,'NR17 2','Breckland District','Eastern','Town'),
(1624,'Attleborough','Warwickshire','England','SP370909',437095,290905,52.51478,-1.45481,91,'CV11 4','Nuneaton and Bedworth District','West Midlands','Suburban Area'),
(1625,'Attlebridge','Norfolk','England','TG129168',612975,316827,52.70719,1.15111,14,'NR9 5','Broadland District','Eastern','Village'),
(1626,'Attleton Green','Suffolk','England','TL738549',573868,254913,52.16510,0.54073,94,'CB8 8','West Suffolk District','Eastern','Hamlet'),
(1627,'Atwick','East Riding of Yorkshire','England','TA190508',519050,450825,53.93985,-0.18788,14,'YO25 8','East Riding of Yorkshire','Yorkshire and the Humber','Village'),
(1628,'Atworth','Wiltshire','England','ST863659',386395,165974,51.39264,-2.19692,71,'SN12 8','Wiltshire','South West','Village'),
(1629,'Auberrow','Herefordshire','England','SO491473',349164,247334,52.12197,-2.74392,62,'HR4 8','County of Herefordshire','West Midlands','Hamlet'),
(1630,'Aubourn','Lincolnshire','England','SK919624',491994,362499,53.15169,-0.62585,15,'LN5 9','North Kesteven District','East Midlands','Village'),
(1631,'Auchagallon','Ayrshire and Arran','Scotland','NR892345',189223,634538,55.55883,-5.34376,7,'KA27 8','North Ayrshire','Scotland','Hamlet'),
(1632,'Aucharnie','Aberdeenshire','Scotland','NJ636412',363600,841294,57.46046,-2.60835,136,'AB54 6','Aberdeenshire','Scotland','Locality'),
(1633,'Auchattie','Kincardineshire','Scotland','NO693946',369357,794654,57.04194,-2.50662,95,'AB31 6','Aberdeenshire','Scotland','Hamlet'),
(1634,'Auchbreck','Banffshire','Scotland','NJ209286',320977,828600,57.34104,-3.31452,256,'AB37 9','Moray','Scotland','Hamlet'),
(1635,'Auchenback','Renfrewshire','Scotland','NS510579',251083,657954,55.79187,-4.37672,96,'G78 2','East Renfrewshire','Scotland','Suburban Area'),
(1636,'Auchenbainzie','Dumfries','Scotland','NX825975',282500,597500,55.25762,-3.85031,227,'DG3 4','Dumfries and Galloway','Scotland','Locality'),
(1637,'Auchenblae','Kincardineshire','Scotland','NO726787',372678,778791,56.89966,-2.45017,106,'AB30 1','Aberdeenshire','Scotland','Village'),
(1638,'Auchenbowie','Stirling and Falkirk','Scotland','NS792879',279261,687942,56.06902,-3.94104,82,'FK7 8','Stirling','Scotland','Locality'),
(1639,'Auchencairn','Ayrshire and Arran','Scotland','NS042278',204200,627814,55.50474,-5.10192,58,'KA27 8','North Ayrshire','Scotland','Suburban Area'),
(1640,'Auchencairn','Dumfries','Scotland','NX979847',297940,584786,55.14686,-3.60289,91,'DG1 1','Dumfries and Galloway','Scotland','Hamlet'),
(1641,'Auchencairn','The Stewartry of Kirkcudbright','Scotland','NX798514',279846,551417,54.84310,-3.87262,24,'DG7 1','Dumfries and Galloway','Scotland','Village'),
(1642,'Auchencar','Ayrshire and Arran','Scotland','NR891364',189199,636451,55.57598,-5.34560,28,'KA27 8','North Ayrshire','Scotland','Hamlet'),
(1643,'Auchencrow','Berwickshire','Scotland','NT853606',385341,660663,55.83896,-2.23563,101,'TD14 5','Scottish Borders','Scotland','Village'),
(1644,'Auchendinny','Midlothian','Scotland','NT253618',325343,661824,55.84383,-3.19381,150,'EH26 0','Midlothian','Scotland','Village'),
(1645,'Auchendryne','Aberdeenshire','Scotland','NO146913',314629,791369,57.00555,-3.40719,344,'AB35 5','Aberdeenshire','Scotland','Suburban Area'),
(1646,'Auchengray','Lanarkshire','Scotland','NS996542',299601,654256,55.77118,-3.60194,272,'ML11 8','South Lanarkshire','Scotland','Hamlet'),
(1647,'Auchenhalrig','Moray','Scotland','NJ372618',337232,861881,57.64246,-3.05309,45,'IV32 7','Moray','Scotland','Hamlet'),
(1648,'Auchenharvie','Ayrshire and Arran','Scotland','NS257416',225769,641605,55.63669,-4.76957,6,'KA20 3','North Ayrshire','Scotland','Suburban Area'),
(1649,'Auchenheath','Lanarkshire','Scotland','NS809436',280904,643654,55.67173,-3.89519,166,'ML11 9','South Lanarkshire','Scotland','Village'),
(1650,'Auchenhew','Ayrshire and Arran','Scotland','NS018211',201899,621132,55.44387,-5.13353,6,'KA27 8','North Ayrshire','Scotland','Locality'),
(1651,'Auchenlochan','Argyll and Bute','Scotland','NR975725',197500,672500,55.90289,-5.24087,18,'PA21 2','Argyll and Bute','Scotland','Locality'),
(1652,'Auchenmalg','Wigtown','Scotland','NX233522',223312,552220,54.83355,-4.75253,14,'DG8 0','Dumfries and Galloway','Scotland','Hamlet'),
(1653,'Auchenreoch','Dunbartonshire','Scotland','NS674765',267457,676588,55.96395,-4.12490,54,'G66 8','East Dunbartonshire','Scotland','Locality'),
(1654,'Auchentibber','Lanarkshire','Scotland','NS665545',266500,654500,55.76537,-4.12934,189,'G72 0','South Lanarkshire','Scotland','Locality'),
(1655,'Auchentiber','Ayrshire and Arran','Scotland','NS364471',236423,647160,55.69025,-4.60382,83,'KA13 7','North Ayrshire','Scotland','Hamlet'),
(1656,'Auchinairn','Dunbartonshire','Scotland','NS618693',261876,669371,55.89758,-4.21054,91,'G64 1','East Dunbartonshire','Scotland','Suburban Area'),
(1657,'Auchincloch','Stirling and Falkirk','Scotland','NS764788',276423,678897,55.98708,-3.98243,66,'FK4 1','Falkirk','Scotland','Hamlet'),
(1658,'Auchinderran','Banffshire','Scotland','NJ405555',340500,855500,57.58560,-2.99679,227,'AB55 6','Moray','Scotland','Locality'),
(1659,'Auchindrain','Argyll and Bute','Scotland','NN035035',203500,703500,56.18347,-5.16778,108,'PA32 8','Argyll and Bute','Scotland','Locality'),
(1660,'Auchindrean','Ross and Cromarty','Scotland','NH191805',219112,880506,57.77760,-5.04360,36,'IV23 2','Highland','Scotland','Hamlet'),
(1661,'Auchingoul','Banffshire','Scotland','NJ610486',361067,848688,57.52666,-2.65175,65,'AB54 7','Aberdeenshire','Scotland','Locality'),
(1662,'Auchininna','Banffshire','Scotland','NJ649468',364994,846820,57.51021,-2.58591,86,'AB53 4','Aberdeenshire','Scotland','Hamlet'),
(1663,'Auchinleck','Ayrshire and Arran','Scotland','NS548221',254885,622186,55.47191,-4.29726,158,'KA18 2','East Ayrshire','Scotland','Village'),
(1664,'Auchinleish','Angus','Scotland','NO195605',319500,760500,56.72919,-3.31723,298,'PH11 8','Angus','Scotland','Locality'),
(1665,'Auchinloch','Lanarkshire','Scotland','NS657705',265730,670518,55.90897,-4.14953,76,'G66 5','North Lanarkshire','Scotland','Village'),
(1666,'Auchinraith','Lanarkshire','Scotland','NS695565',269500,656500,55.78414,-4.08252,60,'G72 0','South Lanarkshire','Scotland','Locality'),
(1667,'Auchinstarry','Dunbartonshire','Scotland','NS720767',272036,676765,55.96678,-4.05169,55,'G65 9','North Lanarkshire','Scotland','Hamlet'),
(1668,'Auchintoul','Sutherland','Scotland','NH513999',251342,899929,57.96374,-4.51439,119,'IV27 4','Highland','Scotland','Hamlet'),
(1669,'Auchleven','Aberdeenshire','Scotland','NJ624245',362409,824547,57.30994,-2.62563,160,'AB52 6','Aberdeenshire','Scotland','Village'),
(1670,'Auchlochan','Lanarkshire','Scotland','NS810373',281070,637396,55.61557,-3.88984,215,'ML11 0','South Lanarkshire','Scotland','Village'),
(1671,'Auchlunies','Kincardineshire','Scotland','NO891998',389140,799873,57.08972,-2.18083,109,'AB12 5','Aberdeenshire','Scotland','Hamlet'),
(1672,'Auchlyne','Stirling and Falkirk','Scotland','NN512294',251208,729491,56.43408,-4.41464,154,'FK21 8','Stirling','Scotland','Hamlet'),
(1673,'Auchmaliddie','Aberdeenshire','Scotland','NJ883447',388306,844799,57.49326,-2.19674,143,'AB42 5','Aberdeenshire','Scotland','Locality'),
(1674,'Auchmillan','Ayrshire and Arran','Scotland','NS515295',251500,629500,55.53656,-4.35468,145,'KA5 6','East Ayrshire','Scotland','Locality'),
(1675,'Auchmithie','Angus','Scotland','NO677441',367773,744196,56.58857,-2.52632,44,'DD11 5','Angus','Scotland','Village'),
(1676,'Auchmuirbridge','Perth and Kinross','Scotland','NO216012',321693,701293,56.19778,-3.26361,123,'KY6 3','Perth and Kinross','Scotland','Hamlet'),
(1677,'Auchmuty','Fife','Scotland','NO277008',327738,700859,56.19484,-3.16609,84,'KY7 5','Fife','Scotland','Suburban Area'),
(1678,'Auchnacree','Angus','Scotland','NO465635',346500,763500,56.76002,-2.87667,207,'DD8 3','Angus','Scotland','Locality'),
(1679,'Auchnafree','Perth and Kinross','Scotland','NN819333',281916,733321,56.47715,-3.91872,290,'PH8 0','Perth and Kinross','Scotland','Locality'),
(1680,'Auchnagatt','Aberdeenshire','Scotland','NJ932418',393217,841887,57.46720,-2.11473,78,'AB41 8','Aberdeenshire','Scotland','Village'),
(1681,'Auchnahillin','Inverness','Scotland','NH740384',274068,838497,57.41933,-4.09845,246,'IV2 5','Highland','Scotland','Hamlet'),
(1682,'Auchnarrow','Banffshire','Scotland','NJ212235',321218,823575,57.29595,-3.30891,329,'AB37 9','Moray','Scotland','Hamlet'),
(1683,'Auchterarder','Perth and Kinross','Scotland','NN944128',294495,712858,56.29638,-3.70637,108,'PH3 1','Perth and Kinross','Scotland','Town'),
(1684,'Auchteraw','Inverness','Scotland','NH352082',235204,808242,57.13543,-4.72466,61,'PH32 4','Highland','Scotland','Locality'),
(1685,'Auchtercairn','Ross and Cromarty','Scotland','NG802769',180269,876946,57.72834,-5.69213,13,'IV21 2','Highland','Scotland','Suburban Area'),
(1686,'Auchterderran','Fife','Scotland','NT213960',321395,696015,56.15032,-3.26685,88,'KY5 0','Fife','Scotland','Village'),
(1687,'Auchterhouse','Angus','Scotland','NO332375',333231,737520,56.52495,-3.08692,149,'DD3 0','Angus','Scotland','Village'),
(1688,'Auchtermuchty','Fife','Scotland','NO237117',323788,711753,56.29207,-3.23287,63,'KY14 7','Fife','Scotland','Town'),
(1689,'Auchtertool','Fife','Scotland','NT217907',321702,690715,56.10277,-3.26035,103,'KY2 5','Fife','Scotland','Village'),
(1690,'Auchtertyre','Ross and Cromarty','Scotland','NG839274',183988,827465,57.28656,-5.58598,14,'IV40 8','Highland','Scotland','Hamlet'),
(1691,'Auchtertyre','Stirling and Falkirk','Scotland','NN354290',235418,729024,56.42464,-4.67012,180,'FK20 8','Stirling','Scotland','Locality'),
(1692,'Auchtubh','Stirling and Falkirk','Scotland','NN554206',255464,720695,56.35644,-4.34083,152,'FK19 8','Stirling','Scotland','Hamlet'),
(1693,'Auckengill','Caithness','Scotland','ND366649',336696,964994,58.56835,-3.08997,32,'KW1 4','Highland','Scotland','Locality'),
(1694,'Auckley','South Yorkshire','England','SE649011',464991,401178,53.50329,-1.02163,8,'DN9 3','Doncaster District','Yorkshire and the Humber','Village'),
(1695,'Audenshaw','Greater Manchester','England','SJ918972',391834,397271,53.47211,-2.12449,102,'M34 5','Tameside District','North West','Locality'),
(1696,'Audlem','Cheshire','England','SJ659436',365999,343623,52.98885,-2.50795,64,'CW3 0','Cheshire East','North West','Village'),
(1697,'Audley','Staffordshire','England','SJ798507',379863,350764,53.05375,-2.30187,142,'ST7 8','Newcastle-under-Lyme District','West Midlands','Village'),
(1698,'Audley End','Essex','England','TL812375',581272,237583,52.00708,0.63966,76,'CO9 3','Braintree District','Eastern','Hamlet'),
(1699,'Audley End','Essex','England','TL520380',552054,238076,52.02027,0.21456,61,'CB11 4','Uttlesford District','Eastern','Hamlet'),
(1700,'Audley End','Suffolk','England','TL855535',585508,253577,52.14931,0.70999,86,'IP29 4','Babergh District','Eastern','Hamlet'),
(1701,'Aughafatten','County Antrim','Northern Ireland','D231092',323106,409283,54.91600,-6.08100,151,'BT42 4','Mid and East Antrim','Northern Ireland','Locality'),
(1702,'Augher','County Tyrone','Northern Ireland','H552541',255209,354160,54.43300,-7.15000,60,'BT77 0','Mid Ulster','Northern Ireland','Locality'),
(1703,'Aughertree','Cumbria','England','NY255384',325560,538425,54.73526,-3.15761,202,'CA7 1','Cumberland','North West','Hamlet'),
(1704,'Aughnacloy','County Tyrone','Northern Ireland','H666521',266612,352142,54.41351,-6.97477,60,'BT69 6','Mid Ulster','Northern Ireland','Locality'),
(1705,'Aughton','East Riding of Yorkshire','England','SE704386',470497,438656,53.83938,-0.93014,11,'YO42 4','East Riding of Yorkshire','Yorkshire and the Humber','Village'),
(1706,'Aughton','Lancashire','England','SD548675',354876,467548,54.10183,-2.69156,117,'LA2 8','Lancaster District','North West','Locality'),
(1707,'Aughton','Lancashire','England','SD392052',339233,405208,53.53998,-2.91841,27,'L39 6','West Lancashire District','North West','Village'),
(1708,'Aughton','South Yorkshire','England','SK454864',445443,386452,53.37298,-1.31844,98,'S26 3','Rotherham District','Yorkshire and the Humber','Village'),
(1709,'Aughton','Wiltshire','England','SU239563',423912,156365,51.30591,-1.65836,141,'SN8 3','Wiltshire','South West','Village'),
(1710,'Aughton Park','Lancashire','England','SD409066',340980,406678,53.55340,-2.89233,65,'L39 4','West Lancashire District','North West','Suburban Area'),
(1711,'Aukside','Durham','England','NY942267',394281,526761,54.63594,-2.09012,329,'DL12 0','County Durham','North East','Hamlet'),
(1712,'Auldearn','Nairn','Scotland','NH919554',291982,855436,57.57602,-3.80786,31,'IV12 5','Highland','Scotland','Village'),
(1713,'Aulden','Herefordshire','England','SO462548',346252,254847,52.18923,-2.78764,91,'HR6 0','County of Herefordshire','West Midlands','Hamlet'),
(1714,'Auldgirth','Dumfries','Scotland','NX913864',291317,586488,55.16074,-3.70741,30,'DG2 0','Dumfries and Galloway','Scotland','Village'),
(1715,'Auldhouse','City of Glasgow','Scotland','NS564606',256442,660666,55.81784,-4.29276,27,'G43 2','Glasgow City','Scotland','Suburban Area'),
(1716,'Auldhouse','Lanarkshire','Scotland','NS624502',262413,650260,55.72615,-4.19229,215,'G75 9','South Lanarkshire','Scotland','Hamlet'),
(1717,'Auldyoch','Aberdeenshire','Scotland','NJ685415',368500,841500,57.46268,-2.52671,142,'AB53 8','Aberdeenshire','Scotland','Locality'),
(1718,'Aultbea','Ross and Cromarty','Scotland','NG875889',187563,888916,57.83915,-5.58052,13,'IV22 2','Highland','Scotland','Village'),
(1719,'Aultgrishan','Ross and Cromarty','Scotland','NG742856',174275,885631,57.80321,-5.80073,31,'IV21 2','Highland','Scotland','Locality'),
(1720,'Ault Hucknall','Derbyshire','England','SK466652',446684,365206,53.18191,-1.30290,173,'S44 5','Bolsover District','East Midlands','Hamlet'),
(1721,'Aultiphurst','Sutherland','Scotland','NC804657',280453,965773,58.56351,-4.05671,55,'KW14 7','Highland','Scotland','Locality'),
(1722,'Aultivullin','Sutherland','Scotland','NC816679',281637,967910,58.58301,-4.03749,66,'KW14 7','Highland','Scotland','Hamlet'),
(1723,'Aultmore','Banffshire','Scotland','NJ403531',340313,853131,57.56430,-2.99933,161,'AB55 6','Moray','Scotland','Hamlet'),
(1724,'Ault-na-goire','Inverness','Scotland','NH543227',254380,822725,57.27190,-4.41663,188,'IV2 6','Highland','Scotland','Hamlet'),
(1725,'Aultvaich','Ross and Cromarty','Scotland','NH510484',251073,848418,57.50141,-4.48699,108,'IV4 7','Highland','Scotland','Hamlet'),
(1726,'Aultvoulin','Inverness','Scotland','NG759004',175947,800407,57.04014,-5.69479,10,'PH41 4','Highland','Scotland','Locality'),
(1727,'Aunby','Lincolnshire','England','TF026144',502682,314484,52.71828,-0.48127,39,'PE9 4','South Kesteven District','East Midlands','Hamlet'),
(1728,'Aunk','Devon','England','ST048003',304875,100314,50.79456,-3.35104,44,'EX15 2','East Devon District','South West','Hamlet'),
(1729,'Aunsby','Lincolnshire','England','TF043388',504392,338831,52.93674,-0.44818,54,'NG34 8','North Kesteven District','East Midlands','Village'),
(1730,'Aust','Gloucestershire','England','ST573890',357395,189028,51.59847,-2.61650,8,'BS35 4','South Gloucestershire','South West','Village'),
(1731,'Austendike','Lincolnshire','England','TF299217',529955,321764,52.77783,-0.07484,4,'PE12 6','South Holland District','East Midlands','Hamlet'),
(1732,'Austen Fen','Lincolnshire','England','TF375945',537500,394500,53.42937,0.06805,2,'LN11 0','East Lindsey District','East Midlands','Locality'),
(1733,'Austenwood','Buckinghamshire','England','SU995895',499500,189500,51.59557,-0.56494,89,'SL9 8','Buckinghamshire','South East','Locality'),
(1734,'Austerfield','South Yorkshire','England','SK660945',466093,394573,53.44379,-1.00641,13,'DN10 6','Doncaster District','Yorkshire and the Humber','Village'),
(1735,'Austerlands','Greater Manchester','England','SD964054',396482,405490,53.54604,-2.05456,268,'OL4 4','Oldham District','North West','Suburban Area'),
(1736,'Austhorpe','West Yorkshire','England','SE369337',436963,433791,53.79912,-1.44030,90,'LS15 8','Leeds District','Yorkshire and the Humber','Suburban Area'),
(1737,'Austrey','Warwickshire','England','SK296062',429673,306222,52.65292,-1.56280,90,'CV9 3','North Warwickshire District','West Midlands','Village'),
(1738,'Austwick','North Yorkshire','England','SD767684',376741,468499,54.11184,-2.35727,154,'LA2 8','North Yorkshire','Yorkshire and the Humber','Village'),
(1739,'Authorpe','Lincolnshire','England','TF400809',540014,380920,53.30672,0.09986,25,'LN11 8','East Lindsey District','East Midlands','Village'),
(1740,'Authorpe Row','Lincolnshire','England','TF537733',553752,373362,53.23503,0.30221,4,'PE24 5','East Lindsey District','East Midlands','Hamlet'),
(1741,'Avebury','Wiltshire','England','SU101699',410168,169939,51.42837,-1.85514,159,'SN8 1','Wiltshire','South West','Village'),
(1742,'Avebury Trusloe','Wiltshire','England','SU094695',409483,169587,51.42521,-1.86500,161,'SN8 1','Wiltshire','South West','Village'),
(1743,'Aveley','Essex','England','TQ563802',556396,180221,51.49930,0.25177,30,'RM15 4','Thurrock','Eastern','Village'),
(1744,'Avenham','Lancashire','England','SD541290',354132,429036,53.75565,-2.69714,38,'PR1 3','Preston District','North West','Suburban Area'),
(1745,'Avening','Gloucestershire','England','ST884979',388414,197943,51.68013,-2.16897,117,'GL8 8','Cotswold District','South West','Village'),
(1746,'Avening Green','Gloucestershire','England','ST708939',370897,193901,51.64315,-2.42198,32,'GL12 8','South Gloucestershire','South West','Hamlet'),
(1747,'Averham','Nottinghamshire','England','SK763544',476366,354469,53.08199,-0.86139,15,'NG23 5','Newark and Sherwood District','East Midlands','Village'),
(1748,'Averham Park','Nottinghamshire','England','SK744565',474465,356513,53.10063,-0.88929,57,'NG23 5','Newark and Sherwood District','East Midlands','Hamlet'),
(1749,'Avernish','Ross and Cromarty','Scotland','NG851265',185170,826512,57.27857,-5.56558,11,'IV40 8','Highland','Scotland','Locality'),
(1750,'Avery Hill','Greater London','England','TQ446744',544668,174417,51.45026,0.08056,47,'SE9 2','Greenwich','London','Suburban Area'),
(1751,'Aveton Gifford','Devon','England','SX692472',269290,47278,50.31092,-3.83707,4,'TQ7 4','South Hams District','South West','Village'),
(1752,'Avielochan','Inverness','Scotland','NH904166',290434,816609,57.22706,-3.81640,242,'PH22 1','Highland','Scotland','Hamlet'),
(1753,'Aviemore','Inverness','Scotland','NH895126',289568,812693,57.19169,-3.82899,216,'PH22 1','Highland','Scotland','Town'),
(1754,'Avington','Berkshire','England','SU370681',437027,168110,51.41081,-1.46901,97,'RG17 0','West Berkshire','South East','Hamlet'),
(1755,'Avington','Hampshire','England','SU530319',453087,131961,51.08452,-1.24346,65,'SO21 1','Winchester District','South East','Village'),
(1756,'Avisford','West Sussex','England','SU977064',497703,106414,50.84901,-0.61350,26,'BN18 0','Arun District','South East','Hamlet'),
(1757,'Avoch','Ross and Cromarty','Scotland','NH701551',270167,855114,57.56739,-4.17219,10,'IV9 8','Highland','Scotland','Village'),
(1758,'Avon','Hampshire','England','SZ146988',414662,98808,50.78866,-1.79337,9,'BH23 7','New Forest District','South East','Village'),
(1759,'Avon','Wiltshire','England','ST959766',395908,176629,51.48859,-2.06033,53,'SN15 4','Wiltshire','South West','Hamlet'),
(1760,'Avonbridge','Stirling and Falkirk','Scotland','NS910725',291095,672570,55.93381,-3.74482,142,'FK1 2','Falkirk','Scotland','Village'),
(1761,'Avon Castle','Dorset','England','SU137036',413749,103602,50.83179,-1.80614,34,'BH24 2','Dorset','South West','Locality'),
(1762,'Avoncliff','Wiltshire','England','ST805598',380529,159889,51.33775,-2.28090,56,'BA15 2','Wiltshire','South West','Hamlet'),
(1763,'Avon Common','Dorset','England','SZ128986',412890,98623,50.78704,-1.81851,16,'BH23 6','Bournemouth, Christchurch and Poole','South West','Hamlet'),
(1764,'Avon Dassett','Warwickshire','England','SP409499',440984,249962,52.14643,-1.40248,150,'CV47 2','Stratford-on-Avon District','West Midlands','Village'),
(1765,'Avonmouth','Bristol','England','ST515782',351584,178209,51.50073,-2.69890,9,'BS11 9','City of Bristol','South West','Locality'),
(1766,'Avonwick','Devon','England','SX712582',271210,58220,50.40969,-3.81387,86,'TQ10 9','South Hams District','South West','Village'),
(1767,'Awbridge','Hampshire','England','SU327239',432710,123939,51.01391,-1.53509,61,'SO51 0','Test Valley District','South East','Village'),
(1768,'Awkley','Gloucestershire','England','ST594857',359416,185775,51.56938,-2.58695,6,'BS32 4','South Gloucestershire','South West','Hamlet'),
(1769,'Awliscombe','Devon','England','ST135016',313553,101647,50.80790,-3.22826,112,'EX14 3','East Devon District','South West','Village'),
(1770,'Awre','Gloucestershire','England','SO704083',370449,208331,51.77286,-2.42968,25,'GL14 1','Forest of Dean District','South West','Village'),
(1771,'Awsworth','Nottinghamshire','England','SK482442',448245,344270,52.99359,-1.28268,77,'NG16 2','Broxtowe District','East Midlands','Village'),
(1772,'Axbridge','Somerset','England','ST430545',343094,154550,51.28723,-2.81739,21,'BS26 2','Somerset','South West','Town'),
(1773,'Axeford Estate','Somerset','England','ST339050',333978,105085,50.84151,-2.93905,62,'TA20 4','Somerset','South West','Suburban Area'),
(1774,'Axford','Hampshire','England','SU609433',460968,143392,51.18651,-1.12903,115,'RG25 2','Basingstoke and Deane District','South East','Village'),
(1775,'Axford','Wiltshire','England','SU235700',423528,170016,51.42866,-1.66297,128,'SN8 2','Wiltshire','South West','Village'),
(1776,'Axmansford','Hampshire','England','SU574612',457451,161246,51.34740,-1.17648,95,'RG26 5','Basingstoke and Deane District','South East','Hamlet'),
(1777,'Axminster','Devon','England','SY296985',329639,98535,50.78210,-2.99941,41,'EX13 5','East Devon District','South West','Town'),
(1778,'Axmouth','Devon','England','SY258910',325896,91054,50.71437,-3.05098,12,'EX12 4','East Devon District','South West','Village'),
(1779,'Axton','Clwyd','Wales','SJ109800',310963,380024,53.30964,-3.33776,197,'CH8 9','Flintshire / Sir y Fflint','Wales','Village'),
(1780,'Axtown','Devon','England','SX513672',251314,67291,50.48652,-4.09729,192,'PL20 6','West Devon District','South West','Suburban Area'),
(1781,'Axwell Park','Tyne and Wear','England','NZ195615',419500,561500,54.94778,-1.69710,23,'NE21 6','Gateshead District','North East','Locality'),
(1782,'Aycliff','Kent','England','TR305405',630500,140500,51.11740,1.29212,37,'CT17 9','Dover District','South East','Locality'),
(1783,'Aycliffe','Kent','England','TR307400',630751,140099,51.11370,1.29545,37,'CT17 9','Dover District','South East','Suburban Area'),
(1784,'Aycliffe Village','Durham','England','NZ284227',428412,522740,54.59904,-1.56175,81,'DL5 6','County Durham','North East','Suburban Area'),
(1785,'Aydon','Northumberland','England','NZ008660',400806,566000,54.98859,-1.98894,146,'NE45 5','Northumberland','North East','Hamlet'),
(1786,'Aydon Road Estate','Northumberland','England','NY994646',399439,564664,54.97659,-2.01030,43,'NE45 5','Northumberland','North East','Locality'),
(1787,'Aykley Heads','Durham','England','NZ265435',426500,543500,54.78571,-1.58946,93,'DH1 5','County Durham','North East','Locality'),
(1788,'Aylburton','Gloucestershire','England','SO617017',361735,201793,51.71355,-2.55525,19,'GL15 6','Forest of Dean District','South West','Village'),
(1789,'Aylburton Common','Gloucestershire','England','SO605025',360500,202500,51.71982,-2.57320,90,'GL15 6','Forest of Dean District','South West','Locality'),
(1790,'Ayle','Northumberland','England','NY718495',371886,549554,54.84001,-2.43927,342,'CA9 3','Northumberland','North East','Hamlet'),
(1791,'Ayleford','Gloucestershire','England','SO662089',366228,208929,51.77800,-2.49091,99,'GL15 4','Forest of Dean District','South West','Village'),
(1792,'Aylesbeare','Devon','England','SY038917',303888,91746,50.71737,-3.36281,94,'EX5 2','East Devon District','South West','Village'),
(1793,'Aylesbury','Buckinghamshire','England','SP820138',482079,213833,51.81711,-0.81066,92,'HP20 1','Buckinghamshire','South East','Town'),
(1794,'Aylesby','Lincolnshire','England','TA202076',520265,407647,53.55169,-0.18616,19,'DN37 7','North East Lincolnshire','Yorkshire and the Humber','Village'),
(1795,'Aylesford','Kent','England','TQ730589',573084,158979,51.30362,0.48160,6,'ME20 7','Tonbridge and Malling District','South East','Village'),
(1796,'Aylesham','Kent','England','TR235521',623589,152195,51.22513,1.20081,77,'CT3 3','Dover District','South East','Village'),
(1797,'Aylestone','Leicestershire','England','SK574007',457435,300739,52.60141,-1.15341,70,'LE2 8','City of Leicester','East Midlands','Suburban Area'),
(1798,'Aylestone Hill','Herefordshire','England','SO520409',352019,240952,52.06485,-2.70132,87,'HR1 1','County of Herefordshire','West Midlands','Suburban Area'),
(1799,'Aylestone Park','Leicestershire','England','SK581011',458130,301136,52.60491,-1.14308,76,'LE2 8','City of Leicester','East Midlands','Suburban Area'),
(1800,'Aylmerton','Norfolk','England','TG184408',618461,340864,52.92074,1.24823,101,'NR11 8','North Norfolk District','Eastern','Village'),
(1801,'Aylsham','Norfolk','England','TG192268',619284,326893,52.79501,1.25106,35,'NR11 6','Broadland District','Eastern','Town'),
(1802,'Aylton','Herefordshire','England','SO658377',365883,237743,52.03703,-2.49878,71,'HR8 2','County of Herefordshire','West Midlands','Hamlet'),
(1803,'Aylworth','Gloucestershire','England','SP109221',410956,222110,51.89743,-1.84218,179,'GL54 3','Cotswold District','South West','Hamlet'),
(1804,'Aymestrey','Herefordshire','England','SO426651',342606,265108,52.28110,-2.84271,107,'HR6 9','County of Herefordshire','West Midlands','Hamlet'),
(1805,'Aynho','Northamptonshire','England','SP515335',451513,233529,51.99782,-1.25110,146,'OX17 3','West Northamptonshire','East Midlands','Village'),
(1806,'Ayot Green','Hertfordshire','England','TL217143',521768,214306,51.81413,-0.23496,125,'AL6 9','Welwyn Hatfield District','Eastern','Village'),
(1807,'Ayot St Lawrence','Hertfordshire','England','TL194166',519417,216686,51.83603,-0.26823,125,'AL6 9','Welwyn Hatfield District','Eastern','Village'),
(1808,'Ayot St Peter','Hertfordshire','England','TL218150',521857,215041,51.82072,-0.23341,130,'AL6 9','Welwyn Hatfield District','Eastern','Hamlet'),
(1809,'Ayr','Ayrshire and Arran','Scotland','NS338214',233861,621409,55.45824,-4.62903,14,'KA7 2','South Ayrshire','Scotland','Town'),
(1810,'Ayres End','Hertfordshire','England','TL156122',515627,212265,51.79709,-0.32468,117,'AL5 1','St. Albans District','Eastern','Hamlet'),
(1811,'Ayres of Selivoe','Shetland','Scotland','HU286486',428617,1148617,60.22088,-1.48532,59,'ZE2 9','Shetland Islands','Scotland','Hamlet'),
(1812,'Ayre''s Quay','Tyne and Wear','England','NZ388575',438823,557550,54.91116,-1.39597,31,'SR4 6','Sunderland District','North East','Suburban Area'),
(1813,'Aysgarth','North Yorkshire','England','SE001884',400133,488405,54.29127,-1.99946,229,'DL8 3','North Yorkshire','Yorkshire and the Humber','Village'),
(1814,'Ayshford','Devon','England','ST048151',304834,115144,50.92787,-3.35549,93,'EX16 7','Mid Devon District','South West','Hamlet'),
(1815,'Ayside','Cumbria','England','SD392836',339296,483617,54.24463,-2.93303,90,'LA11 6','Westmorland and Furness','North West','Village'),
(1816,'Ayston','Rutland','England','SK861009',486120,300909,52.59916,-0.72993,148,'LE15 9','Rutland','East Midlands','Hamlet'),
(1817,'Aythorpe Roding','Essex','England','TL584155',558447,215562,51.81623,0.29730,70,'CM6 1','Uttlesford District','Eastern','Locality'),
(1818,'Ayton','Berwickshire','Scotland','NT924610',392405,661018,55.84232,-2.12285,45,'TD14 5','Scottish Borders','Scotland','Village'),
(1819,'Ayton','Tyne and Wear','England','NZ285555',428548,555582,54.89416,-1.55643,92,'NE38 0','Sunderland District','North East','Suburban Area'),
(1820,'Ayton Castle','Berwickshire','Scotland','NT925615',392500,661500,55.84665,-2.12135,66,'TD14 5','Scottish Borders','Scotland','Locality'),
(1821,'Aywick','Shetland','Scotland','HU531866',453140,1186685,60.56017,-1.03269,32,'ZE2 9','Shetland Islands','Scotland','Village'),
(1822,'Azerley','North Yorkshire','England','SE260747',426025,474709,54.16753,-1.60288,100,'HG4 3','North Yorkshire','Yorkshire and the Humber','Hamlet');